/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "mwb-aspect-clone.h"
#include "mwb-page.h"

G_DEFINE_TYPE (MwbAspectClone, mwb_aspect_clone, CLUTTER_TYPE_CLONE)

#define ASPECT_CLONE_PRIVATE(o) \
  (G_TYPE_INSTANCE_GET_PRIVATE ((o), MWB_TYPE_ASPECT_CLONE, MwbAspectClonePrivate))

struct _MwbAspectClonePrivate
{
  ClutterActor *source;
  gulong source_notify;
};

static void
mwb_aspect_clone_dispose (GObject *object)
{
  MwbAspectClonePrivate *priv = MWB_ASPECT_CLONE (object)->priv;

  if (priv->source_notify)
    {
      g_signal_handler_disconnect (priv->source, priv->source_notify);
      priv->source_notify = 0;
    }

  G_OBJECT_CLASS (mwb_aspect_clone_parent_class)->dispose (object);
}

static void
mwb_aspect_clone_get_preferred_width (ClutterActor *actor,
                                      gfloat        for_height,
                                      gfloat       *min_width_p,
                                      gfloat       *nat_width_p)
{
  if (min_width_p)
    *min_width_p = 0;

  if (nat_width_p)
    {
      gfloat height;
      ClutterActor *source = clutter_clone_get_source (CLUTTER_CLONE (actor));

      if (MWB_IS_PAGE (source))
        source = CLUTTER_ACTOR (mwb_page_get_mozembed (MWB_PAGE (source)));

      if (CLUTTER_IS_TEXTURE (source))
        {
          gint w, h;
          clutter_texture_get_base_size (CLUTTER_TEXTURE (source), &w, &h);
          *nat_width_p = w;
          height = h;
        }
      else
        clutter_actor_get_preferred_size (source, NULL, NULL,
                                          nat_width_p, &height);
      if (for_height >= 0)
        *nat_width_p = for_height / height * (*nat_width_p);
    }
}

static void
mwb_aspect_clone_get_preferred_height (ClutterActor *actor,
                                       gfloat        for_width,
                                       gfloat       *min_height_p,
                                       gfloat       *nat_height_p)
{
  if (min_height_p)
    *min_height_p = 0;

  if (nat_height_p)
    {
      gfloat width;
      ClutterActor *source = clutter_clone_get_source (CLUTTER_CLONE (actor));

      if (MWB_IS_PAGE (source))
        source = CLUTTER_ACTOR (mwb_page_get_mozembed (MWB_PAGE (source)));

      if (CLUTTER_IS_TEXTURE (source))
        {
          gint w, h;
          clutter_texture_get_base_size (CLUTTER_TEXTURE (source), &w, &h);
          width = w;
          *nat_height_p = h;
        }
      else
        clutter_actor_get_preferred_size (source, NULL, NULL,
                                          &width, nat_height_p);
      if (for_width >= 0)
        *nat_height_p = for_width / width * (*nat_height_p);
    }
}

static void
mwb_aspect_clone_class_init (MwbAspectCloneClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);
  ClutterActorClass *actor_class = CLUTTER_ACTOR_CLASS (klass);

  g_type_class_add_private (klass, sizeof (MwbAspectClonePrivate));

  object_class->dispose = mwb_aspect_clone_dispose;

  actor_class->get_preferred_width = mwb_aspect_clone_get_preferred_width;
  actor_class->get_preferred_height = mwb_aspect_clone_get_preferred_height;
}

static void
mwb_aspect_clone_source_notify (MwbAspectClone *self, GParamSpec *pspec)
{
  MwbAspectClonePrivate *priv = self->priv;

  if (priv->source_notify)
    {
      g_signal_handler_disconnect (priv->source, priv->source_notify);
      priv->source_notify = 0;
    }

  priv->source = clutter_clone_get_source (CLUTTER_CLONE (self));

  if (priv->source && CLUTTER_IS_TEXTURE (priv->source))
    priv->source_notify =
      g_signal_connect_swapped (priv->source, "size-change",
                                G_CALLBACK (clutter_actor_queue_relayout),
                                self);
}

static void
mwb_aspect_clone_init (MwbAspectClone *self)
{
  self->priv = ASPECT_CLONE_PRIVATE (self);

  g_signal_connect (self, "notify::source",
                    G_CALLBACK (mwb_aspect_clone_source_notify), NULL);
}

ClutterActor*
mwb_aspect_clone_new (ClutterActor *source)
{
  return g_object_new (MWB_TYPE_ASPECT_CLONE, "source", source, NULL);
}

