/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _MWB_DOWNLOAD_MANAGER_H
#define _MWB_DOWNLOAD_MANAGER_H

#include <glib-object.h>
#include <clutter/clutter.h>
#include <clutter-mozembed.h>
#include <nbtk/nbtk.h>

#include "mwb-download-model.h"

G_BEGIN_DECLS

#define MWB_TYPE_DOWNLOAD_MANAGER mwb_download_manager_get_type()

#define MWB_DOWNLOAD_MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MWB_TYPE_DOWNLOAD_MANAGER, MwbDownloadManager))

#define MWB_DOWNLOAD_MANAGER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MWB_TYPE_DOWNLOAD_MANAGER, MwbDownloadManagerClass))

#define MWB_IS_DOWNLOAD_MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MWB_TYPE_DOWNLOAD_MANAGER))

#define MWB_IS_DOWNLOAD_MANAGER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MWB_TYPE_DOWNLOAD_MANAGER))

#define MWB_DOWNLOAD_MANAGER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MWB_TYPE_DOWNLOAD_MANAGER, MwbDownloadManagerClass))

typedef struct _MwbDownloadManagerPrivate MwbDownloadManagerPrivate;

typedef struct {
  NbtkWidget parent;

  MwbDownloadManagerPrivate *priv;
} MwbDownloadManager;

typedef struct {
  NbtkWidgetClass parent_class;

  /* Signals */
  void (* download_added) (MwbDownloadManager *manager);
} MwbDownloadManagerClass;

GType mwb_download_manager_get_type (void);

NbtkWidget* mwb_download_manager_new (void);

void              mwb_download_manager_add (MwbDownloadManager      *dlman,
                                            ClutterMozEmbedDownload *download);
MwbDownloadModel *mwb_download_manager_get_model (MwbDownloadManager *dlman);

G_END_DECLS

#endif /* _MWB_DOWNLOAD_MANAGER_H */

