/* mwb-action.c */

#include "mwb-action.h"

G_DEFINE_TYPE (MwbAction, mwb_action, G_TYPE_INITIALLY_UNOWNED)

#define ACTION_PRIVATE(o) \
  (G_TYPE_INSTANCE_GET_PRIVATE ((o), MWB_TYPE_ACTION, MwbActionPrivate))

struct _MwbActionPrivate
{
  gchar    *name;
  gboolean  active;
};

enum
{
  PROP_0,

  PROP_NAME,
  PROP_ACTIVE
};

enum
{
  ACTIVATED,

  LAST_SIGNAL
};

static guint signals[LAST_SIGNAL] = { 0, };

static void
mwb_action_get_property (GObject *object, guint property_id,
                         GValue *value, GParamSpec *pspec)
{
  MwbAction *action = MWB_ACTION (object);

  switch (property_id)
    {
    case PROP_NAME:
      g_value_set_string (value, mwb_action_get_name (action));
      break;

    case PROP_ACTIVE:
      g_value_set_boolean (value, mwb_action_get_active (action));
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
    }
}

static void
mwb_action_set_property (GObject *object, guint property_id,
                         const GValue *value, GParamSpec *pspec)
{
  MwbAction *action = MWB_ACTION (object);

  switch (property_id)
    {
    case PROP_NAME:
      mwb_action_set_name (action, g_value_get_string (value));
      break;

    case PROP_ACTIVE:
      mwb_action_set_active (action, g_value_get_boolean (value));
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
    }
}

static void
mwb_action_dispose (GObject *object)
{
  G_OBJECT_CLASS (mwb_action_parent_class)->dispose (object);
}

static void
mwb_action_finalize (GObject *object)
{
  G_OBJECT_CLASS (mwb_action_parent_class)->finalize (object);
}

static void
mwb_action_class_init (MwbActionClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  g_type_class_add_private (klass, sizeof (MwbActionPrivate));

  object_class->get_property = mwb_action_get_property;
  object_class->set_property = mwb_action_set_property;
  object_class->dispose = mwb_action_dispose;
  object_class->finalize = mwb_action_finalize;

  g_object_class_install_property (object_class,
                                   PROP_NAME,
                                   g_param_spec_string ("name",
                                                        "Name",
                                                        "Action name.",
                                                        NULL,
                                                        G_PARAM_READWRITE |
                                                        G_PARAM_STATIC_NAME |
                                                        G_PARAM_STATIC_NICK |
                                                        G_PARAM_STATIC_BLURB));

  g_object_class_install_property (object_class,
                                   PROP_ACTIVE,
                                   g_param_spec_boolean ("active",
                                                         "Active",
                                                         "Whether the action "
                                                         "is active.",
                                                         TRUE,
                                                         G_PARAM_READWRITE |
                                                         G_PARAM_STATIC_NAME |
                                                         G_PARAM_STATIC_NICK |
                                                         G_PARAM_STATIC_BLURB));

  signals[ACTIVATED] =
    g_signal_new ("activated",
                  G_TYPE_FROM_CLASS (klass),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET (MwbActionClass, activated),
                  NULL, NULL,
                  g_cclosure_marshal_VOID__VOID,
                  G_TYPE_NONE, 0);
}

static void
mwb_action_init (MwbAction *self)
{
  MwbActionPrivate *priv = self->priv = ACTION_PRIVATE (self);
  priv->active = TRUE;
}

MwbAction *
mwb_action_new (void)
{
  return g_object_new (MWB_TYPE_ACTION, NULL);
}

MwbAction *
mwb_action_new_full (const gchar *name,
                     GCallback    activated_cb,
                     gpointer     user_data)
{
  MwbAction *action = g_object_new (MWB_TYPE_ACTION, "name", name, NULL);

  if (activated_cb)
    g_signal_connect (action, "activated", activated_cb, user_data);

  return action;
}

const gchar *
mwb_action_get_name (MwbAction *action)
{
  return action->priv->name;
}

void
mwb_action_set_name (MwbAction *action, const gchar *name)
{
  MwbActionPrivate *priv = action->priv;
  g_free (priv->name);
  priv->name = g_strdup (name);
  g_object_notify (G_OBJECT (action), "name");
}

gboolean
mwb_action_get_active (MwbAction *action)
{
  return action->priv->active;
}

void
mwb_action_set_active (MwbAction *action, gboolean active)
{
  MwbActionPrivate *priv = action->priv;

  if (priv->active != active)
    {
      priv->active = active;
      g_object_notify (G_OBJECT (action), "active");
    }
}

