/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _MWB_WINDOW_H
#define _MWB_WINDOW_H

#include <glib-object.h>
#include <gtk/gtk.h>

#include "mwb-window.h"

G_BEGIN_DECLS

#define MWB_TYPE_WINDOW mwb_window_get_type()

#define MWB_WINDOW(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MWB_TYPE_WINDOW, MwbWindow))

#define MWB_WINDOW_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MWB_TYPE_WINDOW, MwbWindowClass))

#define MWB_IS_WINDOW(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MWB_TYPE_WINDOW))

#define MWB_IS_WINDOW_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MWB_TYPE_WINDOW))

#define MWB_WINDOW_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MWB_TYPE_WINDOW, MwbWindowClass))

typedef struct _MwbWindowPrivate MwbWindowPrivate;

typedef struct {
  GtkWindow parent;

  MwbWindowPrivate *priv;
} MwbWindow;

typedef struct {
  GtkWindowClass parent_class;

  void (*create_internal_actor) (MwbWindow *self);
} MwbWindowClass;

GType          mwb_window_get_type           (void);

GtkWidget     *mwb_window_new                (void);
void           mwb_window_fullscreen         (MwbWindow *window);
ClutterActor  *mwb_window_get_internal_actor (MwbWindow *window);
GtkWidget     *mwb_window_get_layout         (MwbWindow *window);
GtkWidget     *mwb_window_get_embed          (MwbWindow *window);

G_END_DECLS

#endif /* _MWB_WINDOW_H */

