/* mozhelper: A GObject wrapper for the Mozilla Mozhelper API
 *
 * Copyright (C) 2009  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MOZHELPER_PREFS_H__
#define __MOZHELPER_PREFS_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define MOZHELPER_TYPE_PREFS                                             \
  (mozhelper_prefs_get_type())
#define MOZHELPER_PREFS(obj)                                             \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),                              \
                               MOZHELPER_TYPE_PREFS,                     \
                               MozhelperPrefs))
#define MOZHELPER_PREFS_CLASS(klass)                                     \
  (G_TYPE_CHECK_CLASS_CAST ((klass),                               \
                            MOZHELPER_TYPE_PREFS,                        \
                            MozhelperPrefsClass))
#define MOZHELPER_IS_PREFS(obj)                                          \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                              \
                               MOZHELPER_TYPE_PREFS))
#define MOZHELPER_IS_PREFS_CLASS(klass)                                  \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),                               \
                            MOZHELPER_TYPE_PREFS))
#define MOZHELPER_PREFS_GET_CLASS(obj)                                   \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),                               \
                              MOZHELPER_TYPE_PREFS,                      \
                              MozhelperPrefsClass))

typedef struct _MozhelperPrefs         MozhelperPrefs;
typedef struct _MozhelperPrefsClass    MozhelperPrefsClass;
typedef struct _MozhelperPrefsPrivate  MozhelperPrefsPrivate;

struct _MozhelperPrefsClass
{
  GObjectClass parent_class;

  void (* read)           (MozhelperPrefs    *prefs);
  void (* reset)          (MozhelperPrefs    *prefs);
  void (* app_defaults)   (MozhelperPrefs    *prefs);
  void (* branch_changed) (MozhelperPrefs    *prefs,
                           gint         id,
                           const gchar *domain);
};

struct _MozhelperPrefs
{
  GObject parent;

  MozhelperPrefsPrivate *priv;
};

GType mozhelper_prefs_get_type (void) G_GNUC_CONST;

MozhelperPrefs *mozhelper_prefs_new (void);

gboolean mozhelper_prefs_read_user (MozhelperPrefs  *self,
                              const gchar  *path,
                              GError      **error);

gboolean mozhelper_prefs_reset (MozhelperPrefs  *self,
                          GError      **error);

gboolean mozhelper_prefs_reset_user (MozhelperPrefs  *self,
                               GError      **error);

gboolean mozhelper_prefs_save_pref_file (MozhelperPrefs  *self,
                                   const gchar  *path,
                                   GError      **error);

gboolean mozhelper_prefs_get_branch (MozhelperPrefs  *self,
                               const gchar  *root,
                               gint         *id,
                               GError      **error);

gboolean mozhelper_prefs_get_default_branch (MozhelperPrefs  *self,
                                       const gchar  *root,
                                       gint         *id,
                                       GError      **error);

gboolean mozhelper_prefs_release_branch (MozhelperPrefs  *self,
                                   gint          id,
                                   GError      **error);

gboolean mozhelper_prefs_branch_get_type (MozhelperPrefs  *self,
                                    gint          id,
                                    const gchar  *name,
                                    gint         *type,
                                    GError      **error);

gboolean mozhelper_prefs_branch_get_bool (MozhelperPrefs  *self,
                                    gint          id,
                                    const gchar  *name,
                                    gboolean     *value,
                                    GError      **error);

gboolean mozhelper_prefs_branch_set_bool (MozhelperPrefs  *self,
                                    gint          id,
                                    const gchar  *name,
                                    gboolean      value,
                                    GError      **error);

gboolean mozhelper_prefs_branch_get_int (MozhelperPrefs  *self,
                                   gint          id,
                                   const gchar  *name,
                                   gint         *value,
                                   GError      **error);

gboolean mozhelper_prefs_branch_set_int (MozhelperPrefs  *self,
                                   gint          id,
                                   const gchar  *name,
                                   gint          value,
                                   GError      **error);

gboolean mozhelper_prefs_branch_get_char (MozhelperPrefs  *self,
                                    gint          id,
                                    const gchar  *name,
                                    gchar       **value,
                                    GError      **error);

gboolean mozhelper_prefs_branch_set_char (MozhelperPrefs  *self,
                                    gint          id,
                                    const gchar  *name,
                                    const gchar  *value,
                                    GError      **error);

gboolean mozhelper_prefs_branch_has_user_value (MozhelperPrefs  *self,
                                          gint          id,
                                          const gchar  *name,
                                          gboolean     *result,
                                          GError      **error);

gboolean mozhelper_prefs_branch_lock (MozhelperPrefs  *self,
                                gint          id,
                                const gchar  *name,
                                GError      **error);

gboolean mozhelper_prefs_branch_is_locked (MozhelperPrefs  *self,
                                     gint          id,
                                     const gchar  *name,
                                     gboolean     *result,
                                     GError      **error);

gboolean mozhelper_prefs_branch_unlock (MozhelperPrefs  *self,
                                  gint          id,
                                  const gchar  *name,
                                  GError      **error);

gboolean mozhelper_prefs_branch_get_child_list (MozhelperPrefs   *self,
                                          gint           id,
                                          const gchar   *start,
                                          guint         *len,
                                          gchar       ***array,
                                          GError       **error);

gboolean mozhelper_prefs_branch_add_observer (MozhelperPrefs  *self,
                                        gint          id,
                                        const gchar  *domain,
                                        GError      **error);

gboolean mozhelper_prefs_branch_remove_observer (MozhelperPrefs  *self,
                                           gint          id,
                                           const gchar  *domain,
                                           GError      **error);

G_END_DECLS

#endif /* __MOZHELPER_PREFS_H__ */
