/* mhs: A GObject wrapper for the Mozilla Mhs API
 *
 * Copyright (C) 2009  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MHS_HISTORY_H__
#define __MHS_HISTORY_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define MHS_TYPE_HISTORY                                             \
  (mhs_history_get_type())
#define MHS_HISTORY(obj)                                             \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                   \
                               MHS_TYPE_HISTORY,                     \
                               MhsHistory))
#define MHS_HISTORY_CLASS(klass)                                     \
  (G_TYPE_CHECK_CLASS_CAST ((klass),                                    \
                            MHS_TYPE_HISTORY,                        \
                            MhsHistoryClass))
#define MHS_IS_HISTORY(obj)                                          \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                   \
                               MHS_TYPE_HISTORY))
#define MHS_IS_HISTORY_CLASS(klass)                                  \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),                                    \
                            MHS_TYPE_HISTORY))
#define MHS_HISTORY_GET_CLASS(obj)                                   \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),                                    \
                              MHS_TYPE_HISTORY,                      \
                              MhsHistoryClass))

typedef struct _MhsHistory         MhsHistory;
typedef struct _MhsHistoryClass    MhsHistoryClass;
typedef struct _MhsHistoryPrivate  MhsHistoryPrivate;

struct _MhsHistoryClass
{
  GObjectClass parent_class;

  void (* ac_result_received) (MhsHistory *history,
                               guint32 search_id,
                               const gchar *value,
                               const gchar *comment);
  void (* link_visited)       (MhsHistory *history,
                               const gchar *uri,
                               gint visit_time);
  void (* favorites_received) (MhsHistory *history,
                               gchar **urls,
                               gchar **titles);
  void (* pinned_page) (MhsHistory *history,
                        const gchar *title,
                        const gchar *uri,
                        gint visit_time);
  void (* unpinned_page) (MhsHistory *history,
                          const gchar *uri);
};

struct _MhsHistory
{
  GObject parent;

  MhsHistoryPrivate *priv;
};

GType mhs_history_get_type (void) G_GNUC_CONST;

MhsHistory *mhs_history_new (void);

G_END_DECLS

#endif /* __MHS_HISTORY_H__ */
