/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.update;

import base.drawable.Category;
import base.drawable.InputAPI;
import base.drawable.Kind;
import base.drawable.Topology;
import base.drawable.YCoordMap;
import base.io.MixedDataIO;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import logformat.slog2.LineIDMap;
import logformat.slog2.update.MemoryPipedStream;
import old_base.drawable.Composite;
import old_base.drawable.Primitive;
import old_logformat.slog2.pipe.PipedInputLog;

public class WrappedInputLog
implements InputAPI {
    private int MEM_PIPE_RESIZE_MAX = 10;
    private int KILOBYTES = 1024;
    private PipedInputLog old_dobj_ins;
    private Map kind_map;
    private Map topo_map;
    private MemoryPipedStream mem_pipe;
    private int mem_pipe_resize_count;

    private void updateObject(old_base.io.MixedDataIO mixedDataIO, MixedDataIO mixedDataIO2) {
        this.mem_pipe.reset();
        try {
            mixedDataIO.writeObject(this.mem_pipe.output);
            mixedDataIO2.readObject(this.mem_pipe.input);
        }
        catch (EOFException eOFException) {
            if (this.mem_pipe_resize_count < this.MEM_PIPE_RESIZE_MAX) {
                this.mem_pipe.resizeBuffer(this.mem_pipe.getBufferSize() * 2);
                ++this.mem_pipe_resize_count;
                this.updateObject(mixedDataIO, mixedDataIO2);
            } else {
                System.err.println("WrappedInputLog.updateObject(): Resizing of memory pipe has exceeded " + this.MEM_PIPE_RESIZE_MAX + " times. " + "The memory pipe's buffer size is " + this.mem_pipe.getBufferSize() + " bytes.");
                eOFException.printStackTrace();
                System.exit(1);
            }
        }
        catch (IOException iOException) {
            System.err.println("WrappedInputLog.updateObject(): Composite conversion fails! ");
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    public WrappedInputLog(String string) {
        this.old_dobj_ins = new PipedInputLog(string);
        this.kind_map = new HashMap();
        this.kind_map.put(old_base.drawable.Kind.TOPOLOGY, Kind.TOPOLOGY);
        this.kind_map.put(old_base.drawable.Kind.EOF, Kind.EOF);
        this.kind_map.put(old_base.drawable.Kind.PRIMITIVE, Kind.PRIMITIVE);
        this.kind_map.put(old_base.drawable.Kind.COMPOSITE, Kind.COMPOSITE);
        this.kind_map.put(old_base.drawable.Kind.CATEGORY, Kind.CATEGORY);
        this.kind_map.put(old_base.drawable.Kind.YCOORDMAP, Kind.YCOORDMAP);
        this.topo_map = new HashMap();
        this.topo_map.put(old_base.drawable.Topology.EVENT, Topology.EVENT);
        this.topo_map.put(old_base.drawable.Topology.STATE, Topology.STATE);
        this.topo_map.put(old_base.drawable.Topology.ARROW, Topology.ARROW);
    }

    public boolean isSLOG2() {
        return this.old_dobj_ins.isSLOG2();
    }

    public String getCompatibleHeader() {
        return this.old_dobj_ins.getCompatibleHeader();
    }

    public static void stdoutConfirmation() {
        PipedInputLog.stdoutConfirmation();
    }

    public int getTreeLeafByteSize() {
        return this.old_dobj_ins.getTreeLeafByteSize();
    }

    public short getNumChildrenPerNode() {
        return this.old_dobj_ins.getNumChildrenPerNode();
    }

    public void initialize() {
        this.old_dobj_ins.initialize();
        int n = Math.max(this.old_dobj_ins.getTreeLeafByteSize(), this.KILOBYTES);
        this.mem_pipe = new MemoryPipedStream(n);
        this.mem_pipe_resize_count = 0;
    }

    public Kind peekNextKind() {
        return (Kind)this.kind_map.get(this.old_dobj_ins.peekNextKind());
    }

    public Topology getNextTopology() {
        return (Topology)this.topo_map.get(this.old_dobj_ins.getNextTopology());
    }

    public Category getNextCategory() {
        old_base.drawable.Category category = this.old_dobj_ins.getNextCategory();
        Category category2 = new Category();
        this.updateObject(category, category2);
        return category2;
    }

    public YCoordMap getNextYCoordMap() {
        old_base.drawable.YCoordMap yCoordMap = this.old_dobj_ins.getNextYCoordMap();
        old_logformat.slog2.LineIDMap lineIDMap = new old_logformat.slog2.LineIDMap(yCoordMap);
        LineIDMap lineIDMap2 = new LineIDMap();
        this.updateObject(lineIDMap, lineIDMap2);
        YCoordMap yCoordMap2 = lineIDMap2.toYCoordMap();
        return yCoordMap2;
    }

    public base.drawable.Primitive getNextPrimitive() {
        Primitive primitive = this.old_dobj_ins.getNextPrimitive();
        base.drawable.Primitive primitive2 = new base.drawable.Primitive();
        this.updateObject(primitive, primitive2);
        return primitive2;
    }

    public base.drawable.Composite getNextComposite() {
        Composite composite = this.old_dobj_ins.getNextComposite();
        base.drawable.Composite composite2 = new base.drawable.Composite();
        this.updateObject(composite, composite2);
        return composite2;
    }

    public void close() {
        this.old_dobj_ins.close();
        try {
            this.mem_pipe.close();
        }
        catch (IOException iOException) {
            System.err.println("WrappedInputLog.close(): Memory pipe fails to close() ");
            iOException.printStackTrace();
            System.exit(1);
        }
    }
}

