/*
 * Decompiled with CFR 0.152.
 */
package viewer.convertor;

import java.awt.event.ActionListener;
import javax.swing.Timer;
import viewer.common.SwingWorker;
import viewer.convertor.AdvancingTextArea;
import viewer.convertor.InputStreamThread;
import viewer.convertor.WaitingContainer;

public class SwingProcessWorker
extends SwingWorker {
    private WaitingContainer container;
    private AdvancingTextArea textarea;
    private String[] exec_cmd_ary;
    private Timer process_timer;
    private ActionListener process_progress;
    private Process process;
    private InputStreamThread process_err_task;
    private InputStreamThread process_out_task;
    private int process_istatus;

    public SwingProcessWorker(WaitingContainer waitingContainer, AdvancingTextArea advancingTextArea) {
        this.container = waitingContainer;
        this.textarea = advancingTextArea;
        this.process_progress = null;
        this.process_timer = new Timer(500, this.process_progress);
        this.process_timer.setInitialDelay(0);
        this.process_timer.setCoalesce(true);
        this.process = null;
        this.process_err_task = null;
        this.process_out_task = null;
    }

    public void initialize(String[] stringArray, ActionListener actionListener) {
        this.exec_cmd_ary = stringArray;
        if (this.process_progress != null) {
            this.process_timer.removeActionListener(this.process_progress);
        }
        this.process_progress = actionListener;
        this.process_timer.addActionListener(this.process_progress);
        StringBuffer stringBuffer = new StringBuffer("Executing ");
        for (int i = 0; i < this.exec_cmd_ary.length; ++i) {
            stringBuffer.append(this.exec_cmd_ary[i] + " ");
        }
        stringBuffer.append("....");
        this.textarea.append(stringBuffer.toString());
        Runtime runtime = Runtime.getRuntime();
        try {
            this.process = runtime.exec(this.exec_cmd_ary);
            this.process_err_task = new InputStreamThread(this.process.getErrorStream(), "Error", this.textarea);
            this.process_out_task = new InputStreamThread(this.process.getInputStream(), "Output", this.textarea);
            this.process_istatus = Integer.MIN_VALUE;
            this.container.initializeWaiting();
        }
        catch (Throwable throwable) {
            this.textarea.append("\n> Ending with unexpected Exception! Details in stderr.");
            throwable.printStackTrace();
        }
    }

    public Object construct() {
        try {
            if (this.process_err_task != null) {
                this.process_err_task.start();
            }
            if (this.process_out_task != null) {
                this.process_out_task.start();
            }
            this.process_timer.start();
            this.process_istatus = this.process.waitFor();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public void finished() {
        this.process_timer.stop();
        if (this.process_err_task != null) {
            this.process_err_task.stopRunning();
            this.process_err_task = null;
        }
        if (this.process_out_task != null) {
            this.process_out_task.stopRunning();
            this.process_out_task = null;
        }
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        this.textarea.append("\n> Ending with exit status " + this.process_istatus + "\n");
        this.container.finalizeWaiting();
    }

    public boolean isEndedNormally() {
        return this.process_istatus == 0;
    }
}

