//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: part.h,v 1.5 2004/04/24 14:58:51 wschweer Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __PART_H__
#define __PART_H__

#include <map>

#include <qstring.h>
#include <qcolor.h>

#include "event.h"

class Track;
class MidiTrack;
class WaveTrack;
class Xml;

// typedef std::multimap<unsigned, Event*, std::less<unsigned> >::iterator iEvent;

//---------------------------------------------------------
//   Part
//---------------------------------------------------------

class Part : public PosLen {
      static int snGen;
      int _sn;

      QString _name;
      bool _selected;
      bool _mute;
      int _colorIndex;

   protected:
      Track* _track;
      EventList* _events;

   public:
      Part(Track*);
      Part(Track*, EventList*);
      virtual ~Part();
      int sn()                         { return _sn; }
      void setSn(int n)                { _sn = n; }
      int newSn()                      { return snGen++; }

      virtual Part* clone() const = 0;

      const QString& name() const      { return _name; }
      void setName(const QString& s)   { _name = s; }
      bool selected() const            { return _selected; }
      void setSelected(bool f)         { _selected = f; }
      bool mute() const                { return _mute; }
      void setMute(bool b)             { _mute = b; }
      Track* track() const             { return _track; }
      void setTrack(Track*t)           { _track = t; }
      EventList* events() const        { return _events; }
      const EventList* cevents() const { return _events; }
      int colorIndex() const           { return _colorIndex; }
      void setColorIndex(int idx)      { _colorIndex = idx; }

      iEvent addEvent(Event& p);

      virtual void read(Xml&);
      virtual void write(int, Xml&) const;
//      virtual Event* newEvent() const = 0;
      virtual void dump(int n = 0) const;
      };

//---------------------------------------------------------
//   MidiPart
//---------------------------------------------------------

class MidiPart : public Part {

   public:
      MidiPart(MidiTrack* t) : Part((Track*)t) {}
      MidiPart(MidiTrack* t, EventList* ev) : Part((Track*)t, ev) {}
      virtual ~MidiPart() {}
      virtual MidiPart* clone() const;
      MidiTrack* track() const   { return (MidiTrack*)Part::track(); }

//      virtual Event* newEvent() const;
      virtual void dump(int n = 0) const;
      };

//---------------------------------------------------------
//   WavePart
//---------------------------------------------------------

class WavePart : public Part {

   public:
      WavePart(WaveTrack* t);
      WavePart(WaveTrack* t, EventList* ev);
      virtual ~WavePart() {}
      virtual WavePart* clone() const;
      WaveTrack* track() const   { return (WaveTrack*)Part::track(); }

//      virtual Event* newEvent() const;
      virtual void dump(int n = 0) const;
      };

//---------------------------------------------------------
//   PartList
//---------------------------------------------------------

typedef std::multimap<int, Part*, std::less<unsigned> >::iterator iPart;
typedef std::multimap<int, Part*, std::less<unsigned> >::const_iterator ciPart;

class PartList : public std::multimap<int, Part*, std::less<unsigned> > {
   public:
      iPart findPart(unsigned tick);
      iPart add(Part*);
      void remove(Part* part);
      int index(Part*);
      Part* find(int idx);
      };

#endif

