/*
* libmux - GTK+ Moblin User Experience widgets
 * Copyright (C) 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <gtk/gtk.h>
#include <mux/mux-light-switch.h>
#include <mux/mux-window.h>
#include <mux/mux-frame.h>

int
main (int    argc,
      char **argv)
{
  GtkWidget *window;
  GtkWidget *box, *frame, *label;

  gtk_init (&argc, &argv);

  window = mux_window_new ();
  gtk_window_set_title (GTK_WINDOW (window), "Mux widget test");
  mux_window_set_decorations (MUX_WINDOW (window), MUX_DECOR_CLOSE);
  g_signal_connect (window,
                    "delete-event",
                    (GCallback) gtk_main_quit,
                    NULL);

  box = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (window), box);

  frame = mux_frame_new ();
  gtk_frame_set_label (GTK_FRAME (frame), "MuxFrame with title");
  gtk_box_pack_start_defaults (GTK_BOX (box), frame);
  label = gtk_label_new ("Yes, the icon button images on window titlebar are broken. \n"
                         "My understanding is that the pngs should go in the icon\n"
                         "theme, but they're not there yet...");
  gtk_container_add (GTK_CONTAINER (frame), label);

  frame = mux_frame_new ();
  gtk_box_pack_start_defaults (GTK_BOX (box), frame);
  label = gtk_label_new ("Also I'm using 'bg[NORMAL] = \"#4a535a\"' in all sync ui windows.\n"
                         "This should probably be a default in MuxWindow?");
  gtk_container_add (GTK_CONTAINER (frame), label);

  gtk_widget_show_all (window);

  gtk_main ();
}
