--- Sample schema for card tool
--- For PgSQL8.2 only
--- cardtool_schema-Pg.sql
--- $Id: cardtool_schema-Pg.sql,v 1.1 2008-01-02 13:31:38 anton Exp $

CREATE TABLE cards (
  series NUMERIC(10) NOT NULL DEFAULT 0 CHECK (series >= 0),
  number NUMERIC(10) NOT NULL CHECK (number >= 0),
  nominal NUMERIC(10) NOT NULL DEFAULT 0 CHECK (nominal >= 0),
  pin CHAR(32) NOT NULL,
  status VARCHAR(7) NOT NULL DEFAULT 'OK' CHECK (status = 'OK' OR status = 'BLOCKED' OR status = 'ACTIVE'),
  time_c NUMERIC(10) NOT NULL CHECK (time_c >= 0),
  time_a NUMERIC(10) NOT NULL CHECK (time_a >= 0),
  author VARCHAR(80) NULL,
  PRIMARY KEY (series, number)
);


--- to get a list of series, issue:
--- SELECT series,nominal,time_c FROM cards GROUP BY series;
--- SELECT sum(status), status FROM cards WHERE series=$series GROUP BY status;
