#! /bin/sh 
# Netgraph node configuration script for NeTAMS project (FreeBSD 5.xx only!)
# $Id: netams-netgraphctl.sh,v 1.7 2005-03-03 01:53:36 anton Exp $
#
IFACE=lnc0
MODE=2 # 1=TEE, 2=DIVERT
DEBUG=1 # 1=enable, 0=disable
DEFAULTPOLICY=2 #1=drop, 2=pass, 3=pass_local_ssh

###### You don't have to change anything below this line! #####################
PATH=/usr/local/sbin:/bin:/usr/bin:/usr/sbin:/sbin:/usr/local/bin

nodename=netams_${IFACE}
hookprefix=${IFACE}

if [ $MODE -eq 1 ]; then
	case "$1" in
		stop)
			ngctl shutdown netams:
			ngctl shutdown ${IFACE}_netams_tee:
			ngctl shutdown ${IFACE}:
			kldunload ng_netams > /dev/null 2>&1
			;;
	
		start|*)
			kldload ng_netams > /dev/null 2>&1
			kldunload ng_tee > /dev/null 2>&1
			kldload ng_tee > /dev/null 2>&1
	
			ngctl mkpeer ${IFACE}: tee lower right
			ngctl connect ${IFACE}: lower upper left
			ngctl name ${IFACE}:lower ${IFACE}_netams_tee
			ngctl mkpeer ${IFACE}_netams_tee: netams right2left if_in
			ngctl name ${IFACE}_netams_tee:right2left netams
			ngctl connect ${IFACE}_netams_tee: netams: left2right if_out
			ngctl msg netams: mode $MODE
			ngctl msg netams: debug $DEBUG
			ngctl msg netams: setdefault $DEFAULTPOLICY
			;;
	esac
fi 

if [ $MODE -eq 2 ]; then
	case "$1" in
		stop)
			ngctl shutdown netams:
			kldunload ng_netams > /dev/null 2>&1
			;;
	
		start|*)
			kldload ng_netams > /dev/null 2>&1
			ngctl mkpeer ${IFACE}: netams lower if_in
			ngctl name ${IFACE}:lower netams
			ngctl connect ${IFACE}: netams: upper if_out
			ngctl msg netams: mode $MODE
			ngctl msg netams: debug $DEBUG
			ngctl msg netams: setdefault $DEFAULTPOLICY
			;;
	esac
fi
