/*
 * ChooseConnectionPanel.java
 *
 * Created on March 27, 2008, 9:20 PM
 */

package org.netbeans.modules.dbschema.jdbcimpl.wizard;

import java.awt.Dialog;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/**
 *
 * @author  David
 */
public class ChooseConnectionPanel extends javax.swing.JPanel {
    DatabaseConnection conn = null;
    DialogDescriptor desc = null;
    final String url;

    /** Creates new form ChooseConnectionPanel */
    public ChooseConnectionPanel(String url) {
        this.url = url;
        initComponents();
        DatabaseExplorerUIs.connect(connCombo, ConnectionManager.getDefault());
    }
    
    private void setDialogDescriptor(DialogDescriptor desc) {
        this.desc = desc;
    }
    
    private DatabaseConnection getConnection() {
        Object item = connCombo.getSelectedItem();
        if ( item == null ) {
            return null;
        } else {
            return (DatabaseConnection)item;
        }
    }

    public static DatabaseConnection showChooseConnectionDialog(String url) {
        assert SwingUtilities.isEventDispatchThread();

        ChooseConnectionPanel panel = new ChooseConnectionPanel(url);
        String title = NbBundle.getMessage(ChooseConnectionPanel.class, 
                "ChooseConnectionPanel.LBL_ChooseConnectionTitle");

        DialogDescriptor desc = new DialogDescriptor(panel, title);
        panel.setDialogDescriptor(desc);

        Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
        String acsd = NbBundle.getMessage(ChooseConnectionPanel.class, 
                "ChooseConnectionPanel.ACSD_ChooseConnectionPanel");
        dialog.getAccessibleContext().setAccessibleDescription(acsd);
        dialog.setVisible(true);
        dialog.dispose();

        // The user cancelled
        if (!DialogDescriptor.OK_OPTION.equals(desc.getValue())) {
            return null;
        }
        
        return panel.getConnection();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        connCombo = new javax.swing.JComboBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();

        connCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        connCombo.setToolTipText(org.openide.util.NbBundle.getMessage(ChooseConnectionPanel.class, "ChooseConnectionPanel.connCombo.toolTipText")); // NOI18N

        jTextArea1.setBackground(getBackground());
        jTextArea1.setEditable(false);
        jTextArea1.setFont(javax.swing.UIManager.getFont("Label.font"));
        jTextArea1.setLineWrap(true);
        jTextArea1.setRows(3);
        jTextArea1.setText(org.openide.util.NbBundle.getMessage(ChooseConnectionPanel.class, "ChooseConnectionPanel.jTextArea1.text", new Object[] {url})); // NOI18N
        jTextArea1.setWrapStyleWord(true);
        jTextArea1.setAutoscrolls(false);
        jTextArea1.setBorder(null);
        jTextArea1.setDisabledTextColor(getForeground());
        jTextArea1.setEnabled(false);
        jTextArea1.setOpaque(false);
        jTextArea1.setRequestFocusEnabled(false);
        jScrollPane1.setViewportView(jTextArea1);
        jTextArea1.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ChooseConnectionPanel.class, "ChooseConnectionPanel.jTextArea1.AccessibleContext.accessibleName")); // NOI18N
        jTextArea1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ChooseConnectionPanel.class, "ChooseConnectionPanel.jTextArea1.AccessibleContext.accessibleDescription", new Object[] {url})); // NOI18N
        jTextArea1.getAccessibleContext().setAccessibleParent(this);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, connCombo, 0, 485, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 485, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(18, 18, 18)
                .add(connCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        connCombo.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ChooseConnectionPanel.class, "ChooseConnectionPanel.connCombo.AccessibleContext.accessibleName")); // NOI18N
        connCombo.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ChooseConnectionPanel.class, "ChooseConnectionPanel.connCombo.AccessibleContext.accessibleDescription", new Object[] {url})); // NOI18N

        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ChooseConnectionPanel.class, "ChooseConnectionPanel.AccessibleContext.accessibleName")); // NOI18N
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ChooseConnectionPanel.class, "ChooseConnectionPanel.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox connCombo;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTextArea1;
    // End of variables declaration//GEN-END:variables

}
