/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_NOTIFY_H_
#define _NL_NOTIFY_H_

#include <glib.h>
#include <gdk/gdk.h>
#include <clutter/clutter.h>

#define NL_TYPE_NOTIFY (nl_notify_get_type ())

#define NL_NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	NL_TYPE_NOTIFY, NlNotify))

#define NL_NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	NL_TYPE_NOTIFY, NlNotifyClass))

#define NL_IS_NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	NL_TYPE_NOTIFY))

#define NL_IS_NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	NL_TYPE_NOTIFY))

#define NL_NOTIFY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	NL_TYPE_NOTIFY, NlNotifyClass))

typedef struct _NlNotify        NlNotify;
typedef struct _NlNotifyClass   NlNotifyClass;
typedef struct _NlNotifyPrivate NlNotifyPrivate;
 
struct _NlNotify
{
  ClutterGroup        parent;	

  NlNotifyPrivate *priv;
};

struct _NlNotifyClass
{
  ClutterGroupClass   parent_class;
};

GType nl_notify_get_type (void) G_GNUC_CONST;

NlNotify * nl_notify_get_default (void);

void       nl_notify_popup (NlNotify       *notify,
                            const gchar    *label,
                            CtkImage       *image,
                            gint            pid);

#endif /* _NL_NOTIFY_H_ */

