/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "nl-app-loader.h"

#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gi18n.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include <clutk/clutk.h>
#include <clutter/clutter.h>
#include <clutter-gtk/clutter-gtk.h>
#include <launcher/launcher.h>
#include <netbook-launcher/netbook-launcher.h>

#include "nl-favorite-app.h"

G_DEFINE_TYPE (NlAppLoader, nl_app_loader,
               NL_TYPE_FAVORITES_LOADER);

#define NL_APP_LOADER_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), \
  NL_TYPE_APP_LOADER, \
  NlAppLoaderPrivate))

struct _NlAppLoaderPrivate
{
  NlShell       *shell;
};

enum
{
  PROP_0,
  PROP_SHELL
};

/* Forwards */
static gboolean           handles_type (NlFavoritesLoader *self,
                                        const gchar             *type);
static NlFavorite * load         (NlFavoritesLoader *self,
                                  const gchar             *uid);

/* GObject stuff */
static void
set_property (GObject      *object,
              guint         prop_id,
              const GValue *value,
              GParamSpec   *pspec)
{
  NlAppLoaderPrivate *priv;

  g_return_if_fail (NL_IS_APP_LOADER (object));
  priv = NL_APP_LOADER_GET_PRIVATE (object);

  switch (prop_id)
    {
    case PROP_SHELL:
      priv->shell = g_value_get_pointer (value);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
get_property (GObject      *object,
              guint         prop_id,
              GValue       *value,
              GParamSpec   *pspec)
{
  NlAppLoaderPrivate *priv;

  g_return_if_fail (NL_IS_APP_LOADER (object));
  priv = NL_APP_LOADER_GET_PRIVATE (object);

  switch (prop_id)
    {
    case PROP_SHELL:
      g_value_set_pointer (value, priv->shell);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
nl_app_loader_finalize (GObject *object)
{
  NlAppLoaderPrivate *priv;

  priv = NL_APP_LOADER_GET_PRIVATE (object);

  G_OBJECT_CLASS (nl_app_loader_parent_class)->finalize (object);
}

static void
nl_app_loader_constructed (GObject *object)
{
  NlAppLoaderPrivate *priv;

  priv = NL_APP_LOADER_GET_PRIVATE (object);

  nl_shell_add_favorites_loader (priv->shell,
                                 NL_FAVORITES_LOADER (object));
}

static void
nl_app_loader_class_init (NlAppLoaderClass *klass)
{
  GObjectClass                 *obj_class = G_OBJECT_CLASS (klass);
  NlFavoritesLoaderClass *fav_class;
  GParamSpec                   *pspec;

  fav_class = NL_FAVORITES_LOADER_CLASS (klass);

  obj_class->finalize     = nl_app_loader_finalize;
  obj_class->constructed  = nl_app_loader_constructed;
  obj_class->set_property = set_property;
  obj_class->get_property = get_property;

  fav_class->handles_type = handles_type;
  fav_class->load         = load;

  pspec = g_param_spec_pointer ("shell", "shell", "shell",
                                G_PARAM_READWRITE | G_PARAM_CONSTRUCT);
  g_object_class_install_property (obj_class, PROP_SHELL, pspec);

  g_type_class_add_private (obj_class, sizeof (NlAppLoaderPrivate));
}

static void
nl_app_loader_init (NlAppLoader *loader)
{
  NlAppLoaderPrivate *priv;

  priv = loader->priv = NL_APP_LOADER_GET_PRIVATE (loader);
}

/*
 * Public methods
 */
GObject *
nl_app_loader_new (NlShell *shell)

{
  GObject *app_loader;

  g_return_val_if_fail (NL_IS_SHELL (shell), NULL);

  app_loader = g_object_new (NL_TYPE_APP_LOADER,
                             "shell", shell,
                             NULL);

  return app_loader;
}


/*
 * Private methods
 */
static gboolean
handles_type (NlFavoritesLoader *self,
              const gchar             *type)
{
  NlAppLoaderPrivate *priv;

  priv = NL_APP_LOADER (self)->priv;

  if (g_strcmp0 (type, "application") == 0)
    return TRUE;

  return FALSE;
}

static NlFavorite *
load (NlFavoritesLoader *self,
      const gchar             *uid)
{
  NlAppLoaderPrivate *priv;
  NlFavorite *fav = NULL;

  g_return_val_if_fail (NL_IS_APP_LOADER (self), NULL);
  priv = NL_APP_LOADER (self)->priv;

  fav = nl_favorite_app_new (uid);

  return fav;
}

/*
 * Public Methods
 */
