/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <gtk/gtk.h>
#include "nmn-icon-cache.h"

static GtkIconTheme *icon_theme = NULL;
static GHashTable *cache = NULL;

void
nmn_icon_cache_invalidate (void)
{
    if (cache) {
        g_hash_table_destroy (cache);
        cache = NULL;
    }

    if (icon_theme)
        icon_theme = NULL;
}

GdkPixbuf *
nmn_icon_cache_get (const char *icon_name)
{
    GdkPixbuf *pixbuf;
    GError *error = NULL;

    g_return_val_if_fail (icon_name != NULL, NULL);

    if (G_UNLIKELY (icon_theme == NULL)) {
        icon_theme = gtk_icon_theme_get_for_screen (gdk_screen_get_default ());
        g_signal_connect (icon_theme, "changed", G_CALLBACK (nmn_icon_cache_invalidate), NULL);
    }

    if (G_UNLIKELY (cache == NULL)) {
        cache = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref);
        pixbuf = NULL;
    } else
        pixbuf = (GdkPixbuf *) g_hash_table_lookup (cache, icon_name);

    if (!pixbuf) {
		pixbuf = gtk_icon_theme_load_icon (icon_theme, icon_name, 48, 0, &error);
        if (pixbuf)
            g_hash_table_insert (cache, g_strdup (icon_name), pixbuf);
    }

    if (error) {
        g_warning ("Error loading icon '%s': %s", icon_name, error->message);
        g_error_free (error);
    }

    return pixbuf;
}
