/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#ifndef NMN_ETHERNET_ITEM_H
#define NMN_ETHERNET_ITEM_H

#include <nmn-network-item.h>
#include <nm-device-ethernet.h>
#include "nmn-nm-data.h"

#define NMN_TYPE_ETHERNET_ITEM            (nmn_ethernet_item_get_type ())
#define NMN_ETHERNET_ITEM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NMN_TYPE_ETHERNET_ITEM, NmnEthernetItem))
#define NMN_ETHERNET_ITEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NMN_TYPE_ETHERNET_ITEM, NmnEthernetItemClass))
#define NMN_IS_ETHERNET_ITEM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NMN_TYPE_ETHERNET_ITEM))
#define NMN_IS_ETHERNET_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((obj), NMN_TYPE_ETHERNET_ITEM))
#define NMN_ETHERNET_ITEM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NMN_TYPE_ETHERNET_ITEM, NmnEthernetItemClass))

typedef struct {
    NmnNetworkItem parent;
} NmnEthernetItem;

typedef struct {
    NmnNetworkItemClass parent;
} NmnEthernetItemClass;

GType nmn_ethernet_item_get_type (void);

GtkWidget *nmn_ethernet_item_new (NmnNMData *nm_data,
                                  NMDeviceEthernet *device);

#endif /* NMN_ETHERNET_ITEM_H */
