/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#ifndef NMN_SERIAL_ITEM_H
#define NMN_SERIAL_ITEM_H

#include <nmn-network-item.h>
#include <nm-serial-device.h>
#include "nmn-nm-data.h"

#define NMN_TYPE_SERIAL_ITEM            (nmn_serial_item_get_type ())
#define NMN_SERIAL_ITEM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NMN_TYPE_SERIAL_ITEM, NmnSerialItem))
#define NMN_SERIAL_ITEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NMN_TYPE_SERIAL_ITEM, NmnSerialItemClass))
#define NMN_IS_SERIAL_ITEM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NMN_TYPE_SERIAL_ITEM))
#define NMN_IS_SERIAL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((obj), NMN_TYPE_SERIAL_ITEM))
#define NMN_SERIAL_ITEM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NMN_TYPE_SERIAL_ITEM, NmnSerialItemClass))

typedef struct {
    NmnNetworkItem parent;
} NmnSerialItem;

typedef struct {
    NmnNetworkItemClass parent;
} NmnSerialItemClass;

GType nmn_serial_item_get_type (void);

GtkWidget *nmn_serial_item_new (NmnNMData *nm_data,
                                NMSerialDevice *device);

#endif /* NMN_SERIAL_ITEM_H */
