
#include "CustomStaticText.h"

#include <wx/dcclient.h>

IMPLEMENT_DYNAMIC_CLASS (CustomStaticText, wxStaticText)

BEGIN_EVENT_TABLE(CustomStaticText, wxStaticText)
    EVT_PAINT(CustomStaticText::OnPaint)
END_EVENT_TABLE()

CustomStaticText::CustomStaticText() : wxStaticText(), m_textColor(0, 0, 0)
{
}

CustomStaticText::CustomStaticText(wxWindow *parent, wxWindowID id, const wxString& label, const wxPoint& pos,
        const wxSize& size, long style, const wxString& name)
        : wxStaticText(), m_textColor(0, 0, 0)
{
    Create(parent, id, label, pos, size, style, name);
}

CustomStaticText::~CustomStaticText()
{
}

bool CustomStaticText::Create(wxWindow* parent, wxWindowID id, const wxString& label, const wxPoint& pos,
        const wxSize& size, long style, const wxString& name)
{
    bool bRetVal = wxStaticText::Create(parent, id, label, pos, size, style|wxTRANSPARENT_WINDOW, name);
	SetBackgroundColour(parent->GetBackgroundColour());
	SetBackgroundStyle(wxBG_STYLE_COLOUR);
	wxStaticText::SetForegroundColour(parent->GetForegroundColour());
    return bRetVal;
}

void CustomStaticText::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);
    dc.SetFont(GetFont());
    dc.SetTextBackground(m_textColor);
    dc.SetTextForeground(m_textColor);
    dc.DrawText(GetLabel(), 0, 0);
}

void CustomStaticText::SetTextColor(const wxColour& textColor)
{
    m_textColor = textColor;
}

bool CustomStaticText::SetForegroundColour(const wxColour& colour)
{
    SetTextColor(colour);
    return wxStaticText::SetForegroundColour(colour);
}
