#include "ENMApplyProfileBalloon.h"
#include "ENMApp.h"
#include "CustomStaticText.h"
#include "ENMTaskTray.h"

#if defined(__WXMSW__)
#include <windows.h>
#endif

const long ENMApplyProfileBalloon::ID_STATICTEXT_PROFILENAME = wxNewId();
const long ENMApplyProfileBalloon::ID_GAUGE_APPLYBALLOON = wxNewId();
const long ENMApplyProfileBalloon::ID_STATICTEXT_NETWORKTYPE = wxNewId();
const long ENMApplyProfileBalloon::ID_TIMER_APPLYBALLOON = wxNewId();
const long ENMApplyProfileBalloon::ID_BTN_CLOSE = wxNewId();

const int WIDTH = 270;
const int HEIGHT = 140;
const int ADJUST_HEIGHT = 30;
BEGIN_EVENT_TABLE(ENMApplyProfileBalloon, wxBitmapDialog)
    EVT_TIMER(ID_TIMER_APPLYBALLOON, ENMApplyProfileBalloon::OnTimer)
    EVT_BUTTON(ID_BTN_CLOSE, ENMApplyProfileBalloon::OnButtonClick)
END_EVENT_TABLE()

#if defined(__WXMSW__)
ENMApplyProfileBalloon::ENMApplyProfileBalloon(wxBitmapDialog *dlg, const wxString &title)
    : wxBitmapDialog(wxBitmap(::wxGetApp().strAppPath + _T("pic\\balloon_LAN.png"),wxBITMAP_TYPE_PNG),(wxWindow*)dlg, (wxWindowID)wxID_ANY, wxEmptyString)
{

    m_profileName = new CustomStaticText(this, ID_STATICTEXT_PROFILENAME, _T(""), wxPoint(20,14), wxSize(224,16), 0, _T("ID_STATICTEXT_PROFILENAME"));
    m_profileName->SetBackgroundColour(wxColour(238,238,233));
	m_pGauge = new wxGauge(this, ID_GAUGE_APPLYBALLOON, 100, wxPoint(20,54), wxSize(230,28), 0, wxDefaultValidator, _T("ID_GAUGE_APPLYBALLOON"));
	m_networkType = new CustomStaticText(this, ID_STATICTEXT_NETWORKTYPE, _T(""), wxPoint(20,102), wxSize(224,16), 0, _T("ID_STATICTEXT_NETWORKTYPE"));
	m_networkType->SetBackgroundColour(wxColour(233,232,225));
//	m_btnClose = new wxBitmapButton(this, ID_BTN_CLOSE, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\close.png"))), wxPoint(235,8), wxDefaultSize, wxBU_AUTODRAW|wxNO_BORDER, wxDefaultValidator, _T("ID_BTN_CANCEL"));
	m_btnClose = new wxButton(this, ID_BTN_CLOSE, _("Stop"), wxPoint(160,95), wxSize(90,28), 0, wxDefaultValidator, _T("ID_BTN_CLOSE"));
	m_ApplyBalloonTimer.SetOwner(this, ID_TIMER_APPLYBALLOON);
	m_ApplyBalloonTimer.Start(1000);
	iCount = 0;
	m_pGauge->SetValue(iCount);
	wxPoint finalPos;
    int width = 0;
    int height = 0;
    ::wxDisplaySize(&width, &height);
    finalPos = wxPoint(width - WIDTH, height - HEIGHT - ADJUST_HEIGHT);
	this->Move(finalPos);
    SetWindowLong((HWND)this->m_hWnd, GWL_EXSTYLE, WS_EX_TOOLWINDOW | WS_EX_DLGMODALFRAME);
}
#endif

#if defined(__UNIX__)
ENMApplyProfileBalloon::ENMApplyProfileBalloon(wxBitmapDialog *dlg, const wxString &title)
    : wxBitmapDialog(wxBitmap(::wxGetApp().strAppPath + _T("pic/balloon_LAN.png"),wxBITMAP_TYPE_PNG),(wxWindow*)dlg, (wxWindowID)wxID_ANY, wxEmptyString)
{

    m_profileName = new CustomStaticText(this, ID_STATICTEXT_PROFILENAME, _T(""), wxPoint(20,14), wxSize(224,16), 0, _T("ID_STATICTEXT_PROFILENAME"));
    m_profileName->SetBackgroundColour(wxColour(238,238,233));
	m_pGauge = new wxGauge(this, ID_GAUGE_APPLYBALLOON, 100, wxPoint(20,54), wxSize(230,30), 0, wxDefaultValidator, _T("ID_GAUGE_APPLYBALLOON"));
	m_networkType = new CustomStaticText(this, ID_STATICTEXT_NETWORKTYPE, _T(""), wxPoint(20,102), wxSize(224,16), 0, _T("ID_STATICTEXT_NETWORKTYPE"));
	m_networkType->SetBackgroundColour(wxColour(233,232,225));
//	m_btnClose = new wxBitmapButton(this, ID_BTN_CLOSE, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/close.png"))), wxPoint(230,8), wxDefaultSize, wxBU_AUTODRAW|wxNO_BORDER, wxDefaultValidator, _T("ID_BTN_CANCEL"));
	m_btnClose = new wxButton(this, ID_BTN_CLOSE, _("Stop"), wxPoint(160,95), wxSize(90,28), 0, wxDefaultValidator, _T("ID_BTN_CLOSE"));
	m_ApplyBalloonTimer.SetOwner(this, ID_TIMER_APPLYBALLOON);
	m_ApplyBalloonTimer.Start(1000);
	iCount = 0;
	m_pGauge->SetValue(iCount);
	wxPoint finalPos;
    int width = 0;
    int height = 0;
    ::wxDisplaySize(&width, &height);
    finalPos = wxPoint(width - WIDTH, 0);
	this->Move(finalPos);
}
#endif

void ENMApplyProfileBalloon::OnTimer(wxTimerEvent& event)
{
    if ( iCount < 100 )
    {
        iCount += 10;
        m_pGauge->SetValue(iCount);
    }
    else
    {
        iCount = 0;
    }
}

void ENMApplyProfileBalloon::StopTimer()
{
    m_ApplyBalloonTimer.Stop();
}

void ENMApplyProfileBalloon::CallExit()
{
    m_pGauge->SetValue(m_pGauge->GetRange());
    wxThread::Sleep(20);
    m_ApplyBalloonTimer.Stop();
    this->Show(false);
}

void ENMApplyProfileBalloon::SetApplyProfileName(wxString wxsProfileName)
{
    m_profileName->SetLabel(_("Applying ") + wxsProfileName);
    m_profileName->SetForegroundColour(wxColor(0, 0, 255));
    wxFont StaticText1Font(11, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_profileName->SetFont(StaticText1Font);
	wxSize size = m_profileName->GetSize();
	//wxMessageBox(wxString::Format(wxT("%d:%d"), size.GetWidth(), size.GetHeight()));
	if ( size.GetWidth() > 260 )
	{
	    wxString strFirst = wxsProfileName.Mid(0, 10);
	    m_profileName->SetLabel(_("Applying ") + strFirst + _T("..."));
	}

}

void ENMApplyProfileBalloon::SetTurningOnNetwork(wxString wxsNetworkType)
{

    m_networkType->SetLabel(_("Turning on ") + wxsNetworkType + _("..."));
}

void ENMApplyProfileBalloon::SetGaugeCount(int iPostion)
{
    iCount = iPostion;
}


void ENMApplyProfileBalloon::OnButtonClick(wxCommandEvent& event)
{
//    CallExit();
    ENMTaskTray::GetInstance()->StopApplyConnecting();
}

