#include "NetSecrityDlg.h"
#include "ENMApp.h"

//(*InternalHeaders(NetSecrityDlg)
#include <wx/intl.h>
#include <wx/string.h>
//*)
#if defined(__WXMSW__)
#include "ENMUtil.h"
#endif

//(*IdInit(NetSecrityDlg)
const long NetSecrityDlg::ID_CBINTERNET = wxNewId();
#if defined(__WXMSW__)
const long NetSecrityDlg::ID_CBFILE = wxNewId();
const long NetSecrityDlg::ID_CBFIREWALL = wxNewId();
#endif
const long NetSecrityDlg::ID_BTNOK = wxNewId();
const long NetSecrityDlg::ID_BTNCANCEL = wxNewId();
//*)
const long NetSecrityDlg::ID_HELP = wxNewId();
BEGIN_EVENT_TABLE(NetSecrityDlg,wxDialog)
	//(*EventTable(NetSecrityDlg)
	//*)
#if defined(__WXMSW__)
	EVT_CHECKBOX(ID_CBFILE, NetSecrityDlg::OnCheckboxFileClicked)
	EVT_CHECKBOX(ID_CBFIREWALL, NetSecrityDlg::OnCheckboxFirewallClicked)
#endif
END_EVENT_TABLE()

NetSecrityDlg::NetSecrityDlg(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{

	Create(parent, id, _("Network Security"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
#if defined(__WXMSW__)
	//(*Initialize(NetSecrityDlg)
	SetClientSize(wxSize(343,173));
	Move(wxDefaultPosition);
	m_cbFile = new wxCheckBox(this, ID_CBFILE, _("Forbid sharing files and printer"), wxPoint(16,14), wxSize(300,40), 0, wxDefaultValidator, _T("ID_CBFILE"));
	m_cbFile->SetValue(false);
	m_cbInternet = new wxCheckBox(this, ID_CBINTERNET, _("Forbid sharing Internet connection"), wxPoint(16,54), wxSize(300,40), 0, wxDefaultValidator, _T("ID_CBINTERNET"));
	m_cbInternet->SetValue(false);
	m_cbFirewall = new wxCheckBox(this, ID_CBFIREWALL, _("Startup Windows firewall"), wxPoint(16,94), wxSize(300,40), 0, wxDefaultValidator, _T("ID_CBFIREWALL"));
	m_cbFirewall->SetValue(false);
	m_btnOK = new wxButton(this, ID_BTNOK, _("OK"), wxPoint(155,136), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BTNOK"));
	m_btnCancel = new wxButton(this, ID_BTNCANCEL, _("Cancel"), wxPoint(250,136), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BTNCANCEL"));
	//*)
#endif
#if defined(__UNIX__)
    SetClientSize(wxSize(343,103));
	Move(wxDefaultPosition);
	m_cbInternet = new wxCheckBox(this, ID_CBINTERNET, _("Forbid sharing internet connection"), wxPoint(16,16), wxSize(312,22), 0, wxDefaultValidator, _T("ID_CBINTERNET"));
	m_cbInternet->SetValue(false);
	m_btnOK = new wxButton(this, ID_BTNOK, _("OK"), wxPoint(145,66), wxSize(88,32), 0, wxDefaultValidator, _T("ID_BTNOK"));
	m_btnCancel = new wxButton(this, ID_BTNCANCEL, _("Cancel"), wxPoint(245,66), wxSize(88,32), 0, wxDefaultValidator, _T("ID_BTNCANCEL"));
#endif
	Connect(ID_BTNOK,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&NetSecrityDlg::Onm_btnOKClick);
	Connect(ID_BTNCANCEL,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&NetSecrityDlg::Onm_btnCancelClick);
	Connect(wxID_ANY,wxEVT_INIT_DIALOG,(wxObjectEventFunction)&NetSecrityDlg::OnInit);
	Connect(ID_HELP,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&NetSecrityDlg::OnF1Press);
    wxAcceleratorEntry entries[1];

    entries[0].Set( wxACCEL_NORMAL, WXK_F1, ID_HELP );

    wxAcceleratorTable accel(1, entries);

    SetAcceleratorTable(accel);
}

NetSecrityDlg::~NetSecrityDlg()
{
	//(*Destroy(NetSecrityDlg)
	//*)
}

void NetSecrityDlg::OnInit(wxInitDialogEvent& event)
{
    Center();
    m_cbInternet->SetFocus();
}

void NetSecrityDlg::Onm_btnOKClick(wxCommandEvent& event)
{
    EndModal(wxID_OK);
}

void NetSecrityDlg::Onm_btnCancelClick(wxCommandEvent& event)
{
    EndModal(wxID_CANCEL);
}

#if defined(__WXMSW__)
void NetSecrityDlg::OnCheckboxFileClicked(wxCommandEvent& event)
{
    if ( m_cbFile->IsChecked() )
    {
        m_cbFirewall->SetValue(true);
    }
}

void NetSecrityDlg::OnCheckboxFirewallClicked(wxCommandEvent& event)
{
    if ( !m_cbFirewall->IsChecked() )
    {
        m_cbFile->SetValue(false);
    }
}
#endif

void NetSecrityDlg::OnF1Press(wxCommandEvent& event)
{
#if defined(__UNIX__)
    if(wxFileExists(wxT("/usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf")))
    {
        wxString cmd = wxT("evince /usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf --page-label=29");
        //wxExecute(cmd);
    }
#endif
#if defined(__WXMSW__)
    ENMUtil::ShowContextHelp(this, _T("SecuritySetting"));
#endif
}
