/***************************************************************
 * Name:      NetworkManagerDlg.h
 * Purpose:   Defines Application Frame
 * Author:    mw ()
 * Created:   2008-07-09
 * Copyright: mw ()
 * License:
 **************************************************************/

#ifndef NETWORKMANAGERDLG_H
#define NETWORKMANAGERDLG_H

#include <wx/wx.h>
#include <wx/bmpcbox.h>

#if defined(__UNIX__)
//#include <net/if.h>
#endif
#include "Profile.h"
#include "ViewAPNeighborsDlg.h"
#if defined(__WXMSW__)
#include "CmpcBitmapButton.h"
#endif

#include "WlanScanner.h"
#include "DataCenter.h"
#include "wlanacmevent.h"
#include "ProfileEvent.h"
#include "SwitchAdapterEvent.h"
#include "SchoolSettingImporter.h"
#include "WirelessEvent.h"
#include <vector>

class NetworkManagerDlg: public wxFrame
{
    public:
        void UI_UpdateNetworkMode(NETWORK_MODE networkMode);
        void UI_UpdateNetworkStatusInfo(NETWORK_MODE networkMode,UI_NETWORK_STATUS_INFO& statusInfo);
        NetworkManagerDlg(wxWindow* parent,wxWindowID id = -1);
        virtual ~NetworkManagerDlg();
        virtual bool Destroy();
        virtual bool Show(bool show = true);
        bool IsApplyingProfile() const;
        void ShowApplyingProcessDialog(const wxString& profileName = wxEmptyString, bool show = true);
        wxString wxOldIP;
        void SetNetworkProfile();
        void SetNetworkProfile_NN();
        void RefreshProfileList();
        void EnableViewNb();
        void OnConnectProfile();
        wxMenuItem* m_menuMeshDC;
    protected:
        //void SetNetworkProfile();
        void SetComboxCurrentProfileName();
        void OnActivate(wxActivateEvent& event);

    private:
        void SetWirelessSwitch();
        void ImportSchoolSetting(wxCommandEvent& event);
        void ConnectProfile(wxCommandEvent& event);
        void Exit(wxCommandEvent& event);
        void MenuScanNw(wxCommandEvent& event);
        void MenuViewNghbr(wxCommandEvent& event);
        void MenuProfileMgr(wxCommandEvent& event);
        void MenuCtrlWrls(wxCommandEvent& event);
        void MenuHelpContent(wxCommandEvent& event);
        void MenuAbout(wxCommandEvent& event);
        void MenuMeshConf(wxCommandEvent& event);

        void OnButtonCtrlCnctClick(wxCommandEvent& event);
        void OnButtonScanNwClick(wxCommandEvent& event);
        void OnButtonViewNghbrClick(wxCommandEvent& event);
        void OnButtonPrflMgrClick(wxCommandEvent& event);
        void OnButtonCtrlWrlsClick(wxCommandEvent& event);
        void Onm_cmbSwitchPrflSelect(wxCommandEvent& event);
        //void OnConnectProfile();

        void OnWlanAcmEvent(WlanAcmEvent& event);
        void OnProfileChangedEvent(ProfileEvent& event);
        void OnSwitchAdapterEvent(SwitchAdapterEvent& event);
        void OnWirelessNetworkChanged(const WirelessSwitchEvent& event);
        void OnTimer(wxTimerEvent& event);

        void RefreshProfileName();
        void DisableSQInfo();
        void EnableSQInfo();
        void DisableScanNTandViewNb();
        void EnableScanNTandViewNb();

        static const long ID_CMBSWITCHPRFL;
        static const long ID_STCNPTITLE;
        static const long ID_STBNWINFO;
        static const long ID_STCSQTITLE;
        static const long ID_STCIPADDRTITLE;
        static const long ID_STCIPADDR;
        static const long ID_STCSTATUS;
        static const long ID_STCTYPE;
        static const long ID_STCTYPETITLE;
        static const long ID_STCSQVAL;
        static const long ID_STCSTATUSTITLE;
        static const long ID_GAUGESQ;
        static const long ID_BTNSCANNW;
        static const long ID_BTNVIEWNGHBR;
        static const long ID_BTNPRFLMGR;
        static const long ID_SCANNTBTNTEXT;
        static const long ID_NEIGHBORTEXT;
        static const long ID_PRFLMGRTEXT;
        static const long ID_SCANMWBMP;
        static const long ID_NGHBRBMP;
        static const long ID_PRFLMGRBMP;
        static const long ID_PANELRIGHT;
        static const long ID_STCCURRENTPROF;
        static const long ID_BTNCTRLCONNECT;
        static const long ID_BTNCTRLWRLS;
        static const long ID_NWINFOBMP;
        static const long ID_PANELLEFT;
        static const long ID_IMPORT;
        static const long ID_EXIT;
        static const long ID_CNCTPRFL;
        static const long ID_SCANNW;
        static const long ID_VIEWNGHBR;
        static const long ID_PRFLMGR;
        static const long ID_MDC;
        static const long ID_CTRLWRLS;
        static const long ID_HLPCONT;
        static const long ID_ABOUT;
        static const long ID_BMPSCANNW;
        static const long ID_BMPNEIGHBOR;
        static const long ID_BMPPRFLMGR;
        static const long ID_STCPRFLBMP;
        static const long ID_MESHCONFIGURATION;
        static const int ID_TIMER_PROFILE;
        static const int ID_TIMER_WIRELESS;

        wxString m_strFromMenu;

        wxMenuBar* m_mbFile;
        wxStaticBox* m_stbNwInfo;
        wxBitmapComboBox* m_cmbSwitchPrfl;
        wxStaticBitmap *m_NwInfoBmp;
        wxStaticBitmap* m_stcPrflBmp;

        GaugeDialog* m_pGaugeDialog;
        wxGauge* m_gueSQ;
        wxBitmap *m_bmpPrfl;
        wxPanel* m_pnlRight;
        wxPanel* m_pnlLeft;

        wxStaticText* m_stcNpTitle;
        wxStaticText* m_stcCurrentPfle;
        wxStaticText* m_stcSQTitle;
        wxStaticText* m_stcSQVal;
        wxStaticText* m_stcStatusTitle;
        wxStaticText* m_stcStatus;
        wxStaticText* m_stcTypeTitle;
        wxStaticText* m_stcType;
        wxStaticText* m_stcIPAddrTitle;
        wxStaticText* m_stcIPAddr;

        wxMenuItem* m_menuCtrlWrls;
        wxMenuItem* m_menuCnctPrfl;
        wxMenuItem* m_menuImpSetting;
        wxMenuItem* m_menuScanNW;
        wxMenuItem* m_menuPrflMgr;
        wxMenuItem* m_menuAboutContent;
        wxMenuItem* m_menuViewNghbr;
        wxMenuItem* m_menuHelpContent;
        wxMenuItem* m_menuExitDlg;
//        wxMenuItem* m_menuMeshDC;

        wxButton* m_btnCtrlConnect;
        wxButton* m_btnCtrlWireless;

        vector<ProfileList_t> m_profileVector;
        wxTimer m_timerProfile;
        wxTimer m_timerWireless;

        #if defined(__WXMSW__)
        wxBitmap *ScanNwBmp;
        wxBitmap *NeighborBmp;
        wxBitmap *PrflMgrBmp;
        CmpcBitmapButton *m_bBtnScanNw;
        CmpcBitmapButton *m_bBtnViewNeighbor;
        CmpcBitmapButton *m_bBtnPrflMgr;
        #endif

        #if defined(__UNIX__)
        wxStaticBitmap *ScanNwBmp;
        wxStaticBitmap *NeighborBmp;
        wxStaticBitmap *PrflMgrBmp;

        wxButton* m_btnScanNwLnx;
        wxButton* m_btnPrflMgrLnx;
        wxButton* m_btnViewNghbrLnx;


        wxArrayString m_arrStrInterface;

        wxStaticText* ScanNtBtnText;
        wxStaticText* NeightorText;
        wxStaticText* PrflMgrText;
        #endif

        ViewAPNeighborsDlg* viewAPNeighborsDlg;
        SchoolSettingImporter m_importer;

        bool m_isApplyingProfile;
        bool bConnectFinish;
        int m_iSelectedToApply;

        DECLARE_EVENT_TABLE()
};

#endif // NETWORKMANAGERDLG_H
