#include "PopupConfirmDialog.h"
#include <wx/bitmap.h>
#include <wx/settings.h>
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
#include <wx/dcclient.h>
#include <wx/frame.h>
#include <wx/msgdlg.h>
#include "ENMApp.h"

const long TIMER_INTERVAL = 10000;

const long PopupConfirmDialog::ID_STATICBITMAP1 = wxNewId();
const long PopupConfirmDialog::ID_STATICTEXT_TITLE = wxNewId();
const long PopupConfirmDialog::ID_STATICTEXT_CONTENT_LINE1 = wxNewId();
const long PopupConfirmDialog::ID_STATICTEXT_CONTENT_LINE2 = wxNewId();
const long PopupConfirmDialog::ID_STATICTEXT_CONTENT_LINE3 = wxNewId();
//const long PopupConfirmDialog::ID_BTN_CLOSE = wxNewId();
const long PopupConfirmDialog::ID_BTN_OK = wxNewId();
const long PopupConfirmDialog::ID_BTN_CANCEL = wxNewId();
const long PopupConfirmDialog::ID_TIMER_TICK = wxNewId();
const long PopupConfirmDialog::ID_STATICTEXTOK = wxNewId();

const int WIDTH = 247;
const int HEIGHT = 148;
const int ADJUST_HEIGHT = 30;

BEGIN_EVENT_TABLE(PopupConfirmDialog, wxDialog)
    EVT_PAINT(PopupConfirmDialog::OnPaint)
#ifdef __WXGTK__
    EVT_WINDOW_CREATE(PopupConfirmDialog::OnWindowCreate)
#endif
    EVT_BUTTON(ID_BTN_CANCEL, PopupConfirmDialog::OnButtonClick)
    EVT_BUTTON(ID_BTN_OK, PopupConfirmDialog::OnButtonClick)
//    EVT_BUTTON(ID_BTN_CLOSE, PopupConfirmDialog::OnButtonClick)
    EVT_TIMER(ID_TIMER_TICK,PopupConfirmDialog::OnTimerTick)

END_EVENT_TABLE()

PopupConfirmDialog::PopupConfirmDialog(wxWindow* parent, const wxBitmap& bitmap, wxWindowID id)
        : wxDialog(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxSTAY_ON_TOP | wxFRAME_SHAPED | wxNO_BORDER | wxFRAME_NO_TASKBAR)
        , m_bitmap(bitmap)
        , m_Timer(this, ID_TIMER_TICK)
{
    m_hasShape = false;
//	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxSTAY_ON_TOP|wxDEFAULT_DIALOG_STYLE|wxFRAME_SHAPED|wxNO_BORDER, _T("id"));
    SetSize(wxSize(m_bitmap.GetWidth(), m_bitmap.GetHeight()));
	#if defined(__WXMSW__)
	wxStaticBitmap* pBackground = new wxStaticBitmap(this, wxID_ANY, m_bitmap);
	m_pTitle = new CustomStaticText(pBackground, ID_STATICTEXT_TITLE, _T(""), wxPoint(16,16), wxDefaultSize, wxTRANSPARENT_WINDOW, _T("ID_STATICTEXT_TITLE"));
	#endif
	#if defined(__UNIX__)
	m_pTitle = new CustomStaticText(this, ID_STATICTEXT_TITLE, _T(""), wxPoint(16,16), wxDefaultSize, wxTRANSPARENT_WINDOW, _T("ID_STATICTEXT_TITLE"));
	#endif
	m_pTitle->SetForegroundColour(wxColor(0, 0, 255));
    wxFont StaticText1Font(11, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_pTitle->SetFont(StaticText1Font);
//	#if defined(__WXMSW__)
//	m_btnClose = new wxBitmapButton(this, ID_BTN_CLOSE, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\close.png"))), wxPoint(210,14), wxDefaultSize, wxBU_AUTODRAW|wxNO_BORDER, wxDefaultValidator, _T("ID_BTN_CANCEL"));
//    #endif
//
//    #if defined(__UNIX__)
//	m_btnClose = new wxBitmapButton(this, ID_BTN_CLOSE, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/close.png"))), wxPoint(210,14), wxDefaultSize, wxBU_AUTODRAW|wxNO_BORDER, wxDefaultValidator, _T("ID_BTN_CANCEL"));
//    #endif
    #if defined(__WXMSW__)
    m_pContentLine1= new CustomStaticText(pBackground, ID_STATICTEXT_CONTENT_LINE1, _T(""), wxPoint(16,40), wxDefaultSize, wxTRANSPARENT_WINDOW, _T("ID_STATICTEXT_CONTENT_LINE1"));
    #endif
	#if defined(__UNIX__)
	m_pContentLine1= new CustomStaticText(this, ID_STATICTEXT_CONTENT_LINE1, _T(""), wxPoint(16,40), wxDefaultSize, wxTRANSPARENT_WINDOW, _T("ID_STATICTEXT_CONTENT_LINE1"));
	#endif
	m_pContentLine1->SetForegroundColour(wxColor(0, 0, 255));
    #if defined(__WXMSW__)
	m_pContentLine2= new CustomStaticText(pBackground, ID_STATICTEXT_CONTENT_LINE2, _T(""), wxPoint(16,60), wxDefaultSize, wxTRANSPARENT_WINDOW, _T("ID_STATICTEXT_CONTENT_LINE2"));
    #endif
	#if defined(__UNIX__)
	m_pContentLine2= new CustomStaticText(this, ID_STATICTEXT_CONTENT_LINE2, _T(""), wxPoint(16,60), wxDefaultSize, wxTRANSPARENT_WINDOW, _T("ID_STATICTEXT_CONTENT_LINE2"));
	#endif
	m_pContentLine2->SetForegroundColour(wxColor(0, 0, 255));
    #if defined(__WXMSW__)
	m_pContentLine3= new CustomStaticText(pBackground, ID_STATICTEXT_CONTENT_LINE3, _T(""), wxPoint(16,80), wxDefaultSize, wxTRANSPARENT_WINDOW, _T("ID_STATICTEXT_CONTENT_LINE3"));
    #endif
	#if defined(__UNIX__)
	m_pContentLine3= new CustomStaticText(this, ID_STATICTEXT_CONTENT_LINE3, _T(""), wxPoint(16,80), wxDefaultSize, wxTRANSPARENT_WINDOW, _T("ID_STATICTEXT_CONTENT_LINE3"));
	#endif
	m_pContentLine3->SetForegroundColour(wxColor(0, 0, 255));

    #if defined(__WXMSW__)
    m_pBkmapnormal = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\button_normal.png"),wxBITMAP_TYPE_PNG);
    m_pBkmapover = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\button_over.png"),wxBITMAP_TYPE_PNG);
    m_pBkmapdown = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\button_down.png"),wxBITMAP_TYPE_PNG);
    m_pBkmapdisable = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\button_disable.png"),wxBITMAP_TYPE_PNG);
    #endif

    #if defined(__WXMSW__)
    wxMemoryDC dc;
    m_pBkmapMute = new wxBitmap(79, 27);
    m_btnOK = new wxBitmapButton(this, ID_BTN_OK, *m_pBkmapMute, wxPoint(150,104), wxDefaultSize, wxBU_AUTODRAW|wxNO_BORDER, wxDefaultValidator, _T("ID_BTN_OK"));
    RedrawBitmapBtn(_("OK"), m_btnOK, m_pBkmapMute, &dc);
    #endif

    #if defined(__UNIX__)
    m_btnOK = new wxBitmapButton(this, ID_BTN_OK, wxBitmap(::wxGetApp().strAppPath + _T("pic/button_normal.png"), wxBITMAP_TYPE_PNG), wxPoint(150,104), wxDefaultSize, wxBU_AUTODRAW|wxNO_BORDER, wxDefaultValidator, _T("ID_BTN_OK"));
    #endif

    #if defined(__UNIX__)
    m_btnOK->SetBitmapDisabled(wxBitmap(::wxGetApp().strAppPath + _T("pic/button_disable.png"),wxBITMAP_TYPE_PNG));
    m_btnOK->SetBitmapSelected(wxBitmap(::wxGetApp().strAppPath + _T("pic/button_down.png"),wxBITMAP_TYPE_PNG));
    m_btnOK->SetBitmapHover(wxBitmap(::wxGetApp().strAppPath + _T("pic/button_over.png"),wxBITMAP_TYPE_PNG));
    m_pBtnOK = new wxStaticText(this, ID_STATICTEXTOK, _("OK"), wxPoint(188, 115), wxDefaultSize, 0, _T("ID_STATICTEXTOK"));
    #endif

#ifdef __WXMSW__
    pBackground->Enable(false);
    SetWindowLong((HWND)this->m_hWnd, GWL_EXSTYLE, WS_EX_TOOLWINDOW | WS_EX_DLGMODALFRAME);
#endif
#ifndef __WXGTK__
    SetWindowShape();
#endif

    Connect(wxID_ANY,wxEVT_INIT_DIALOG,(wxObjectEventFunction)&PopupConfirmDialog::OnInit);
}

PopupConfirmDialog::~PopupConfirmDialog()
{
}

void PopupConfirmDialog::SetWindowShape()
{
    wxRegion region(m_bitmap, *wxBLACK);
    m_hasShape = SetShape(region);
}

void PopupConfirmDialog::OnEraseBkgnd(wxEraseEvent&  event)
{
    wxDC* pDC = event.GetDC();
    if ( pDC != NULL )
    {
        if ( m_bitmap.Ok() )
        {
            pDC->DrawBitmap(m_bitmap, 0, 0, true);
        }
    }
    else
    {
        wxClientDC dc(this);
        if ( m_bitmap.Ok() )
        {
            dc.DrawBitmap(m_bitmap, 0, 0, true);
        }
    }
}

void PopupConfirmDialog::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);
    dc.DrawBitmap(m_bitmap, 0, 0, TRUE);
}

void PopupConfirmDialog::OnWindowCreate(wxWindowCreateEvent& evt)
{
    SetWindowShape();
}

void PopupConfirmDialog::OnButtonClick(wxCommandEvent& event)
{
    if ( IsModal() )
    {
        if ( event.GetId() == ID_BTN_OK )
        {
            EndModal(wxID_OK);
        }
        else
        {
            EndModal(wxID_CANCEL);
        }
    }
    else
    {
        m_Timer.Stop();
        Close();
    }
}


void PopupConfirmDialog::RedrawBitmapBtn(wxString stText, wxBitmapButton* m_pBitmapBtn, wxBitmap* pBitmap, wxMemoryDC* pDC)
{
    if ( NULL == pDC )
    {
        return;
    }
    ButtonState(stText, pBitmap, m_pBkmapnormal, pDC);
    m_pBitmapBtn->SetBitmapLabel(*pBitmap);

    ButtonState(stText, pBitmap, m_pBkmapover, pDC);
    m_pBitmapBtn->SetBitmapHover(*pBitmap);

    ButtonState(stText, pBitmap, m_pBkmapdown, pDC);
    m_pBitmapBtn->SetBitmapSelected(*pBitmap);

    ButtonState(stText, pBitmap, m_pBkmapdisable, pDC);
    m_pBitmapBtn->SetBitmapDisabled(*pBitmap);
}


void PopupConfirmDialog::ButtonState(wxString drawtext, wxBitmap* bitmap, wxBitmap* bitmap_back, wxMemoryDC* dc)
{
    if ((NULL == dc) || (NULL == bitmap) || (NULL == bitmap_back))
    {
        return;
    }
    wxColour colour(71,83,107);
    dc->Clear();
    dc->SelectObject(*bitmap);
    dc->SetTextForeground(colour);
    dc->SetTextBackground(*wxWHITE);
    dc->DrawBitmap(*bitmap_back, 0, 0, TRUE);
    if (drawtext != _T(""))
    {
        wxFont BtnFont(10, wxDEFAULT, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
        dc->SetFont(BtnFont);
        dc->DrawLabel(wxStripMenuCodes(drawtext), wxRect(0, 0, bitmap->GetWidth(), bitmap->GetHeight()), wxALIGN_CENTER_VERTICAL | wxALIGN_CENTRE);
    }
    dc->SelectObject( wxNullBitmap );
}

void PopupConfirmDialog::OnInit(wxInitDialogEvent& event)
{
    m_Timer.Start(TIMER_INTERVAL, wxTIMER_ONE_SHOT);
    wxPoint finalPos;
    int width = 0;
    int height = 0;
    ::wxDisplaySize(&width, &height);
    #if defined(__WXMSW__)
    finalPos = wxPoint(width - WIDTH, height - HEIGHT - ADJUST_HEIGHT);
    #endif

    #if defined(__UNIX__)
    finalPos = wxPoint(width - WIDTH, 0);
    #endif

	this->Move(finalPos);
}

void PopupConfirmDialog::SetTitle(wxString strTitle)
{
    m_pTitle->SetLabel(strTitle);
}

void PopupConfirmDialog::SetContentLine1(wxString strContent)
{
    m_pContentLine1->SetLabel(strContent);
}

void PopupConfirmDialog::SetContentLine2(wxString strContent)
{
    m_pContentLine2->SetLabel(strContent);
}

int PopupConfirmDialog::ShowModal()
{
    return wxDialog::ShowModal();
}

void PopupConfirmDialog::EndModal(int retCode)
{
    m_Timer.Stop();
    wxDialog::EndModal(retCode);
}

void PopupConfirmDialog::OnTimerTick(wxTimerEvent & event)
{
    if ( IsModal() )
        EndModal(wxID_CANCEL);
    else
        Close();
}

void PopupConfirmDialog::SetContentLine3(wxString strContent)
{
    m_pContentLine3->SetLabel(strContent);
}
