// WDeploySocketServer.cpp: implementation of the WDeploySocketServer class.
//
//////////////////////////////////////////////////////////////////////

#include "wx/thread.h"
#include "WDeploySocketServer.h"
#include "ENMApp.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


WDeploySocketServer::WDeploySocketServer(const char* filepath)
{
	port = 8888;
    strcpy(m_filepath, filepath);
}

bool WDeploySocketServer::createSocket()
{
	 // Initialize Winsock.
	WSADATA wsaData;
	int iResult = WSAStartup( MAKEWORD(2,2), &wsaData );
    if ( iResult != NO_ERROR )
    {
		printf("Error at WSAStartup()\n");
		return false;
	}
    // Create a socket.
    m_socket = socket( AF_INET, SOCK_STREAM, 0 );
    if ( m_socket == INVALID_SOCKET )
	{
        printf( "Error at socket(): %ld\n", WSAGetLastError() );
        WSACleanup();
        return false;
    }

	m_backup = m_socket;
    return true;
}

bool WDeploySocketServer::startServer()
{
    // bind to a server.
	memset(&m_ServerAddr,0, sizeof(m_ServerAddr));
    m_ServerAddr.sin_family = AF_INET;
    m_ServerAddr.sin_addr.s_addr = INADDR_ANY;
	m_ServerAddr.sin_port = htons( port );

    if ( bind( m_socket, (SOCKADDR*) &m_ServerAddr, sizeof(m_ServerAddr) ) == SOCKET_ERROR)
	{
        printf( "Failed to bind.\n" );
        WSACleanup();
        return false;
    }

    // Listen on the socket.
    if ( listen( m_socket, 1) == SOCKET_ERROR )
	{
		printf( "Error listening on socket. %ld\n",::GetLastError());
		return false;
	}
	return true;

}

bool WDeploySocketServer::waitForClient()
{
	int nClientAddrlen = sizeof(m_ClientAddr);
	m_AcceptSocket = SOCKET_ERROR;
	while ( m_AcceptSocket == SOCKET_ERROR )
	{
		m_AcceptSocket = accept( m_backup, (SOCKADDR*)&m_ClientAddr, &nClientAddrlen );
	}
	m_socket = m_AcceptSocket;
	return true;
}

int WDeploySocketServer::sendData(char *sendbuf)
{
	return send( m_socket, sendbuf, strlen(sendbuf), 0 );
}

int WDeploySocketServer::recvData(char *recvbuf,int size)
{
	int sz = recv( m_socket, recvbuf, size, 0 );
	recvbuf[sz] = '\0';
	return sz;
}

bool WDeploySocketServer::fileReceive(char* filename)
{
	int nlen = recv( m_socket, filename, 32, 0 );
	if (nlen <= 0)
	{
	    return false;
    }
	send( m_socket, "OK", strlen("OK"), 0 );
	printf("filename = %s\n",filename);

    char filepath[250] = "";
    strcat(strcpy(filepath, m_filepath), filename);
	FILE *fw = fopen(filepath, "wb");
	if (NULL == fw)
	{
		printf( "Failed to open the file. %ld\n" ,::GetLastError());
		return false;
	}

	char rec[50] = "";
	int recs = recv( m_socket, rec, 32, 0 );
	if (recs <= 0)
	{
	    return false;
    }
	send( m_socket, "OK", strlen("OK"), 0 );
	rec[recs]='\0';
	int size = atoi(rec);
	printf("Received file size = %d\n",size);

	while (size > 0)
	{
		char buffer[1030];

		if (size>=1024)
		{
			nlen = recv( m_socket, buffer, 1024, 0 );
			if (nlen <= 0)
            {
                return false;
            }
			send( m_socket, "OK", strlen("OK"), 0 );
			fwrite(buffer, sizeof(char), 1024, fw);
		}
		else
		{
			nlen = recv( m_socket, buffer, size, 0 );
			if (nlen <= 0)
            {
                return false;
            }
			send( m_socket, "OK", strlen("OK"), 0 );
			buffer[size]='\0';
			fwrite(buffer, sizeof(char), size, fw);
		}
		size -= 1024;
	}
	fclose(fw);
	return true;

}
bool WDeploySocketServer::runServer()
{
	//Create Socket
	if (!createSocket())
	{
	    return false;
	}
	// Start Server
	if (!startServer())
	{
	    return false;
	}
	printf("Server Started........\n");

    while (TRUE)
	{
		// Wait until a client connects
		waitForClient();
		printf("Client Connected......\n");

        while (TRUE)
		{
		    //Receive the file
            char rec[50] = "";
            int nlen = recvData(rec,32);
            if (nlen <= 0)
            {
                closeConnection();
                break;
            }
            sendData("OK");

            if (strcmp(rec,"FileSend")==0)
            {
                char fname[32] ="";
                if (!fileReceive(fname))
                {
                    closeConnection();
                    break;
                }
                printf("File Received.........\n");

            }

            nlen = recvData(rec,50);
            if (nlen <= 0)
            {
                closeConnection();
                break;
            }
            sendData("OK");

            if(strcmp(rec,"EndConnection")==0)
            {
                printf("Connection Ended......\n");
                break;
            }
		}
		// Disconnect client
        closeConnection();

        //wxMutexGuiEnter();
        wxGetApp().Republish();
        //wxMutexGuiLeave();
	}

	return true;
}

void WDeploySocketServer::closeConnection()
{
	closesocket(m_socket);
	m_socket = m_backup;

}

WDeploySocketServer::~WDeploySocketServer()
{
	WSACleanup();
}


