#!/bin/bash
#****************************************************************************
#
#Copyright (c) Intel Corporation (2003).
#
#DISCLAIMER OF WARRANTY
#NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR
#CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY
#OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS
#EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR
#FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT
#THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL
#BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON
#ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.
#SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL
#NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,
#TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY
#UPDATES, ENHANCEMENTS OR EXTENSIONS.
#
#File Name:   	meshportal_back.sh
#
#Description:
#    Backup and recover the dns and gateway information
#Environment (opt):
#Notes (opt):
#****************************************************************************
ORIGINAL_FILE_NAME=/etc/resolv.conf
BACKUP_FILE_NAME=/etc/resolv.conf.saved.by.mesh.portal
ORIGINAL2_FILE_NAME=/etc/resolv.conf
BACKUP_GW_NAME=/etc/gw.saved.by.mesh.portal
#dispatch input parameter
case "$1" in
    -b)
	#backup dns and gateway
	echo "Backup dns and gateway"
	if test -e "$ORIGINAL_FILE_NAME"
	then
	    echo "Backup $ORIGINAL_FILE_NAME to $BACKUP_FILE_NAME"
	    cp $ORIGINAL_FILE_NAME $BACKUP_FILE_NAME	    
	fi
	GW=`route | grep default | awk '{print $2}'`
	for GW_TMP in $GW
	do
	    echo "Backup $GW_TMP into $BACKUP_GW_NAME"
	    echo $GW > $BACKUP_GW_NAME
	done
	;;
    -r)
	echo "Recover dns and gateway"
	if test -e "$BACKUP_FILE_NAME"
	then
	    echo "Recover $BACKUP_FILE_NAME to $ORIGINAL_FILE_NAME"
	    cp $BACKUP_FILE_NAME $ORIGINAL2_FILE_NAME
	fi
	if test -e "$BACKUP_GW_NAME"
	then
	    echo "Recover Gateway from $BACKUP_GW_NAME"
	    read GW2 < $BACKUP_GW_NAME
	    GW=`route | grep default | awk '{print $2}'`
	    for GW_TMP in $GW 
	    do 
		echo "Default gateway $GW_TMP is found, need to be deleted!"
		route del default
	    done
	    echo "Add new default gateway $GW2"
	    route add default gw $GW2
	fi
	;;
    *)
	echo "Usage: $0 {-b|-r}"
	exit 1
esac
exit 0
