
#include "KeyDialog.h"

#include <wx/intl.h>
#include <wx/string.h>
#include <wx/msgdlg.h>
#include "ENMApp.h"

BEGIN_EVENT_TABLE(KeyDialog,wxDialog)
    EVT_BUTTON(wxID_OK, KeyDialog::OnButtonClick)
    EVT_BUTTON(wxID_CANCEL, KeyDialog::OnButtonClick)
END_EVENT_TABLE()

KeyDialog::KeyDialog(wxWindow* parent, bool ifEnableKeyIdx)
        : wxDialog(), m_strKey(_T(""))
{
	Create(parent, wxID_ANY, _("Connect to Wireless Network"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE);
	SetClientSize(wxSize(400,144));
	m_pStxLabel1 = new wxStaticText(this, wxID_ANY, _("Please enter network key."), wxPoint(16,8));
	m_pStxLabel2 = new wxStaticText(this, wxID_ANY, _("Key:"), wxPoint(16,43), wxSize(48,16));
	m_pStxLabel3 = new wxStaticText(this, wxID_ANY, _("Key Index:"), wxPoint(16,75), wxSize(65,40));
	m_txtKey = new wxTextCtrl(this, wxID_ANY, wxEmptyString, wxPoint(85,40), wxSize(308,24), wxTE_PASSWORD);
	m_cbbIndex = new wxComboBox(this, wxID_ANY, wxEmptyString, wxPoint(85,70), wxSize(60,28), 0, 0, wxCB_READONLY, wxDefaultValidator);
	m_cbbIndex->Append(_T("1"));
	m_cbbIndex->Append(_T("2"));
	m_cbbIndex->Append(_T("3"));
	m_cbbIndex->Append(_T("4"));
	m_cbbIndex->SetValue(_T("1"));
	m_txtKey->SetMaxLength(32);
    m_cbbIndex->Enable(ifEnableKeyIdx);

#if defined(__WXMSW__)
    m_btnOK = new wxButton(this, wxID_OK, _("OK"), wxPoint(208,104), wxSize(80,24));
    m_btnCancel = new wxButton(this, wxID_CANCEL, _("Cancel"), wxPoint(312,104), wxSize(80,24));
#endif
#if defined(__UNIX__)
    m_btnOK = new wxButton(this, wxID_OK, _("OK"), wxPoint(312,104), wxSize(80,32));
    m_btnCancel = new wxButton(this, wxID_CANCEL, _("Cancel"), wxPoint(208,104), wxSize(80,32));
#endif
	m_btnOK->SetDefault();
	Center();
}

KeyDialog::~KeyDialog()
{
}

wxString KeyDialog::GetKey() const
{
    return m_strKey;
}

int KeyDialog::GetIdx() const
{
    long inx;
    m_cbbIndex->GetValue().ToLong(&inx);
    return (int)inx;
}

void KeyDialog::OnButtonClick(wxCommandEvent& event)
{
    int buttonId = event.GetId();
    if ( wxID_OK == buttonId )
    {
        if ( m_txtKey->GetValue().IsEmpty() )
        {
            wxMessageDialog msg(this, _("Please input a key!"), _("Message"), wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            return;
        }
        else
        {
             m_strKey = m_txtKey->GetValue();
        }
    }
    else
    {
        m_strKey = _T("");
    }
    EndModal(buttonId);
}
