#include "ENMApp.h"
#include "ViewAPNeighborsDlg.h"
//(*InternalHeaders(ViewAPNeighborsDlg)
#include <wx/bitmap.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
//*)

#include "pic/neighbors.xpm"

#include <wx/msgdlg.h>
#include <fstream>
#include "ENMUtil.h"
using namespace std;

//(*IdInit(ViewAPNeighborsDlg)
const long ViewAPNeighborsDlg::ID_STATICBITMAP_VIEWAPNEIGHBORS = wxNewId();
const long ViewAPNeighborsDlg::ID_BUTTON_OKVIEWAPNEIGHBORS = wxNewId();
const long ViewAPNeighborsDlg::ID_STATICTEXT_VIEWAPNEIGHBORSTIP = wxNewId();
const long ViewAPNeighborsDlg::ID_LISTCTRL_VIEWAPNEIGHBORS = wxNewId();
const long ViewAPNeighborsDlg::ID_BUTTON_REFRESHVIEWAPNEIGHBORS = wxNewId();
const long ViewAPNeighborsDlg::ID_BUTTON_CANCELVIEWAPNEIGHBORS = wxNewId();
const long ViewAPNeighborsDlg::ID_STATICLINE1 = wxNewId();
//*)
const long ViewAPNeighborsDlg::ID_STATICTEXT_VIEWAPNEIGHBORSFIREWALLTIP = wxNewId();
const wxString g_path = ENMUtil::GetCurrentUserAppDataFolder();
const long ViewAPNeighborsDlg::ID_TIMER_VIEWNEIGHBOR = wxNewId();
const long ViewAPNeighborsDlg::ID_HELP = wxNewId();

BEGIN_EVENT_TABLE(ViewAPNeighborsDlg,wxDialog)
#if defined(__UNIX__)
    EVT_SCAN(ID_SCAN_OVER, ViewAPNeighborsDlg::ScanOver)
#endif
    EVT_BUTTON(ID_BUTTON_CANCELVIEWAPNEIGHBORS, ViewAPNeighborsDlg::OnButton_CancelViewApNeighborsClick)
    EVT_BUTTON(ID_BUTTON_REFRESHVIEWAPNEIGHBORS, ViewAPNeighborsDlg::OnButton_RefreshViewApNeighborsClick)
    EVT_BUTTON(ID_BUTTON_OKVIEWAPNEIGHBORS, ViewAPNeighborsDlg::OnButton_OKViewAPNeighborsClick)
    EVT_BUTTON(ID_HELP, ViewAPNeighborsDlg::OnF1Press)
    EVT_INIT_DIALOG(ViewAPNeighborsDlg::OnInit)
    EVT_CLOSE(ViewAPNeighborsDlg::OnClose)
END_EVENT_TABLE()

ViewAPNeighborsDlg::ViewAPNeighborsDlg(wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size)
        : wxDialog(), m_pGaugeDialog(NULL)
{
	Create(parent, wxID_ANY, _("Network Neighbors"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE | wxCLOSE_BOX, _T("wxID_ANY"));
    SetClientSize(wxSize(510,380));

#if defined(__UNIX__)
	StaticBitmap_ViewApNeighbors = new wxStaticBitmap(this, ID_STATICBITMAP_VIEWAPNEIGHBORS, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/ViewNeighbors.png")).Rescale(wxSize(71,74).GetWidth(),wxSize(71,74).GetHeight())), wxPoint(20,10), wxSize(71,74), 0, _T("ID_STATICBITMAP_VIEWAPNEIGHBORS"));
#endif
#if defined(__WXMSW__)
	StaticBitmap_ViewApNeighbors = new wxStaticBitmap(this, ID_STATICBITMAP_VIEWAPNEIGHBORS, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\ViewNeighbors.png")).Rescale(wxSize(71,74).GetWidth(),wxSize(71,74).GetHeight())), wxPoint(20,10), wxSize(71,74), 0, _T("ID_STATICBITMAP_VIEWAPNEIGHBORS"));
	Button_OKViewAPNeighbors = new wxButton(this, ID_BUTTON_OKVIEWAPNEIGHBORS, _("&OK"), wxPoint(310,340), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BUTTON_OKVIEWAPNEIGHBORS"));
	StaticText_ViewApNieghborsTip = new wxStaticText(this, ID_STATICTEXT_VIEWAPNEIGHBORSTIP, _("View network neighbors here. Click \"Refresh\" to update network neighbors information..."), wxPoint(115,15), wxSize(390,45), 0, _T("ID_STATICTEXT_VIEWAPNEIGHBORSTIP"));
	StaticText_ViewApNieghborsFireWallTip = new wxStaticText(this, ID_STATICTEXT_VIEWAPNEIGHBORSFIREWALLTIP, _("Note: Neighbors can only be found when \"File and Printer Sharing\" service in Windows Firewall is enabled."), wxPoint(115,50), wxSize(390,35), 0, _T("ID_STATICTEXT_VIEWAPNEIGHBORSFIREWALLTIP"));
	ListCtrl_ViewApNeighbors = new wxListCtrl(this, ID_LISTCTRL_VIEWAPNEIGHBORS, wxPoint(16,90), wxSize(480,232), wxLC_REPORT, wxDefaultValidator, _T("ID_LISTCTRL_VIEWAPNEIGHBORS"));
	Button_RefreshViewApNeighbors = new wxButton(this, ID_BUTTON_REFRESHVIEWAPNEIGHBORS, _("&Refresh"), wxPoint(16,340), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BUTTON_REFRESHVIEWAPNEIGHBORS"));
	Button_CancelViewApNeighbors = new wxButton(this, ID_BUTTON_CANCELVIEWAPNEIGHBORS, _("&Cancel"), wxPoint(410,340), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BUTTON_CANCELVIEWAPNEIGHBORS"));
	StaticLine1 = new wxStaticLine(this, ID_STATICLINE1, wxPoint(0,330), wxSize(576,-1), wxLI_HORIZONTAL, _T("ID_STATICLINE1"));
#endif
#if defined(__UNIX__)
	Button_OKViewAPNeighbors = new wxButton(this, ID_BUTTON_OKVIEWAPNEIGHBORS, _("&OK"), wxPoint(315,340), wxSize(88,32), 0, wxDefaultValidator, _T("ID_BUTTON_OKVIEWAPNEIGHBORS"));
	StaticText_ViewApNieghborsTip = new wxStaticText(this, ID_STATICTEXT_VIEWAPNEIGHBORSTIP, _("View network neighbors here. Click \"Refresh\" to update network neighbors information..."), wxPoint(115,15), wxSize(390,65), 0, _T("ID_STATICTEXT_VIEWAPNEIGHBORSTIP"));
	ListCtrl_ViewApNeighbors = new wxListCtrl(this, ID_LISTCTRL_VIEWAPNEIGHBORS, wxPoint(16,90), wxSize(480,232), wxLC_REPORT, wxDefaultValidator, _T("ID_LISTCTRL_VIEWAPNEIGHBORS"));
	Button_RefreshViewApNeighbors = new wxButton(this, ID_BUTTON_REFRESHVIEWAPNEIGHBORS, _("&Refresh"), wxPoint(16,340), wxSize(88,32), 0, wxDefaultValidator, _T("ID_BUTTON_REFRESHVIEWAPNEIGHBORS"));
	Button_CancelViewApNeighbors = new wxButton(this, ID_BUTTON_CANCELVIEWAPNEIGHBORS, _("&Cancel"), wxPoint(415,340), wxSize(88,32), 0, wxDefaultValidator, _T("ID_BUTTON_CANCELVIEWAPNEIGHBORS"));
	StaticLine1 = new wxStaticLine(this, ID_STATICLINE1, wxPoint(0,330), wxSize(576,-1), wxLI_HORIZONTAL, _T("ID_STATICLINE1"));
#endif
    wxIcon icon_neighbors(neighbors_xpm);
    SetIcon(icon_neighbors);

	wxListItem itemCol;
    itemCol.SetText(_("Hostname"));
    ListCtrl_ViewApNeighbors->InsertColumn(0, itemCol);
    ListCtrl_ViewApNeighbors->SetColumnWidth(0, 240);
    itemCol.SetText(_("IP Address"));
    ListCtrl_ViewApNeighbors->InsertColumn(1,itemCol);
    ListCtrl_ViewApNeighbors->SetColumnWidth(1, 220);
    itemCol.SetAlign(wxLIST_FORMAT_CENTRE);

    m_iSearchCount = 1;
    m_apNeighborsInfo = NULL;
    m_pGaugeDialog = new GaugeDialog(this);

    wxAcceleratorEntry entries[1];
    entries[0].Set( wxACCEL_NORMAL, WXK_F1, ID_HELP );
    wxAcceleratorTable accel(1, entries);
    SetAcceleratorTable(accel);
}

ViewAPNeighborsDlg::~ViewAPNeighborsDlg()
{
    m_pGaugeDialog->Destroy();
    m_pGaugeDialog = NULL;
}

void ViewAPNeighborsDlg::OnClose(wxCloseEvent& event)
{
//    if ( m_isSearching && event.CanVeto() )
//    {
//        event.Veto();
//    }
    m_iSearchCount++;
    event.Skip();
}

bool ViewAPNeighborsDlg::Show(bool show)
{
    if ( show )
    {
//        m_iSearchCount++;
    }
    else
    {
        m_pGaugeDialog->Show(false);
    }
    return wxDialog::Show(show);
}

void ViewAPNeighborsDlg::OnInit(wxInitDialogEvent& event)
{
    BeginSearchAPNeighbors();
}

void ViewAPNeighborsDlg::OnButton_CancelViewApNeighborsClick(wxCommandEvent& event)
{
    Close();
}

#if defined(__UNIX__)
///////////////////////////////////////////////////////////////////////////////
wxString ViewAPNeighborsDlg::ParseIPAddFile()
{
    ifstream in;
	string sPath = "/tmp/ip.txt";
    const char* cFileName = sPath.c_str();
    in.open(cFileName,ios_base::in);
    char cFileBuf[MAX_HOST_NAME_LEN];

    wxString wxIP;

    int iLine = 1;
    while(in.getline(cFileBuf, sizeof(cFileBuf)))
    {
        if (2 == iLine)
        {
            wxIP = wxString::FromUTF8(cFileBuf);
            if ( !wxIP.Contains(_T("failed to find")) )
            {
                wxIP.Trim(true);
                wxIP.Trim(false);
                wxIP = wxIP.Mid(wxIP.find_first_of(wxIP), wxIP.find(_T(" ")));
                in.close();
                return wxIP;
            }
            else
            {
                in.close();
                return _T("");
            }
        }
        iLine++;
    }
    return _T("");
}
#endif

void ViewAPNeighborsDlg::OnButton_RefreshViewApNeighborsClick(wxCommandEvent& event)
{
    if ( !BeginSearchAPNeighbors() )
    {
        wxMessageDialog dlg(this, _("Could not find any neighbors!"), _("Message"), wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();
    }
}

void ViewAPNeighborsDlg::OnButton_OKViewAPNeighborsClick(wxCommandEvent& event)
{
    Close();
}

bool ViewAPNeighborsDlg::BeginSearchAPNeighbors()
{
    Button_OKViewAPNeighbors->Enable(false);
    Button_RefreshViewApNeighbors->Enable(false);
    Button_CancelViewApNeighbors->Enable(false);

    m_apNeighborsInfo = NULL;
    ListCtrl_ViewApNeighbors->DeleteAllItems();

    bool bRet = true;
//#if defined(__WXMSW__)
    if( !m_pScanThread )
    {
        delete m_pScanThread;
        m_pScanThread = NULL ;
    }
    m_pScanThread = new ScanThread(this, m_iSearchCount);
    if ( bRet = (m_pScanThread->Create() == wxTHREAD_NO_ERROR) )
    {
        m_pGaugeDialog->SetProcessLabel(_("Searching for network neighbors..."));
        m_pGaugeDialog->Move(377, 270);
        m_pGaugeDialog->Show(true);
        m_pScanThread->Run();
        m_isSearching = true;
    }
//#endif
//#if defined(__UNIX__)
//    SearchNeighbor();
//#endif
    return bRet;
}

ViewAPNeighborsDlg::ScanThread::ScanThread(ViewAPNeighborsDlg* pViewAPNeighborsDlg, int searchIndex)
        : wxThread(), m_iSearchIndex(searchIndex)
{
    m_pViewAPNeighborsDlg = pViewAPNeighborsDlg;
}

ViewAPNeighborsDlg::ScanThread::~ScanThread()
{
}

void* ViewAPNeighborsDlg::ScanThread::Entry()
{
    AP_NEIGHBORS_INFO *ap_NeighborsInfo;
    int iCount = 0;
    ::wxMilliSleep(1000);

#if defined(__WXMSW__)
    wxString strTemp;
    struct hostent *host;
	struct in_addr *ptr;	// To retrieve the IP Address

    DWORD dwScope = RESOURCE_CONTEXT;
	NETRESOURCE *NetResource = NULL;
	HANDLE hEnum;
	WNetOpenEnum( dwScope, NULL, NULL, NULL, &hEnum );

	WSADATA wsaData;
	WSAStartup(MAKEWORD(1,1),&wsaData);

	if ( hEnum )
	{
		DWORD Count = 0xFFFFFFFF;
		DWORD BufferSize = 2048;
		LPVOID Buffer = new char[2048];
		WNetEnumResource( hEnum, &Count, Buffer, &BufferSize );

		NetResource = (NETRESOURCE*)Buffer;

		ap_NeighborsInfo = new AP_NEIGHBORS_INFO[BufferSize/sizeof(NETRESOURCE)];

		for ( size_t i = 0; i < BufferSize/sizeof(NETRESOURCE); i++, NetResource++ )
		{
			if ( NetResource->dwUsage == RESOURCEUSAGE_CONTAINER && NetResource->dwType == RESOURCETYPE_ANY )
			{
				if ( NetResource->lpRemoteName )
				{
				    wcscpy(ap_NeighborsInfo[iCount].HostName, NetResource->lpRemoteName);

					for ( size_t j = 0; j < wcslen(ap_NeighborsInfo[iCount].HostName) - 2; j++ )
					{
					    ap_NeighborsInfo[iCount].HostName[j] = ap_NeighborsInfo[iCount].HostName[j + 2];
					}

					ap_NeighborsInfo[iCount].HostName[wcslen(ap_NeighborsInfo[iCount].HostName) - 2] = '\0';

					int iLength = wcstombs(NULL, ap_NeighborsInfo[iCount].HostName, 0);
                    char*  cBuffer  =  new  char[iLength+1];
                    wcstombs(cBuffer, ap_NeighborsInfo[iCount].HostName, iLength);
                    cBuffer[iLength] = 0;

					host = gethostbyname(cBuffer);

					if ( host != NULL )
					{
					    ptr = (struct in_addr *) host->h_addr_list[0];

                        int a = ptr->S_un.S_un_b.s_b1;  // Eg. 211.40.35.76 split up like this.
                        int b = ptr->S_un.S_un_b.s_b2;  //     40
                        int c = ptr->S_un.S_un_b.s_b3;  //     35
                        int d = ptr->S_un.S_un_b.s_b4;  //     76
                        ap_NeighborsInfo[iCount].IPAddress = wxString::Format(_T("%d.%d.%d.%d"),a,b,c,d);
					}

					iCount++;

					delete[] cBuffer;
				}
			}
		}
		delete Buffer;
		WNetCloseEnum( hEnum );
	}
	WSACleanup();

	m_pViewAPNeighborsDlg->UpdateApNeighborsInfo(ap_NeighborsInfo, iCount, m_iSearchIndex);
    delete[] ap_NeighborsInfo;
#endif
#if defined(__UNIX__)
	system("smbtree -N -S > /tmp/SmbtreeResult.txt");
    ifstream in;
	string sPath = "/tmp/SmbtreeResult.txt";
    const char* cFileName = sPath.c_str();
    in.open(cFileName,ios_base::in);
    char cFileBuf[MAX_HOST_NAME_LEN];

    wxString wxIP;
    wxString wxHost;
//    wchar_t *wcHost;

    ap_NeighborsInfo = new AP_NEIGHBORS_INFO[100];

    while(in.getline(cFileBuf, sizeof(cFileBuf)))
    {
        wxHost = wxString::FromUTF8(cFileBuf);
        wxHost.Trim(true);
        wxHost.Trim(false);

        if ((int) wxHost.find(_T("\\\\")) >= 0)
        {
            if ((int) wxHost.find(_T(" ")) >= 0)
            {
                wxHost = wxHost.Mid(wxHost.find_first_of(wxHost), wxHost.find(_T(" ")));
            }

            wxHost = wxHost.Mid(wxHost.find(_T("\\")) + 2, wxHost.Len() - wxHost.find(_T("\\")) - 2);
            string s = ENMUtil::WxStringToString(wxHost);
            s = "nmblookup " + s + " > /tmp/ip.txt";
            system(s.c_str());
            wxIP = m_pViewAPNeighborsDlg->ParseIPAddFile();

            if ( wxIP != _T("NULL"))
            {
                ap_NeighborsInfo[iCount].IPAddress = wxIP;
            }
            const wxChar * temp = wxHost.c_str();
            wcscpy(ap_NeighborsInfo[iCount].HostName, temp);

            iCount++;
        }
    }
    in.close();

	m_pViewAPNeighborsDlg->UpdateApNeighborsInfo(ap_NeighborsInfo, iCount, m_iSearchIndex);
//    delete[] ap_NeighborsInfo;
#endif

	return NULL;
}

void ViewAPNeighborsDlg::ScanThread::OnExit()
{
}

void ViewAPNeighborsDlg::UpdateApNeighborsInfo(PAP_NEIGHBORS_INFO ap_NeighborsInfo, int iCount, int searchIndex)
{
    if ( searchIndex != m_iSearchCount )
        return;

    m_pGaugeDialog->Show(false);
    m_isSearching = false;
    if ( !this->IsShown() )
        return;

#if defined(__WXMSW__)
    if ( iCount > 0 )
    {
        wxString buf;
        for ( int i = 0; i < iCount; i++ )
        {
            buf.Printf(ap_NeighborsInfo[i].HostName);
            ListCtrl_ViewApNeighbors->InsertItem(i, buf);
            buf = ap_NeighborsInfo[i].IPAddress;
            //buf = _("192.168.1.1");
            ListCtrl_ViewApNeighbors->SetItem(i, 1, buf);
        }
    }
    else
    {
        wxMessageDialog dlg(this, _("Could not find any neighbors!"), _("Message"), wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();
    }

    Button_OKViewAPNeighbors->Enable(true);
    Button_RefreshViewApNeighbors->Enable(true);
    Button_CancelViewApNeighbors->Enable(true);
#endif
#if defined(__UNIX__)
    m_pNeighborsInfo = ap_NeighborsInfo;
    m_count = iCount;
    ScanEvent event(ID_SCAN_OVER);
    event.index = searchIndex;
    ::wxPostEvent(this, event);
#endif
}

#if defined(__UNIX__)
void ViewAPNeighborsDlg::ScanOver(ScanEvent& event)
{
    if ( event.index != m_iSearchCount )
        return;

    m_pGaugeDialog->Show(false);
    if ( !this->IsShown() )
        return;

    if ( m_count > 0 )
    {
        wxString buf;
        for ( int i = 0; i < m_count; i++ )
        {
            buf.Printf(m_pNeighborsInfo[i].HostName);
            ListCtrl_ViewApNeighbors->InsertItem(i, buf);
            buf = m_pNeighborsInfo[i].IPAddress;
            //buf = _("192.168.1.1");
            ListCtrl_ViewApNeighbors->SetItem(i, 1, buf);
        }
    }
    else
    {
        wxMessageDialog dlg(this, _("Could not find any neighbors!"), _("Message"), wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();
    }

    Button_OKViewAPNeighbors->Enable(true);
    Button_RefreshViewApNeighbors->Enable(true);
    Button_CancelViewApNeighbors->Enable(true);
    ListCtrl_ViewApNeighbors->SetFocus();
}
#endif

void ViewAPNeighborsDlg::OnF1Press(wxCommandEvent& event)
{
#if defined(__UNIX__)
    if( wxFileExists(wxT("/usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf")) )
    {
        wxString cmd = wxT("evince /usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf --page-label=23");
        ////wxExecute(cmd);
    }
#endif
#if defined(__WXMSW__)
    ENMUtil::ShowContextHelp(this, wxEmptyString);
#endif
}
