/*
 * Device Control Service API
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCS_EASYNETWORKMANAGER_API_H
#define DCS_EASYNETWORKMANAGER_API_H

#include "DCSCommon.h"
#include "ENMDef.h"

#ifdef __cplusplus
extern "C" {
#endif

    /**
     * Initialize user info
     *
     * @param initUserInfo user info
     */
    DCSAPI DCS_Return_Code DCS_InitUserInfo(ENM_InitUserInfo initUserInfo);

    /**
     * Allocate IP address from DHCP
     */
    DCSAPI DCS_Return_Code DCS_AllocateDhIP();

    /**
     * Disconnect the connection from current connected AP
     */
    DCSAPI DCS_Return_Code DCS_CloseWlanConnection();

    /**
     * Search network adapters
     */
    DCSAPI DCS_Return_Code DCS_SearchAdapter();

    /**
     * Enable the specified network adapter
     *
     * @param adapterType  the specified adapter type
     */
    DCSAPI DCS_Return_Code DCS_UpAdapter(ENM_ADAPTER_TYPE adapterType);

    /**
     * Disable the specified network adapter
     *
     * @param adapterType  the specified adapter type
     */
    DCSAPI DCS_Return_Code DCS_DownAdapter(ENM_ADAPTER_TYPE adapterType);

    /**
     * Check if at least one network adapters is enabled
     *
     * @param adapterType  the specified adapter type
     * @param pOutIsUp  Out Up/Down
     */
    DCSAPI DCS_Return_Code DCS_IsExistUpAdapter(ENM_ADAPTER_TYPE adapterType,BOOL* pOutIsUp);

    /**
     * Check if at least one network adapters is connected
     *
     * @param adapterType  Specified adapter type
     * @param pOutIsConnect     connect/disconnect
     */
    DCSAPI DCS_Return_Code DCS_IsExistConnectAdapter(ENM_ADAPTER_TYPE adapterType,BOOL* pOutIsConnect);

    /**
     * Connect to a wireless network
     *
     * @param connectAP  Input information of connect AP
     */
    DCSAPI DCS_Return_Code DCS_ConnectAP(ENM_ConnectAP connectAP);

    /**
     * Get all available wireless access points
     *
     * @param pOutAPList  Out parameter filled with all the detected access points
     */
    DCSAPI DCS_Return_Code DCS_GetAPList(AccessPointList* pOutAPList);

    /**
     * Get the newest informations of current connected access point
     *
     * @param pOutCurrentAP  the newest AP info
     */
    DCSAPI DCS_Return_Code DCS_GetCurrentAP(APStatus* pOutCurrentAP);

    /**
     * Get current IP address of LAN adapter
     *
     * @param pOutIpAddress  current IP address
     */
    DCSAPI DCS_Return_Code DCS_GetIPAddressHLAN(ENM_String* pOutIpAddress);

    /**
     * Get the type description of current LAN adapter
     *
     * @param pOutConnectType  the type description
     */
    DCSAPI DCS_Return_Code DCS_GetConnectTypeHLAN(ENM_String* pOutConnectType);

    /**
     * Search neighbors
     *
     * @param pNeighborsInfo  detected neighbors
     */
    DCSAPI DCS_Return_Code DCS_GetNeighborsInfo(ENM_NEIGHBORS_INFO* pNeighborsInfo);

    /**
     * Enable or disable 802.1x authentication
     *
     * @param isEnable  enable/disable
     */
    DCSAPI DCS_Return_Code DCS_Enable8021xAuthentication(bool isEnable);

    /**
     * Enable or disable 802.1x authentication
     *
     * @param isEnable  enable/disable
     */
    DCSAPI DCS_Return_Code DCS_EnableInternetSharing(bool isEnable);

    /**
     * Overwrite current home page
     *
     * @param pStrHomePage  URL of new home page
     */
    DCSAPI DCS_Return_Code DCS_OverwriteHomePage(ENM_String* pStrHomePage);

    /**
     * Overwrite current HTTP proxy
     *
     * @param pProxyInfo  proxy information
     */
    DCSAPI DCS_Return_Code DCS_OverwriteProxy(ENM_ProxyInfo* pProxyInfo);

    /**
     * Change the IP addresses of a network adapter
     *
     * @param pAddressInfo  IP addresses
     */
    DCSAPI DCS_Return_Code DCS_SetIPAddress(ENM_AddressInfo* pAddressInfo);

    /**
     * Enable or Disable sharing files and printer
     *
     * @param isEnable  enable/disable
     */
    DCSAPI DCS_Return_Code DCS_EnableFileAndPrint(bool isEnable);

    /**
     * Enable or disable Windows firewall
     *
     * @param isEnable  enable/disable
     */
    DCSAPI DCS_Return_Code DCS_EnableWindowsFirewall(bool isEnable);

    /**
     * Verfiy whether is exist wired adapter or wireless adapter
     *
     * @param adapterType  specify the adapter type, wired or wireless
     * @param pOutIsExist  true if the adapter exists
     */
    DCSAPI DCS_Return_Code DCS_IsExistAdapter(ENM_ADAPTER_TYPE adapterType,BOOL* pOutIsExist);

    /**
     * Write new profile to the folder which containing system profiles
     *
     * @param pFileName  name of new profile
     */
    DCSAPI DCS_Return_Code DCS_WriteFile(ENM_String* pFileName);

    /**
     * Upzip the package path
     *
     * @param pFileName  file path
     */
    DCSAPI DCS_Return_Code DCS_UpzipPackage(ENM_String* pFilePath);
    
    /**
     * Start listen thread
     *
     * @param pFileName  null
     */
    DCSAPI DCS_Return_Code DCS_StartListen();
	
    /**
     * Typedef of the callback function to be notified when the
     * student listen and get the new package automatic.
     *
     * @param pData		obligate
     */
     typedef void (CALLBACK *DCS_Listen_Callback) (int *pData);

    /** Registers the callback function to be notified  when the student listen and get the new package automatic. */
    DCSAPI DCS_Return_Code DCS_RegisterListenCallback (DCS_Listen_Callback pCallback);

    /** Unregisters the callback function for the student listen and get the new package automatic. */
    DCSAPI DCS_Return_Code DCS_UnregisterListenCallback();

#ifdef __cplusplus
}
#endif /** __cplusplus */

#endif /* DCS_EASYNETWORKMANAGER_API_H */
