/*******************************************************************************
**3456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
**      10        20        30        40        50        60        70        80
**
** notify-osd
**
** close-button.h - a special close-button for snap-decisions
**
** Copyright 2012 Canonical Ltd.
**
** Authors:
**    Mirco "MacSlow" Mueller <mirco.mueller@canonical.com>
**
** This program is free software: you can redistribute it and/or modify it
** under the terms of the GNU General Public License version 3, as published
** by the Free Software Foundation.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranties of
** MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
** PURPOSE.  See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*******************************************************************************/

#ifndef __CLOSE_BUTTON_H
#define __CLOSE_BUTTON_H

#include <glib-object.h>
#include <cairo.h>

#include "settings.h"

G_BEGIN_DECLS

#define CLOSE_BUTTON_TYPE             (close_button_get_type ())
#define CLOSE_BUTTON(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOSE_BUTTON_TYPE, CloseButton))
#define CLOSE_BUTTON_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), CLOSE_BUTTON_TYPE, CloseButtonClass))
#define IS_CLOSE_BUTTON(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOSE_BUTTON_TYPE))
#define IS_CLOSE_BUTTON_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOSE_BUTTON_TYPE))
#define CLOSE_BUTTON_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOSE_BUTTON_TYPE, CloseButtonClass))

typedef struct _CloseButton         CloseButton;
typedef struct _CloseButtonClass    CloseButtonClass;
typedef struct _CloseButtonPrivate  CloseButtonPrivate;

typedef enum
{
	CLOSE_BUTTON_STATE_NONE = 0,
	CLOSE_BUTTON_STATE_NORMAL,
	CLOSE_BUTTON_STATE_HOVER,
	CLOSE_BUTTON_STATE_PRESSED
} CloseButtonState;

/* instance structure */
struct _CloseButton
{
	GObject parent;

	/* private */
	CloseButtonPrivate* priv;
};

/* class structure */
struct _CloseButtonClass
{
	GObjectClass parent;
};

GType close_button_get_type (void);

CloseButton*
close_button_new (SettingsCloseButton* settings);

void
close_button_del (CloseButton* self);

void
close_button_set_position (CloseButton* self,
                           gint         x,
                           gint         y);

void
close_button_get_position (CloseButton* self,
                           gint*        x,
                           gint*        y);

gboolean
close_button_is_hit (CloseButton* self,
                     gint         x,
                     gint         y);

void
close_button_set_state (CloseButton*     self,
                        CloseButtonState state);

CloseButtonState
close_button_get_state (CloseButton* self);

void
close_button_paint (CloseButton*  self,
                    cairo_t*      cr);

G_END_DECLS

#endif /* __CLOSE_BUTTON_H */
