/*******************************************************************************
**3456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
**      10        20        30        40        50        60        70        80
**
** notify-osd
**
** json-parser.h - implements json-based resource/value loading
**
** Copyright 2012 Canonical Ltd.
**
** Authors:
**    Mirco "MacSlow" Mueller <mirco.mueller@canonical.com>
**
** This program is free software: you can redistribute it and/or modify it
** under the terms of the GNU General Public License version 3, as published
** by the Free Software Foundation.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranties of
** MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
** PURPOSE.  See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*******************************************************************************/

#ifndef __PARSER_H
#define __PARSER_H

#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS

#define PARSER_TYPE             (parser_get_type ())
#define PARSER(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), PARSER_TYPE, Parser))
#define PARSER_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), PARSER_TYPE, ParserClass))
#define IS_PARSER(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PARSER_TYPE))
#define IS_PARSER_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), PARSER_TYPE))
#define PARSER_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), PARSER_TYPE, ParserClass))

typedef struct _Parser      Parser;
typedef struct _ParserClass ParserClass;

typedef struct _Color
{
	gdouble red;
	gdouble green;
	gdouble blue;
	gdouble alpha;
} Color;

#define BLEND_MODE_SOURCE_NAME "source"
#define BLEND_MODE_OVER_NAME   "over"

typedef enum
{
	BLEND_MODE_NONE = 0,
	BLEND_MODE_SOURCE,
	BLEND_MODE_OVER
} BlendMode;

#define FONT_WEIGHT_LIGHT_NAME  "light"
#define FONT_WEIGHT_NORMAL_NAME "normal"
#define FONT_WEIGHT_BOLD_NAME   "bold"

typedef enum
{
	FONT_WEIGHT_NONE = 0,
	FONT_WEIGHT_LIGHT,
	FONT_WEIGHT_NORMAL,
	FONT_WEIGHT_BOLD
} FontWeight;

#define FONT_STYLE_NORMAL_NAME  "normal"
#define FONT_STYLE_OBLIQUE_NAME "oblique"
#define FONT_STYLE_ITALIC_NAME  "italic"

typedef enum
{
	FONT_STYLE_NONE = 0,
	FONT_STYLE_NORMAL,
	FONT_STYLE_OBLIQUE,
	FONT_STYLE_ITALIC
} FontStyle;

/* instance structure */
struct _Parser
{
	GObject parent;

	/* private */
	JsonParser* json_parser;
	JsonNode*   root_node;
};

/* class structure */
struct _ParserClass
{
	GObjectClass parent;
};

GType parser_get_type (void);

Parser*
parser_new ();

gboolean
parser_open (Parser* self,
             gchar*  file_name);

gint
parser_read_int (Parser* self,
                 gchar*  node_name,
                 gchar*  member_name);

gint*
parser_read_ints (Parser* self,
                  gchar*  node_name,
                  gchar*  member_name,
                  guint*  size);

gdouble
parser_read_double (Parser* self,
                    gchar*  node_name,
                    gchar*  member_name);

gdouble*
parser_read_doubles (Parser* self,
                     gchar*  node_name,
                     gchar*  member_name,
                     guint*  size);

gboolean
parser_read_color (Parser*   self,
                   gchar*    node_name,
                   gchar*    member_name,
                   GdkColor* color);

GdkColor*
parser_read_colors (Parser* self,
                    gchar*  node_name,
                    gchar*  member_name,
                    guint*  size);

FontStyle
parser_read_font_style (Parser* self,
                        gchar*  node_name,
                        gchar*  member_name);

FontStyle*
parser_read_font_styles (Parser* self,
                         gchar*  node_name,
                         gchar*  member_name,
                         guint*  size);

FontWeight
parser_read_font_weight (Parser* self,
                         gchar*  node_name,
                         gchar*  member_name);

FontWeight*
parser_read_font_weights (Parser* self,
                          gchar*  node_name,
                          gchar*  member_name,
                          guint*  size);

BlendMode
parser_read_blend_mode (Parser* self,
                        gchar*  node_name,
                        gchar*  member_name);

BlendMode*
parser_read_blend_modes (Parser* self,
                         gchar*  node_name,
                         gchar*  member_name,
                         guint*  size);

gchar*
parser_read_string (Parser* self,
                    gchar*  node_name,
                    gchar*  member_name);

gchar**
parser_read_strings (Parser* self,
                     gchar*  node_name,
                     gchar*  member_name,
                     guint*  size);

G_END_DECLS

#endif /* __PARSER_H */
