/******************************************************************************
 *
 * Copyright(c) 2005 - 2013 Intel Corporation.
 * All rights reserved.
 *
 * LICENSE PLACE HOLDER
 *
 *****************************************************************************/

#ifndef __IWL_IDI_RX_H__
#define __IWL_IDI_RX_H__

/**
 * Initialize the IDI RX emulation block.
 *
 * Returns 0 on success,  negative value describing the error otherwise.
 */
int iwl_idi_rx_em_init(void);

/*
 * Free the IDI RX emulation block.
 * The API should be called only after the IDI RX and
 * AMFH were gracefully stopped.
 */
void iwl_idi_rx_em_free(void);

/*
 * Start the IDI Emulation
 *
 * Returns 0 on success, negative value describing the error otherwise.
 */
int iwl_idi_rx_em_start(void);

/*
 * Stop the IDI Emulation
 *
 * Returns 0 on success, negative value describing the error otherwise.
 */
int iwl_idi_rx_em_stop(void);

/*
 * Check if there is enough space in the RXB to push the required size.
 *
 * @ size_required - The size we need to test for available space for.
 * Returns TRUE if there is available space for this size, false otherwise.
 */
bool iwl_idi_rx_em_available_space(u32 size_required);

/*
 * Alert the IDI RX module that there has been a change in it's parameters
 * and that there maybe work that needs to be done by the module due
 * to the change.
 */
void iwl_idi_rx_em_alert_change(void);

/*
 * Pushes data to the IDI RXB.
 * Pushes the given data from the given source in the given size.
 *
 * Returns 0 on success, negative value describing the error otherwise.
 * NOTE: only one thread can push the data at any given time.
 */
int iwl_idi_rx_em_push_to_rxb(const void *source, u32 size);

/*
 * Waits until the RX transaction has ended,
 * wil return only when the RX engine is Idle.
 */
void iwl_idi_rx_em_wait_for_rx_stop(void);

#endif /* __IWL_IDI_RX_H__ */
