#ifndef _IWL_WAPI_SMS4_H_
#define _IWL_WAPI_SMS4_H_

#include <net/mac80211.h>
#include "sms4-core.h"

#ifndef ETH_P_WAPI
#define ETH_P_WAPI 0x88B4 /* eventually belongs to if_ether.h */
#endif
#define IWL_WAPI_SMS4_KEY_LEN 16

#define SMS4_ICD_PART1_LEN_W_O_QOS 32
/* actually QoS is 2 bytes, but length of ICD part must be a 16 multiple */
#define SMS4_ICD_PART1_LEN_W_QOS (SMS4_ICD_PART1_LEN_W_O_QOS + 16)
#define SMS4_ICD_MAX_PART1_LEN SMS4_ICD_PART1_LEN_W_QOS
#define SMS4_ICD_MAX_PART2_LEN IEEE80211_MAX_DATA_LEN

struct iwl_wapi_sms4_keyconf {
	u8 enc_key[IWL_WAPI_SMS4_KEY_LEN];
	u8 cons_key[IWL_WAPI_SMS4_KEY_LEN];
	struct sms4_ctx enc_ctx;
	struct sms4_ctx cons_ctx;
	bool is_valid;
};

struct iwl_wapi_sms4_ctx {
	spinlock_t ctx_lock; /* protects this wapi-sms4 impl. context */

	struct iwl_wapi_sms4_keyconf uc_key[2];
	u8 last_uc_pn[SMS4_BLOCK_SIZE]; /* rx-ed */
	u8 next_pn[SMS4_BLOCK_SIZE]; /* to be tx-ed */
	s8 curr_uc_key_idx;
	struct iwl_wapi_sms4_keyconf mc_key[2];
	u8 last_mc_pn[SMS4_BLOCK_SIZE]; /* rx-ed */
	s8 curr_mc_key_idx;

	u8 icd[SMS4_ICD_MAX_PART1_LEN + SMS4_ICD_MAX_PART2_LEN];
	size_t icd_len;

#ifdef CPTCFG_IWLWIFI_SW_WAPI_SMS4_DBG
	char str[3 * IEEE80211_MAX_FRAME_LEN];
#endif
};

void iwl_wapi_sms4_init_ctx(struct iwl_wapi_sms4_ctx *ctx);

void iwl_wapi_sms4_report_supported_cipher_suites(struct ieee80211_hw *hw);

int iwl_wapi_sms4_set_key(struct ieee80211_key_conf *keyconf,
	struct iwl_wapi_sms4_ctx *ctx);

int iwl_wapi_sms4_clear_key(struct ieee80211_key_conf *keyconf,
	struct iwl_wapi_sms4_ctx *ctx);

int iwl_wapi_sms4_tx(struct sk_buff *skb, struct iwl_wapi_sms4_ctx *ctx);

int iwl_wapi_sms4_rx(struct sk_buff *skb, struct iwl_wapi_sms4_ctx *ctx);

#endif /* _IWL_WAPI_SMS4_H_ */
