#ifndef __iwl_idi_io_h__
#define __iwl_idi_io_h__

#include "iwl-csr.h"
#include "iwl-trans.h"
#include "iwl-target-access.h"

static inline u32 iwl_trans_idi_io_read_reg(struct iwl_trans *trans, u32 addr)
{
	u32 res;

	res = iwl_idi_tg_read32(trans, addr);
	return res;
}

static inline void iwl_trans_idi_io_write_reg(struct iwl_trans *trans,
					      u32 addr, u32 value)
{
	iwl_idi_tg_write32(trans, addr, value);
}

static inline void iwl_trans_idi_io_clear_reg_bits(struct iwl_trans *trans,
						   u32 addr, u32 bits)
{
	u32 value = iwl_trans_idi_io_read_reg(trans, addr);
	iwl_trans_idi_io_write_reg(trans, addr, (value & ~bits));
}

static inline void iwl_trans_idi_io_set_reg_bits(struct iwl_trans *trans,
						 u32 addr, u32 bits)
{
	u32 value = iwl_trans_idi_io_read_reg(trans, addr);
	iwl_trans_idi_io_write_reg(trans, addr, (value | bits));
}

static inline u32 iwl_trans_idi_io_prph_read32(struct iwl_trans *trans,
					       u32 addr)
{
	iwl_trans_idi_io_write_reg(trans, HBUS_TARG_PRPH_RADDR,
				   (addr & 0x000FFFFF) | (3 << 24));
	return iwl_trans_idi_io_read_reg(trans, HBUS_TARG_PRPH_RDAT);
}

static inline void iwl_trans_idi_io_prph_write32(struct iwl_trans *trans,
						 u32 addr, u32 value)
{
	iwl_trans_idi_io_write_reg(trans, HBUS_TARG_PRPH_WADDR,
				   (addr & 0x000FFFFF) | (3 << 24));
	iwl_trans_idi_io_write_reg(trans, HBUS_TARG_PRPH_WDAT, value);
}

static inline void iwl_trans_idi_io_prph_clear_bits(struct iwl_trans *trans,
						    u32 addr, u32 bits)
{
	u32 value = iwl_trans_idi_io_prph_read32(trans, addr);
	iwl_trans_idi_io_prph_write32(trans, addr, (value & ~bits));
}

static inline void iwl_trans_idi_io_prph_set_bits(struct iwl_trans *trans,
						  u32 addr, u32 bits)
{
	u32 value = iwl_trans_idi_io_prph_read32(trans, addr);
	iwl_trans_idi_io_prph_write32(trans, addr, (value | bits));
}

static inline u32 iwl_trans_idi_io_mem_read32(struct iwl_trans *trans,
					      u32 addr)
{
	iwl_trans_idi_io_write_reg(trans, HBUS_TARG_MEM_RADDR, addr);
	return iwl_trans_idi_io_read_reg(trans, HBUS_TARG_MEM_RDAT);
}

static inline void iwl_trans_idi_io_mem_write32(struct iwl_trans *trans,
						u32 addr, u32 value)
{
	iwl_trans_idi_io_write_reg(trans, HBUS_TARG_MEM_WADDR, addr);
	iwl_trans_idi_io_write_reg(trans, HBUS_TARG_MEM_WDAT, value);
}

static inline void iwl_trans_idi_io_mem_read_buf(struct iwl_trans *trans,
						 u32 addr, u32 words, u32 *buf)
{
	if (unlikely(NULL == buf))
		return;

	iwl_trans_idi_io_write_reg(trans, HBUS_TARG_MEM_RADDR, addr);
	for (; 0 < words; words -= sizeof(u32), buf++)
		*buf = iwl_trans_idi_io_read_reg(trans, HBUS_TARG_MEM_RDAT);

}

static inline void iwl_trans_idi_io_mem_write_buf(struct iwl_trans *trans,
						  u32 addr, u32 words, u32 *buf)
{
	if (unlikely(NULL == buf))
		return;

	iwl_trans_idi_io_write_reg(trans, HBUS_TARG_MEM_WADDR, addr);
	for (; 0 < words; words -= sizeof(u32), buf++)
		iwl_trans_idi_io_write_reg(trans, HBUS_TARG_MEM_WDAT, *buf);
}

#endif
