/*
 * Copyright 2003 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

package com.sun.tools.doclets.internal.toolkit;

import java.io.*;
import com.sun.javadoc.*;

/**
 * The interface for writing member summary output.
 *
 * This code is not part of an API.
 * It is implementation that is subject to change.
 * Do not use it as an API
 * 
 * @author Jamie Ho
 * @since 1.5
 */

public interface MemberSummaryWriter {
    
    /**
     * Write the member summary header for the given class.
     *
     * @param classDoc the class the summary belongs to.
     */
    public void writeMemberSummaryHeader(ClassDoc classDoc);
    
    /**
     * Write the member summary for the given class and member.
     *
     * @param classDoc the class the summary belongs to.
     * @param member the member that I am summarizing.
     * @param firstSentenceTags the tags for the sentence being documented.
     * @param isFirst true if this is the first member in the list.
     * @param isLast true if this the last member being documented.
     */
    public void writeMemberSummary(ClassDoc classDoc, ProgramElementDoc member, 
        Tag[] firstSentenceTags, boolean isFirst, boolean isLast);
    
    /**
     * Write the member summary footer for the given class.
     *
     * @param classDoc the class the summary belongs to.
     */
    public void writeMemberSummaryFooter(ClassDoc classDoc);
    
    /**
     * Write the inherited member summary header for the given class.
     *
     * @param classDoc the class the summary belongs to.
     */
    public void writeInheritedMemberSummaryHeader(ClassDoc classDoc);
    
    /**
     * Write the inherited member summary for the given class and member.
     *
     * @param classDoc the class the inherited member belongs to.
     * @param member   the inherited member that I am summarizing.
     * @param isFirst  true if this is the first member in the list.
     * @param isLast   true if this is the last member in the list.
     */
    public void writeInheritedMemberSummary(ClassDoc classDoc, 
        ProgramElementDoc member, boolean isFirst, boolean isLast);
    
    /**
     * Write the inherited member summary footer for the given class.
     *
     * @param classDoc the class the summary belongs to.
     */
    public void writeInheritedMemberSummaryFooter(ClassDoc classDoc);
    
    /**
     * Close the writer.
     */
    public void close() throws IOException;
}

