/*
 * Copyright 2007 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/* @test
   @summary Test RiffWriter(OutputStream) constructor */

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;

import javax.sound.sampled.*;

import com.sun.media.sound.*;

public class WriteOutputStream {

	private static void assertEquals(Object a, Object b) throws Exception
	{
		if(!a.equals(b))
			throw new RuntimeException("assertEquals fails!");
	}	
	
	public static void main(String[] args) throws Exception {
		RIFFWriter writer = null;
		RIFFReader reader = null;			
		File tempfile = File.createTempFile("test",".riff");		
		try
		{
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			writer = new RIFFWriter(baos, "TEST");
			RIFFWriter chunk = writer.writeChunk("TSCH");
			chunk.write((byte)33);
			writer.close();
			writer = null;
			ByteArrayInputStream fis = new ByteArrayInputStream(baos.toByteArray());
			reader = new RIFFReader(fis);
			assertEquals(reader.getFormat(), "RIFF");
			assertEquals(reader.getType(), "TEST");
			RIFFReader readchunk = reader.nextChunk();
			assertEquals(readchunk.getFormat(), "TSCH");
			assertEquals(readchunk.read(), 33);
			fis.close();
			reader = null;
			
			
		}
		finally
		{
			if(writer != null)
				writer.close();
			if(reader != null)
				reader.close();
				
			if(tempfile.exists()) 
				if(!tempfile.delete())
					tempfile.deleteOnExit();			
		}
	}
}
