#include "Types.r"

resource 'SIZE' (-1) {
	reserved,
	acceptSuspendResumeEvents,
	reserved,
	canBackground,
	multiFinderAware,
	backgroundAndForeground,
	dontGetFrontClicks,
	ignoreChildDiedEvents,
	is32BitCompatible,
	isHighLevelEventAware,
	onlyLocalHLEvents,
	isStationeryAware,
	dontUseTextEditServices,
	reserved,
	reserved,
	reserved,
	3584000,
	3584000
};

resource 'SIZE' (0) {
	reserved,
	acceptSuspendResumeEvents,
	reserved,
	canBackground,
	multiFinderAware,
	backgroundAndForeground,
	dontGetFrontClicks,
	ignoreChildDiedEvents,
	is32BitCompatible,
	isHighLevelEventAware,
	onlyLocalHLEvents,
	isStationeryAware,
	dontUseTextEditServices,
	reserved,
	reserved,
	reserved,
	4096000,
	3584000
};

resource 'ics8' (128) {
	$"ECEC EC00 0000 00FF 0000 0000 0000 0000"
	$"ECEC EC00 0000 FF2B FF00 0000 0000 0000"
	$"ECEC EC00 00FF 2B2B 2BFF 0000 0000 0000"
	$"ECEC EC00 FF2B F5EC F92B FF00 0000 0000"
	$"ECEC ECFF 2BF5 EC05 ECF9 2BFF 0000 0000"
	$"ECEC FF2B F5EC ECEC ECEC F92B FF00 0000"
	$"ECFF 2BF5 ECEC 00EC ECEC ECF9 2BFF 0000"
	$"FF2B 2BEC ECEC EC00 ECEC ECEC F92B F900"
	$"ECFF 2BF9 FFFF FFFF FFFF FFFF FFF9 2BFF"
	$"ECEC FF2B FF00 0000 0000 0000 F92B F9FD"
	$"ECEC ECFF FF00 F9F9 0000 00F9 2BF9 FDFF"
	$"ECEC EC00 FF00 F9F9 0000 F92B F9FD 00FF"
	$"ECEC EC00 FF00 0000 00F9 2BF9 FD00 00FF"
	$"ECEC EC00 FF00 D800 00F9 F9FD 0000 00FF"
	$"ECEC EC00 FF00 0000 F900 0000 0000 00FF"
	$"ECEC EC00 FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'ics8' (129) {
	$"00FF FFFF FFFF FFFF FFFF FF00 0000 0000"
	$"00FF F5F5 F5F5 F5F5 F5F5 FFFF 0000 0000"
	$"00FF F5EC ECEC FAFA FAFA FF00 FF00 0000"
	$"00FF F5EC ECEC FAFC FCFC FFFF FFFF 0000"
	$"00FF F5EC ECEC FAFC 05EC F5F5 F5FF 0000"
	$"00FF F5EC ECF5 FAFC D8E3 F5F5 FFFF 0000"
	$"00FF F5EC F5F5 FAFC F5F5 F5FF F5FF 0000"
	$"00FF F5EC F5F5 FAFC F5FF FFF5 F5FF 0000"
	$"00FF F5EC F5F5 FAFF FFF5 F5F5 F5FF 0000"
	$"00FF F5EC ECF5 FFF5 F5F5 2BF5 F5FF 0000"
	$"00FF F5EC ECEC F5FA FA2B 2B2B F5FF 0000"
	$"00FF F5EC ECEC F5FA FAF5 2BF5 F5FF 0000"
	$"00FF F5EC ECEC F5F5 F5F8 F5F5 F5FF 0000"
	$"00FF F5EC ECEC F5F5 F8F8 F8F5 F5FF 0000"
	$"00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000"
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'ics8' (130) {
	$"00FF FFFF FFFF FFFF FFFF FFFF FF00 0000"
	$"00FF F5F5 F5F5 F5F5 F5F5 F5F5 FF00 0000"
	$"00FF F5EC ECEC FAFA FAFA FAFA FFFF FF00"
	$"00FF F5EC ECEC FAFC FCFC FCFC FFF5 FF00"
	$"00FF F5EC ECF5 FAFC 05EC F5F5 FFF5 FF00"
	$"00FF F5EC F5F5 FAFC D8E3 F5F5 FFF5 FF00"
	$"00FF F5EC F5F5 FAFC 0000 FFFF FFF5 FF00"
	$"00FF F5EC F5F5 FAFC FFFF F5F5 FFF5 FF00"
	$"00FF F5EC ECF5 FFFF F5F5 F5F5 FFF5 FF00"
	$"00FF F5EC ECEC F5F5 F5F5 F5F5 FFF5 FF00"
	$"00FF F5EC ECEC FAFA F5FF FFFF FFF5 FF00"
	$"00FF F5EC ECEC FAFA F5FF 2BFF F5F5 FF00"
	$"00FF F5F5 F5F5 F5F5 F5FF FFF5 F5F5 FF00"
	$"00FF FFFF FFFF FFFF FFFF F5F5 F5F5 FF00"
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 FF00"
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FF"
};

resource 'ics8' (131) {
	$"00FF FFFF FFFF FFFF FFFF FF00 0000 0000"
	$"00FF F5F5 F5F5 F5F5 F5F5 FFFF 0000 0000"
	$"00FF F5EC ECEC F5F5 F5F5 FF2B FF00 0000"
	$"00FF F5EC ECEC F5F5 F5F5 FFFF FFFF 0000"
	$"00FF F5EC ECEC F5F5 F5F5 F5F5 F5FF 0000"
	$"00FF F5EC ECF5 F5F5 F5F5 F5F5 F5FF 0000"
	$"00FF F5EC FFF5 FFFF F5FF FFF5 F5FF 0000"
	$"00FF F5EC F5F5 F5F5 F5F5 F5F5 F5FF 0000"
	$"00FF F5EC FFFF FFFF F5FF FFF5 F5FF 0000"
	$"00FF F5EC ECF5 F5F5 F5F5 F5F5 F5FF 0000"
	$"00FF F5EC FFFF F5FF FFF5 FFF5 F5FF 0000"
	$"00FF F5EC ECEC F5F5 F5F5 F5F5 F5FF 0000"
	$"00FF F5EC ECEC F5F5 F5F5 F5F5 F5FF 0000"
	$"00FF F5EC ECEC F5F5 F5F5 F5F5 F5FF 0000"
	$"00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000"
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'ics4' (128) {
	$"6660 000F 0000 0000 6660 00FC F000 0000"
	$"6660 0FCC CF00 0000 6660 FC06 DCF0 0000"
	$"666F C061 6DCF 0000 66FC 0666 66DC F000"
	$"6FC0 6606 666D CF00 FCC6 6660 6666 DCD0"
	$"6FCD FFFF FFFF FDCF 66FC F000 0000 DCDA"
	$"666F F0DD 000D CDAF 6660 F0DD 00DC DA0F"
	$"6660 F000 0DCD A00F 6660 F030 0DDA 000F"
	$"6660 F000 D000 000F 6660 FFFF FFFF FFFF"
};

resource 'ics4' (129) {
	$"0FFF FFFF FFF0 0000 0F00 0000 00FF 0000"
	$"0F06 66DD DDF0 F000 0F06 66DE EEFF FF00"
	$"0F06 66DE 1600 0F00 0F06 60DE 3800 FF00"
	$"0F06 00DE 000F 0F00 0F06 00DE 0FF0 0F00"
	$"0F06 00DF F000 0F00 0F06 60F0 00C0 0F00"
	$"0F06 660D DCCC 0F00 0F06 660D D0C0 0F00"
	$"0F06 6600 0C00 0F00 0F06 6600 CCC0 0F00"
	$"0F00 0000 0000 0F00 0FFF FFFF FFFF FF"
};

resource 'ics4' (130) {
	$"0FFF FFFF FFFF F000 0F00 0000 0000 F000"
	$"0F06 66DD DDDD FFF0 0F06 66DE EEEE F0F0"
	$"0F06 60DE 1600 F0F0 0F06 00DE 3800 F0F0"
	$"0F06 00DE 00FF F0F0 0F06 00DE FF00 F0F0"
	$"0F06 60FF 0000 F0F0 0F06 6600 0000 F0F0"
	$"0F06 66FF 0FFF F0F0 0F06 66FF 0F0F 00F0"
	$"0F00 0000 0FF0 00F0 0FFF FFFF FF00 00F0"
	$"000F 0000 0000 00F0 000F FFFF FFFF FFF0"
};

resource 'ics4' (131) {
	$"0FFF FFFF FFF0 0000 0F00 0000 00FF 0000"
	$"0F06 6600 00FC F000 0F06 6600 00FF FF00"
	$"0F06 6600 0000 0F00 0F06 6000 0000 0F00"
	$"0F06 F0FF 0FF0 0F00 0F06 0000 0000 0F00"
	$"0F06 FFFF 0FF0 0F00 0F06 6000 0000 0F00"
	$"0F06 FF0F F0F0 0F00 0F06 6600 0000 0F00"
	$"0F06 6600 0000 0F00 0F06 6600 0000 0F00"
	$"0F00 0000 0000 0F00 0FFF FFFF FFFF FF"
};

resource 'ics#' (128) {
	{	/* array: 2 elements */
		/* [1] */
		$"E100 A280 A440 A920 B290 A548 CAA4 9556"
		$"CFFD A80B BB17 AB2D A859 AA71 A881 EFFF",
		/* [2] */
		$"E100 E380 E7C0 EFE0 FFF0 FFF8 FFFC FFFE"
		$"FFFF FFFF FFFF EFFF EFFF EFFF EFFF EFFF"
	}
};

resource 'ics#' (129) {
	{	/* array: 2 elements */
		/* [1] */
		$"7FE0 4830 4BE8 4A3C 4AC4 52CC 6214 6264"
		$"6184 5224 4DD4 49A4 4844 48E4 4804 7FFC",
		/* [2] */
		$"7FE0 7FF0 7FF8 7FFC 7FFC 7FFC 7FFC 7FFC"
		$"7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC"
	}
};

resource 'ics#' (130) {
	{	/* array: 2 elements */
		/* [1] */
		$"7FF8 4808 4BFE 4A0A 4ACA 52CA 623A 60CA"
		$"530A 4C0A 4B7A 4B52 4862 7FC2 1002 1FFE",
		/* [2] */
		$"7FF8 7FF8 7FFE 7FFE 7FFE 7FFE 7FFE 7FFE"
		$"7FFE 7FFE 7FFE 7FFE 7FFE 7FFE 1FFE 1FFE"
	}
};

resource 'ics#' (131) {
	{	/* array: 2 elements */
		/* [1] */
		$"7FE0 4830 4828 483C 4804 5004 6B64 6004"
		$"6F64 5004 4DA4 4804 4804 4804 4804 7FFC",
		/* [2] */
		$"7FE0 7FF0 7FF8 7FFC 7FFC 7FFC 7FFC 7FFC"
		$"7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC"
	}
};

resource 'ICN#' (128) {
	{	/* array: 2 elements */
		/* [1] */
		$"F801 0000 8802 8000 8804 4000 8808 2000"
		$"8810 1000 8821 0800 8842 8400 8884 4200"
		$"8908 2100 8A14 5080 8C2A A840 8845 5420"
		$"9082 8210 A141 4108 C2A2 A084 8555 5542"
		$"C2AA AAA1 A17F FFFF 90C0 0001 884F 0005"
		$"8C50 800F 8A50 8017 8950 BFAF 88D0 A05D"
		$"884F 20B9 8840 2175 8844 21E5 884A 22C5"
		$"885F 2305 8840 37FD 8840 0001 F87F FFFF",
		/* [2] */
		$"F801 0000 F803 8000 F807 C000 F80F E000"
		$"F81F F000 F83F F800 F87F FC00 F8FF FE00"
		$"F9FF FF00 FBFF FF80 FFFF FFC0 FFFF FFE0"
		$"FFFF FFF0 FFFF FFF8 FFFF FFFC FFFF FFFE"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FBFF FFFF F9FF FFFF F8FF FFFF"
		$"F87F FFFF F87F FFFF F87F FFFF F87F FFFF"
		$"F87F FFFF F87F FFFF F87F FFFF F87F FFFF"
	}
};

resource 'ICN#' (130) {
	{	/* array: 2 elements */
		/* [1] */
		$"3FFF FFF0 2100 0010 217F FFD0 2140 001C"
		$"2140 0014 215F FFD4 2153 0014 2154 8014"
		$"2258 4F34 2458 4054 2454 9D94 2853 0214"
		$"2850 0414 2856 D814 2856 2014 2856 C014"
		$"2851 0F14 2456 1094 2448 2054 2217 F054"
		$"2167 F054 2187 F054 2107 F094 2107 FFF4"
		$"2107 E824 2107 D844 2100 A884 2101 F904"
		$"2100 0A04 3FFF FC04 0800 0004 0FFF FFFC",
		/* [2] */
		$"3FFF FFF0 3FFF FFF0 3FFF FFF0 3FFF FFFC"
		$"3FFF FFFC 3FFF FFFC 3FFF FFFC 3FFF FFFC"
		$"3FFF FFFC 3FFF FFFC 3FFF FFFC 3FFF FFFC"
		$"3FFF FFFC 3FFF FFFC 3FFF FFFC 3FFF FFFC"
		$"3FFF FFFC 3FFF FFFC 3FFF FFFC 3FFF FFFC"
		$"3FFF FFFC 3FFF FFFC 3FFF FFFC 3FFF FFFC"
		$"3FFF FFFC 3FFF FFFC 3FFF FFFC 3FFF FFFC"
		$"3FFF FFFC 3FFF FFFC 0FFF FFFC 0FFF FFFC"
	}
};

resource 'ICN#' (129) {
	{	/* array: 2 elements */
		/* [1] */
		$"3FFF FC00 2100 0600 217F FD00 2140 0480"
		$"2140 0440 214F FC20 2149 87F0 214A 4010"
		$"214C 2790 224C 2030 244A 4ED0 2449 8110"
		$"2848 0210 284B 6C10 284B 1010 284B 6010"
		$"2848 8790 284B 0850 2444 1030 244B F830"
		$"2233 F830 2143 F830 2103 F850 2103 FF90"
		$"2103 FC10 2103 F610 2100 6B10 2100 D590"
		$"2101 FFD0 2100 0010 2100 0010 3FFF FFF0",
		/* [2] */
		$"3FFF FC00 3FFF FE00 3FFF FF00 3FFF FF80"
		$"3FFF FFC0 3FFF FFE0 3FFF FFF0 3FFF FFF0"
		$"3FFF FFF0 3FFF FFF0 3FFF FFF0 3FFF FFF0"
		$"3FFF FFF0 3FFF FFF0 3FFF FFF0 3FFF FFF0"
		$"3FFF FFF0 3FFF FFF0 3FFF FFF0 3FFF FFF0"
		$"3FFF FFF0 3FFF FFF0 3FFF FFF0 3FFF FFF0"
		$"3FFF FFF0 3FFF FFF0 3FFF FFF0 3FFF FFF0"
		$"3FFF FFF0 3FFF FFF0 3FFF FFF0 3FFF FFF0"
	}
};

resource 'ICN#' (131) {
	{	/* array: 2 elements */
		/* [1] */
		$"3FFF FC00 2100 0600 2100 0500 2100 0480"
		$"2100 0440 2100 0420 2100 07F0 2100 0010"
		$"2100 0010 2200 0010 2400 0010 25DD DB10"
		$"2800 0010 2800 0010 29DE F710 2800 0010"
		$"2800 0010 29BF BB10 2400 0010 2400 0010"
		$"2200 0010 2100 0010 2100 0010 2100 0010"
		$"2100 0010 2100 0010 2100 0010 2100 0010"
		$"2100 0010 2100 0010 2100 0010 3FFF FFF0",
		/* [2] */
		$"3FFF FC00 3FFF FE00 3FFF FF00 3FFF FF80"
		$"3FFF FFC0 3FFF FFE0 3FFF FFF0 3FFF FFF0"
		$"3FFF FFF0 3FFF FFF0 3FFF FFF0 3FFF FFF0"
		$"3FFF FFF0 3FFF FFF0 3FFF FFF0 3FFF FFF0"
		$"3FFF FFF0 3FFF FFF0 3FFF FFF0 3FFF FFF0"
		$"3FFF FFF0 3FFF FFF0 3FFF FFF0 3FFF FFF0"
		$"3FFF FFF0 3FFF FFF0 3FFF FFF0 3FFF FFF0"
		$"3FFF FFF0 3FFF FFF0 3FFF FFF0 3FFF FFF0"
	}
};

resource 'icl8' (128) {
	$"ECEC ECEC EC00 0000 0000 0000 0000 00FF"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"ECEC ECEC EC00 0000 0000 0000 0000 FF2B"
	$"FF00 0000 0000 0000 0000 0000 0000 0000"
	$"ECEC ECEC EC00 0000 0000 0000 00FF 2B2B"
	$"2BFF 0000 0000 0000 0000 0000 0000 0000"
	$"ECEC ECEC EC00 0000 0000 0000 FF2B 2B2B"
	$"2B2B FF00 0000 0000 0000 0000 0000 0000"
	$"ECEC ECEC EC00 0000 0000 00FF 2B2B F5FF"
	$"F92B 2BFF 0000 0000 0000 0000 0000 0000"
	$"ECEC ECEC EC00 0000 0000 FF2B 2BF5 FFEC"
	$"FFF9 2B2B FF00 0000 0000 0000 0000 0000"
	$"ECEC ECEC EC00 0000 00FF 2B2B F5FF EC05"
	$"ECFF F92B 2BFF 0000 0000 0000 0000 0000"
	$"ECEC ECEC EC00 0000 FF2B 2BF5 FFEC 0505"
	$"05EC FFF9 2B2B FF00 0000 0000 0000 0000"
	$"ECEC ECEC EC00 00FF 2B2B F5FF ECEC 0505"
	$"0505 ECFF F92B 2BFF 0000 0000 0000 0000"
	$"ECEC ECEC EC00 FF2B 2BF5 FFEC D8EC EC05"
	$"05EC ECEC FFF9 2B2B FF00 0000 0000 0000"
	$"ECEC ECEC ECFF 2B2B F5FF ECEC ECD8 ECEC"
	$"ECEC ECFF ECFF F92B 2BFF 0000 0000 0000"
	$"ECEC ECEC FF2B 2BF5 FFEC 0000 ECEC D8EC"
	$"ECEC FF00 FFEC FFF9 2B2B FF00 0000 0000"
	$"ECEC ECFF 2B2B F5FF ECEC 0000 00EC ECD8"
	$"ECFF 0000 00FF ECFF F92B 2BFF 0000 0000"
	$"ECEC FF2B 2BF5 FFEC ECEC EC00 0000 ECEC"
	$"D8EC FF00 0000 FFEC FFF9 2B2B FF00 0000"
	$"ECFF 2B2B F5FF ECE3 ECEC ECEC 0000 ECEC"
	$"ECD8 ECFF 0000 00FF ECFF F92B 2BFF 0000"
	$"FF2B 2B2B FFEC E3EC E3EC ECEC ECEC 00EC"
	$"ECEC D8EC FF00 FFEC ECEC FFF9 2B2B FF00"
	$"ECFF 2B2B F9FF ECE3 ECE3 ECEC ECEC EC00"
	$"ECEC ECD8 ECFF ECEC ECEC ECFF 2B2B 2BFF"
	$"ECEC FF2B 2BF9 FFEC E3FF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"ECEC ECFF 2B2B F9FF ECFF 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 00FF"
	$"ECEC ECEC FF2B 2BF9 FFFF 0000 FFFF FFFF"
	$"0000 0000 0000 0000 0000 0000 00FA 00FF"
	$"ECEC ECEC ECFF 2B2B F9FF 00FF F9F9 F9F9"
	$"FF00 0000 0000 0000 0000 0000 FA2B FAFF"
	$"ECEC ECEC EC00 FF2B 2BFF 00FF F9F9 F9F9"
	$"FF00 0000 0000 0000 0000 00FA 2BFA FDFF"
	$"ECEC ECEC EC00 00FF 2BFF 00FF F9F9 F9F9"
	$"FF00 FFFF FFFF FFFF FFFF FA2B FAFD FDFF"
	$"ECEC ECEC EC00 0000 FFFF 00FF F9F9 F9F9"
	$"FF00 FF92 9292 9292 92FA 2BFA FDFD 00FF"
	$"ECEC ECEC EC00 0000 00FF 0000 FFFF FFFF"
	$"0000 FF92 9292 9292 FA2B FAFD FDFF 00FF"
	$"ECEC ECEC EC00 0000 00FF 0000 0000 0000"
	$"0000 FF92 9292 92FA 2BFA FDFD 92FF 00FF"
	$"ECEC ECEC EC00 0000 00FF 0000 00FF 0000"
	$"0000 FF92 9292 92FA FAFD FD92 92FF 00FF"
	$"ECEC ECEC EC00 0000 00FF 0000 FFD8 FF00"
	$"0000 FF92 9292 FA2B FDFD 9292 92FF 00FF"
	$"ECEC ECEC EC00 0000 00FF 00FF FFFF FFFF"
	$"0000 FF92 9292 FAFD 9292 9292 92FF 00FF"
	$"ECEC ECEC EC00 0000 00FF 0000 0000 0000"
	$"0000 FFFF FFFF FFFF FFFF FFFF FFFF 00FF"
	$"ECEC ECEC EC00 0000 00FF 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 00FF"
	$"ECEC ECEC EC00 0000 00FF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'icl8' (129) {
	$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5FF FF00 0000 0000 0000 0000"
	$"0000 FFF5 ECEC ECEC ECFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF 2BFF 0000 0000 0000 0000"
	$"0000 FFF5 ECEC ECEC ECFF 2B2B 2B2B 2B2B"
	$"2B2B 2B2B 2BFF 2B2B FF00 0000 0000 0000"
	$"0000 FFF5 ECEC ECEC ECFF 2BF8 F8F8 F8F8"
	$"F8F8 F8F8 F8FF 2B2B 2BFF 0000 0000 0000"
	$"0000 FFF5 ECEC ECEC ECFF 2BF8 FFFF FFFF"
	$"FFFF FFFF FFFF 2B2B 2B2B FF00 0000 0000"
	$"0000 FFF5 ECEC ECEC ECFF 2BF8 FFF5 F505"
	$"ECF5 F5F5 F5FF FFFF FFFF FFFF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECFF 2BF8 FFF5 0505"
	$"ECEC F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECFF 2BF8 FF05 0505"
	$"ECEC ECF5 F5FF FFFF FFF5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC F5FF 2BF8 FFD8 D8D8"
	$"E3E3 E3F5 F5F5 F5F5 F5F5 FFFF 0000 0000"
	$"0000 FFF5 ECEC ECF5 F5FF 2BF8 FFF5 D8D8"
	$"E3E3 F5F5 FFFF FFF5 FFFF F5FF 0000 0000"
	$"0000 FFF5 ECEC ECF5 F5FF 2BF8 FFF5 F5D8"
	$"E3F5 F5F5 F5F5 F5FF F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC F5F5 F5FF 2BF8 FFF5 F5F5"
	$"F5F5 F5F5 F5F5 FFF5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC F5F5 F5FF 2BF8 FFF5 FFFF"
	$"F5FF FFF5 FFFF F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC F5F5 F5FF 2BF8 FFF5 FFFF"
	$"F5F5 F5FF F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC F5F5 F5FF 2BF8 FFF5 FFFF"
	$"F5FF FFF5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC F5F5 F5FF 2BF8 FFF5 F5F5"
	$"FFF5 F5F5 F5FF FFFF FFF5 F5FF 0000 0000"
	$"0000 FFF5 ECEC F5F5 F5FF 2BF8 FFF5 FFFF"
	$"F5F5 F5F5 FFF6 F6F6 F6FF F5FF 0000 0000"
	$"0000 FFF5 ECEC ECF5 F5FF 2BF8 F5FF F5F5"
	$"F5F5 F5FF F6F6 F6F6 F6F6 FFFF 0000 0000"
	$"0000 FFF5 ECEC ECF5 F5FF F5F5 FFF5 FFFF"
	$"FFFF FFFF FFF6 F6F6 F6F6 FFFF 0000 0000"
	$"0000 FFF5 ECEC ECEC F5F5 FFFF F5F5 FFFA"
	$"FAFA FAFA FFF6 F6F6 F6F6 FFFF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECFF F5F5 F5F5 FFFA"
	$"FAFA FAFA FFF6 F6F6 F6F6 FFFF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 FFFA"
	$"FAFA FAFA FFF6 F6F6 F6FF F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 FFFA"
	$"FAFA FAFA FFFF FFFF FFF5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 FFFA"
	$"FAFA FAFF F8FF F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 FFFF"
	$"FFFF FFF8 F8F8 FFF5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5FF F8F8 F8F8 F8FF F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"FFF8 F8F8 F8F8 F8F8 FFF5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5FF"
	$"FFFF FFFF FFFF FFFF FFFF F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'icl8' (130) {
	$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECFF 2B2B 2B2B 2B2B"
	$"2B2B 2B2B 2B2B 2B2B 2B2B F5FF FFFF 0000"
	$"0000 FFF5 ECEC ECEC ECFF 2BF8 F8F8 F8F8"
	$"F8F8 F8F8 F8F8 F8F8 F8F8 F5FF F5FF 0000"
	$"0000 FFF5 ECEC ECEC ECFF 2BFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF F5FF F5FF 0000"
	$"0000 FFF5 ECEC ECEC ECFF 2BFF F5F5 05EC"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF F5FF 0000"
	$"0000 FFF5 ECEC ECEC ECFF 2BFF F505 05EC"
	$"ECF5 F5F5 F5F5 F5F5 F5F5 F5FF F5FF 0000"
	$"0000 FFF5 ECEC ECEC F5FF 2BFF 0505 05EC"
	$"ECEC F5F5 FFFF FFFF F5F5 FFFF F5FF 0000"
	$"0000 FFF5 ECEC ECF5 F5FF 2BFF D8D8 D8E3"
	$"E3E3 F5F5 F5F5 F5F5 F5FF F5FF F5FF 0000"
	$"0000 FFF5 ECEC ECF5 F5FF 2BFF F5D8 D8E3"
	$"E3F5 F5FF FFFF F5FF FFF5 F5FF F5FF 0000"
	$"0000 FFF5 ECEC F5F5 F5FF 2BFF F5F5 D8E3"
	$"F5F5 F5F5 F5F5 FFF5 F5F5 F5FF F5FF 0000"
	$"0000 FFF5 ECEC F5F5 F5FF 2BFF F5F5 F5F5"
	$"F5F5 F5F5 F5FF F5F5 F5F5 F5FF F5FF 0000"
	$"0000 FFF5 ECEC F5F5 F5FF 2BFF F5FF FFF5"
	$"FFFF F5FF FFF5 F5F5 F5F5 F5FF F5FF 0000"
	$"0000 FFF5 ECEC F5F5 F5FF 2BFF F5FF FFF5"
	$"F5F5 FFF5 F5F5 F5F5 F5F5 F5FF F5FF 0000"
	$"0000 FFF5 ECEC F5F5 F5FF 2BFF F5FF FFF5"
	$"FFFF F5F5 F5F5 F5F5 F5F5 F5FF F5FF 0000"
	$"0000 FFF5 ECEC F5F5 F5FF 2BFF F5F5 F5FF"
	$"F5F5 F5F5 FFFF FFFF F5F5 F5FF F5FF 0000"
	$"0000 FFF5 ECEC ECF5 F5FF 2BFF F5FF FFF5"
	$"F5F5 F5FF F6F6 F6F6 FFF5 F5FF F5FF 0000"
	$"0000 FFF5 ECEC ECF5 F5FF 2B00 FFF5 F5F5"
	$"F5F5 FFF6 F6F6 2BF6 F6FF F5FF F5FF 0000"
	$"0000 FFF5 ECEC ECEC F5F5 F5FF F5FF FFFF"
	$"FFFF FFFF F6F6 F6F6 F6FF F5FF F5FF 0000"
	$"0000 FFF5 ECEC ECEC ECFF FFF5 F5FF FAFA"
	$"FAFA FAFF F6F6 F6F6 F6FF F5FF F5FF 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5FF FAFA"
	$"FAFA FAFF F62B F6F6 F6FF F5FF F5FF 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5FF FAFA"
	$"FAFA FAFF F6F6 F6F6 FFF5 F5FF F5FF 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5FF FAFA"
	$"FAFA FAFF FFFF FFFF FFFF FFFF F5FF 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5FF FAFA"
	$"FAFA FFF8 FF2B 2B2B 2B2B FFF5 F5FF 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5FF FFFF"
	$"FFFF F8F8 FF2B 2B2B 2BFF F5F5 F5FF 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"FFF8 F8F8 FF2B 2B2B FFF5 F5F5 F5FF 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5FF"
	$"FFFF FFFF FF2B 2BFF F5F5 F5F5 F5FF 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 FF2B FFF5 F5F5 F5F5 F5FF 0000"
	$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF F5F5 F5F5 F5F5 F5FF 0000"
	$"0000 0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000"
	$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'icl8' (131) {
	$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5FF FF00 0000 0000 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5FF 2BFF 0000 0000 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5FF 2B2B FF00 0000 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5FF 2B2B 2BFF 0000 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5FF 2B2B 2B2B FF00 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5FF FFFF FFFF FFFF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECF5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECFF FFFF F5FF FFFF F5FF"
	$"FFFF F5FF FFF5 FFFF F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC F5FF FFFF F5FF FFFF FFF5"
	$"FFFF FFFF F5FF FFFF F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC F5FF FFF5 FFFF FFFF FFFF"
	$"FFF5 FFFF FFF5 FFFF F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECF5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECF5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 ECEC ECEC ECF5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'icl4' (128) {
	$"6666 6000 0000 000F 0000 0000 0000 0000"
	$"6666 6000 0000 00FC F000 0000 0000 0000"
	$"6666 6000 0000 0FCC CF00 0000 0000 0000"
	$"6666 6000 0000 FCCC CCF0 0000 0000 0000"
	$"6666 6000 000F CC0F DCCF 0000 0000 0000"
	$"6666 6000 00FC C0F6 FDCC F000 0000 0000"
	$"6666 6000 0FCC 0F61 6FDC CF00 0000 0000"
	$"6666 6000 FCC0 F611 16FD CCF0 0000 0000"
	$"6666 600F CC0F 6611 116F DCCF 0000 0000"
	$"6666 60FC C0F6 3661 1666 FDCC F000 0000"
	$"6666 6FCC 0F66 6366 666F 6FDC CF00 0000"
	$"6666 FCC0 F600 6636 66F0 F6FD CCF0 0000"
	$"666F CC0F 6600 0663 6F00 0F6F DCCF 0000"
	$"66FC C0F6 6660 0066 36F0 00F6 FDCC F000"
	$"6FCC 0F68 6666 0066 636F 000F 6FDC CF00"
	$"FCCC F686 8666 6606 6636 F0F6 66FD CCF0"
	$"6FCC DF68 6866 6660 6663 6F66 666F CCCF"
	$"66FC CDF6 8FFF FFFF FFFF FFFF FFFF FFFF"
	$"666F CCDF 6F00 0000 0000 0000 0000 000F"
	$"6666 FCCD FF00 FFFF 0000 0000 0000 0D0F"
	$"6666 6FCC DF0F DDDD F000 0000 0000 DCDF"
	$"6666 60FC CF0F DDDD F000 0000 000D CDFF"
	$"6666 600F CF0F DDDD F0FF FFFF FFDC DFFF"
	$"6666 6000 FF0F DDDD F0F8 0808 0DCD FF0F"
	$"6666 6000 0F00 FFFF 00F0 8080 DCDF FF0F"
	$"6666 6000 0F00 0000 00F8 080D CDFF 0F0F"
	$"6666 6000 0F00 0F00 00F0 808D DFF0 8F0F"
	$"6666 6000 0F00 F3F0 00F8 08DC FF08 0F0F"
	$"6666 6000 0F0F FFFF 00F0 80DF 8080 8F0F"
	$"6666 6000 0F00 0000 00FF FFFF FFFF FF0F"
	$"6666 6000 0F00 0000 0000 0000 0000 000F"
	$"6666 6000 0FFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'icl4' (129) {
	$"00FF FFFF FFFF FFFF FFFF FF00 0000 0000"
	$"00F0 0000 0000 0000 0000 0FF0 0000 0000"
	$"00F0 6666 6FFF FFFF FFFF FF0F 0000 0000"
	$"00F0 6666 6FCC CCCC CCCC CF00 F000 0000"
	$"00F0 6666 6FCD DDDD DDDD DF00 0F00 0000"
	$"00F0 6666 6FCD FFFF FFFF FF00 00F0 0000"
	$"00F0 6666 6FCD F001 6000 0FFF FFFF 0000"
	$"00F0 6666 6FCD F011 6600 0000 000F 0000"
	$"00F0 6666 6FCD F111 6660 0FFF F00F 0000"
	$"00F0 6666 0FCD F333 8880 0000 00FF 0000"
	$"00F0 6660 0FCD F033 8800 FFF0 FF0F 0000"
	$"00F0 6660 0FCD F003 8000 000F 000F 0000"
	$"00F0 6600 0FCD F000 0000 00F0 000F 0000"
	$"00F0 6600 0FCD F0FF 0FF0 FF00 000F 0000"
	$"00F0 6600 0FCD F0FF 000F 0000 000F 0000"
	$"00F0 6600 0FCD F0FF 0FF0 0000 000F 0000"
	$"00F0 6600 0FCD F000 F000 0FFF F00F 0000"
	$"00F0 6600 0FCD F0FF 0000 F0C0 CF0F 0000"
	$"00F0 6660 0FCD 0F00 000F 0C0C 0CFF 0000"
	$"00F0 6660 0F00 F0FF FFFF F0C0 C0FF 0000"
	$"00F0 6666 00FF 00FD DDDD FC0C 0CFF 0000"
	$"00F0 6666 6F00 00FD DDDD F0C0 C0FF 0000"
	$"00F0 6666 6000 00FD DDDD FC0C 0F0F 0000"
	$"00F0 6666 6000 00FD DDDD FFFF F00F 0000"
	$"00F0 6666 6000 00FD DDDF CF00 000F 0000"
	$"00F0 6666 6000 00FF FFFC DCF0 000F 0000"
	$"00F0 6666 6000 0000 0FCD CDCF 000F 0000"
	$"00F0 6666 6000 0000 FCDC DCDC F00F 0000"
	$"00F0 6666 6000 000F FFFF FFFF FF0F 0000"
	$"00F0 6666 6000 0000 0000 0000 000F 0000"
	$"00F0 0000 0000 0000 0000 0000 000F 0000"
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'icl4' (130) {
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF 0000"
	$"00F0 0000 0000 0000 0000 0000 000F 0000"
	$"00F0 6666 6FFF FFFF FFFF FFFF FF0F 0000"
	$"00F0 6666 6FCC CCCC CCCC CCCC CC0F FF00"
	$"00F0 6666 6FCC CCCC CCCC CCCC CC0F 0F00"
	$"00F0 6666 6FCF FFFF FFFF FFFF FF0F 0F00"
	$"00F0 6666 6FCF 0016 0000 0000 000F 0F00"
	$"00F0 6666 6FCF 0116 6000 0000 000F 0F00"
	$"00F0 6666 0FCF 1116 6600 FFFF 00FF 0F00"
	$"00F0 6660 0FCF 3338 8800 0000 0F0F 0F00"
	$"00F0 6660 0FCF 0338 800F FF0F F00F 0F00"
	$"00F0 6600 0FCF 0038 0000 00F0 000F 0F00"
	$"00F0 6600 0FCF 0000 0000 0F00 000F 0F00"
	$"00F0 6600 0FCF 0FF0 FF0F F000 000F 0F00"
	$"00F0 6600 0FCF 0FF0 00F0 0000 000F 0F00"
	$"00F0 6600 0FCF 0FF0 FF00 0000 000F 0F00"
	$"00F0 6600 0FCF 000F 0000 FFFF 000F 0F00"
	$"00F0 6660 0FCF 0FF0 000F 0C0C F00F 0F00"
	$"00F0 6660 0FC0 F000 00F0 C0C0 CF0F 0F00"
	$"00F0 6666 000F 0FFF FFFF 0C0C 0F0F 0F00"
	$"00F0 6666 6FF0 0FDD DDDF C0C0 CF0F 0F00"
	$"00F0 6666 6000 0FDD DDDF 0C0C 0F0F 0F00"
	$"00F0 6666 6000 0FDD DDDF C0C0 F00F 0F00"
	$"00F0 6666 6000 0FDD DDDF FFFF FFFF 0F00"
	$"00F0 6666 6000 0FDD DDFC F000 00F0 0F00"
	$"00F0 6666 6000 0FFF FFCD F000 0F00 0F00"
	$"00F0 6666 6000 0000 FCDC F000 F000 0F00"
	$"00F0 6666 6000 000F FFFF F00F 0000 0F00"
	$"00F0 0000 0000 0000 0000 F0F0 0000 0F00"
	$"00FF FFFF FFFF FFFF FFFF FF00 0000 0F00"
	$"0000 F000 0000 0000 0000 0000 0000 0F00"
	$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FF"
};

resource 'icl4' (131) {
	$"00FF FFFF FFFF FFFF FFFF FF00 0000 0000"
	$"00F0 0000 0000 0000 0000 0FF0 0000 0000"
	$"00F0 6666 6000 0000 0000 0FCF 0000 0000"
	$"00F0 6666 6000 0000 0000 0FCC F000 0000"
	$"00F0 6666 6000 0000 0000 0FCC CF00 0000"
	$"00F0 6666 6000 0000 0000 0FCC CCF0 0000"
	$"00F0 6666 6000 0000 0000 0FFF FFFF 0000"
	$"00F0 6666 6000 0000 0000 0000 000F 0000"
	$"00F0 6666 6000 0000 0000 0000 000F 0000"
	$"00F0 6666 0000 0000 0000 0000 000F 0000"
	$"00F0 6660 0000 0000 0000 0000 000F 0000"
	$"00F0 666F FF0F FF0F FF0F F0FF 000F 0000"
	$"00F0 6600 0000 0000 0000 0000 000F 0000"
	$"00F0 6600 0000 0000 0000 0000 000F 0000"
	$"00F0 660F FF0F FFF0 FFFF 0FFF 000F 0000"
	$"00F0 6600 0000 0000 0000 0000 000F 0000"
	$"00F0 6600 0000 0000 0000 0000 000F 0000"
	$"00F0 660F F0FF FFFF F0FF F0FF 000F 0000"
	$"00F0 6660 0000 0000 0000 0000 000F 0000"
	$"00F0 6660 0000 0000 0000 0000 000F 0000"
	$"00F0 6666 0000 0000 0000 0000 000F 0000"
	$"00F0 6666 6000 0000 0000 0000 000F 0000"
	$"00F0 6666 6000 0000 0000 0000 000F 0000"
	$"00F0 6666 6000 0000 0000 0000 000F 0000"
	$"00F0 6666 6000 0000 0000 0000 000F 0000"
	$"00F0 6666 6000 0000 0000 0000 000F 0000"
	$"00F0 6666 6000 0000 0000 0000 000F 0000"
	$"00F0 6666 6000 0000 0000 0000 000F 0000"
	$"00F0 6666 6000 0000 0000 0000 000F 0000"
	$"00F0 6666 6000 0000 0000 0000 000F 0000"
	$"00F0 0000 0000 0000 0000 0000 000F 0000"
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'BNDL' (128) {
	'SVsd',
	0,
	{	/* array TypeArray: 2 elements */
		/* [1] */
		'FREF',
		{	/* array IDArray: 4 elements */
			/* [1] */
			0, 128,
			/* [2] */
			1, 129,
			/* [3] */
			2, 130,
			/* [4] */
			3, 131
		},
		/* [2] */
		'ICN#',
		{	/* array IDArray: 4 elements */
			/* [1] */
			0, 128,
			/* [2] */
			1, 129,
			/* [3] */
			2, 130,
			/* [4] */
			3, 131
		}
	}
};

resource 'FREF' (128) {
	'APPL',
	0,
	""
};

resource 'FREF' (129) {
	'SVsd',
	1,
	""
};

resource 'FREF' (130) {
	'sVsd',
	2,
	""
};

resource 'FREF' (131) {
	'TEXT',
	3,
	""
};
