/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: MacabDatabaseMetaData.cxx,v $
 * $Revision: 1.4 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_connectivity.hxx"

#include "MacabDatabaseMetaData.hxx"
#include "MacabAddressBook.hxx"
#include "MacabHeader.hxx"
#include "MacabGroup.hxx"
#include "macabutilities.hxx"

#ifndef CONNECTIVITY_MACAB_DRIVER_HXX_
#include "MacabDriver.hxx"
#endif
#include "FDatabaseMetaDataResultSet.hxx"
#include "OTypeInfo.hxx"
#include <com/sun/star/sdbc/ColumnValue.hpp>
#include <com/sun/star/sdbc/ResultSetType.hpp>
#include <com/sun/star/sdbc/TransactionIsolation.hpp>

#include <vector>

using namespace connectivity::macab;
using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::beans;
using namespace com::sun::star::sdbc;

MacabDatabaseMetaData::MacabDatabaseMetaData(MacabConnection* _pCon) 
		: m_xConnection(_pCon),
		  m_bUseCatalog(sal_True)
{
	OSL_ENSURE(_pCon,"MacabDatabaseMetaData::MacabDatabaseMetaData: No connection set!");

	osl_incrementInterlockedCount( &m_refCount );
	m_bUseCatalog	= !(usesLocalFiles() || usesLocalFilePerTable());
	osl_decrementInterlockedCount( &m_refCount );
}
// -------------------------------------------------------------------------
MacabDatabaseMetaData::~MacabDatabaseMetaData()
{
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getCatalogSeparator(  ) throw(SQLException, RuntimeException)
{
	::rtl::OUString aVal;
	if (m_bUseCatalog)
	{ // do some special here for you database
	}

	return aVal;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxBinaryLiteralLength(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxRowSize(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxCatalogNameLength(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxCharLiteralLength(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxColumnNameLength(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxColumnsInIndex(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxCursorNameLength(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxConnections(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxColumnsInTable(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxStatementLength(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxTableNameLength(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxTablesInSelect(  ) throw(SQLException, RuntimeException)
{
	// MaxTablesInSelect describes how many tables can participate in the FROM part of a given SELECT statement,
	// currently, the resultset/statement implementations can cope with one table only
	sal_Int32 nValue = 1;
	return nValue;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::doesMaxRowSizeIncludeBlobs(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::storesLowerCaseQuotedIdentifiers(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::storesLowerCaseIdentifiers(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::storesMixedCaseQuotedIdentifiers(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::storesMixedCaseIdentifiers(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::storesUpperCaseQuotedIdentifiers(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::storesUpperCaseIdentifiers(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsAlterTableWithAddColumn(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsAlterTableWithDropColumn(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxIndexLength(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsNonNullableColumns(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getCatalogTerm(  ) throw(SQLException, RuntimeException)
{
	::rtl::OUString aVal;
	if (m_bUseCatalog)
	{
	}
	return aVal;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getIdentifierQuoteString(  ) throw(SQLException, RuntimeException)
{
	// normally this is "
	::rtl::OUString aVal = ::rtl::OUString::createFromAscii("\"");
	return aVal;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getExtraNameCharacters(  ) throw(SQLException, RuntimeException)
{
	::rtl::OUString aVal;
	return aVal;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsDifferentTableCorrelationNames(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::isCatalogAtStart(  ) throw(SQLException, RuntimeException)
{
	sal_Bool bValue = sal_False;
	if (m_bUseCatalog)
	{
	}
	return bValue;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::dataDefinitionIgnoredInTransactions(  ) throw(SQLException, RuntimeException)
{
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::dataDefinitionCausesTransactionCommit(  ) throw(SQLException, RuntimeException)
{
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsDataManipulationTransactionsOnly(  ) throw(SQLException, RuntimeException)
{
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsDataDefinitionAndDataManipulationTransactions(  ) throw(SQLException, RuntimeException)
{
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsPositionedDelete(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsPositionedUpdate(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsOpenStatementsAcrossRollback(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsOpenStatementsAcrossCommit(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsOpenCursorsAcrossCommit(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsOpenCursorsAcrossRollback(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsTransactionIsolationLevel( sal_Int32 ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsSchemasInDataManipulation(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsANSI92FullSQL(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsANSI92EntryLevelSQL(  ) throw(SQLException, RuntimeException)
{
	return sal_True; // should be supported at least
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsIntegrityEnhancementFacility(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsSchemasInIndexDefinitions(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsSchemasInTableDefinitions(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsCatalogsInTableDefinitions(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsCatalogsInIndexDefinitions(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsCatalogsInDataManipulation(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsOuterJoins(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxStatements(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxProcedureNameLength(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxSchemaNameLength(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsTransactions(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::allProceduresAreCallable(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsStoredProcedures(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsSelectForUpdate(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::allTablesAreSelectable(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::isReadOnly(  ) throw(SQLException, RuntimeException)
{
	// for the moment, we have read-only addresses, but this might change in the future
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::usesLocalFiles(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::usesLocalFilePerTable(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsTypeConversion(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::nullPlusNonNullIsNull(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsColumnAliasing(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsTableCorrelationNames(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsConvert( sal_Int32, sal_Int32 ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsExpressionsInOrderBy(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsGroupBy(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsGroupByBeyondSelect(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsGroupByUnrelated(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsMultipleTransactions(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsMultipleResultSets(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsLikeEscapeClause(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsOrderByUnrelated(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsUnion(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsUnionAll(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsMixedCaseIdentifiers(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsMixedCaseQuotedIdentifiers(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::nullsAreSortedAtEnd(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::nullsAreSortedAtStart(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::nullsAreSortedHigh(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::nullsAreSortedLow(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsSchemasInProcedureCalls(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsSchemasInPrivilegeDefinitions(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsCatalogsInProcedureCalls(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsCatalogsInPrivilegeDefinitions(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsCorrelatedSubqueries(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsSubqueriesInComparisons(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsSubqueriesInExists(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsSubqueriesInIns(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsSubqueriesInQuantifieds(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsANSI92IntermediateSQL(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getURL(  ) throw(SQLException, RuntimeException)
{
	// if someday we support more than the default address book,
	// this method should return the URL which was used to create it
	::rtl::OUString aValue = ::rtl::OUString::createFromAscii("sdbc:address:macab:");
	return aValue;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getUserName(  ) throw(SQLException, RuntimeException)
{
	::rtl::OUString aValue;
	return aValue;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getDriverName(  ) throw(SQLException, RuntimeException)
{
	::rtl::OUString aValue = ::rtl::OUString::createFromAscii("macab");
	return aValue;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getDriverVersion() throw(SQLException, RuntimeException)
{
	::rtl::OUString aValue = ::rtl::OUString::createFromAscii(MACAB_DRIVER_VERSION);
	return aValue;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getDatabaseProductVersion(  ) throw(SQLException, RuntimeException)
{
	::rtl::OUString aValue;
	return aValue;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getDatabaseProductName(  ) throw(SQLException, RuntimeException)
{
	::rtl::OUString aValue;
	return aValue;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getProcedureTerm(  ) throw(SQLException, RuntimeException)
{
	::rtl::OUString aValue;
	return aValue;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getSchemaTerm(  ) throw(SQLException, RuntimeException)
{
	::rtl::OUString aValue;
	return aValue;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getDriverMajorVersion(  ) throw(RuntimeException)
{
	return MACAB_DRIVER_VERSION_MAJOR;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getDefaultTransactionIsolation(  ) throw(SQLException, RuntimeException)
{
	return TransactionIsolation::NONE;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getDriverMinorVersion(  ) throw(RuntimeException)
{
	return MACAB_DRIVER_VERSION_MINOR;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getSQLKeywords(  ) throw(SQLException, RuntimeException)
{
	::rtl::OUString aValue;
	return aValue;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getSearchStringEscape(  ) throw(SQLException, RuntimeException)
{
	::rtl::OUString aValue;
	return aValue;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getStringFunctions(  ) throw(SQLException, RuntimeException)
{
	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getTimeDateFunctions(  ) throw(SQLException, RuntimeException)
{
	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getSystemFunctions(  ) throw(SQLException, RuntimeException)
{
	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL MacabDatabaseMetaData::getNumericFunctions(  ) throw(SQLException, RuntimeException)
{
	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsExtendedSQLGrammar(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsCoreSQLGrammar(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsMinimumSQLGrammar(  ) throw(SQLException, RuntimeException)
{
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsFullOuterJoins(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsLimitedOuterJoins(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxColumnsInGroupBy(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxColumnsInOrderBy(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxColumnsInSelect(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL MacabDatabaseMetaData::getMaxUserNameLength(  ) throw(SQLException, RuntimeException)
{
	sal_Int32 nValue = 0; // 0 means no limit
	return nValue;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsResultSetType( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	switch (setType)
	{
		case ResultSetType::FORWARD_ONLY:
		case ResultSetType::SCROLL_INSENSITIVE:
			return sal_True;
	}
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsResultSetConcurrency( sal_Int32 setType, sal_Int32 ) throw(SQLException, RuntimeException)
{
	switch (setType)
	{
		case ResultSetType::FORWARD_ONLY:
		case ResultSetType::SCROLL_INSENSITIVE:
			return sal_True;
	}
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::ownUpdatesAreVisible( sal_Int32 ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::ownDeletesAreVisible( sal_Int32 ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::ownInsertsAreVisible( sal_Int32 ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::othersUpdatesAreVisible( sal_Int32 ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::othersDeletesAreVisible( sal_Int32 ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::othersInsertsAreVisible( sal_Int32 ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::updatesAreDetected( sal_Int32 ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::deletesAreDetected( sal_Int32 ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::insertsAreDetected( sal_Int32 ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL MacabDatabaseMetaData::supportsBatchUpdates(  ) throw(SQLException, RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
Reference< XConnection > SAL_CALL MacabDatabaseMetaData::getConnection(  ) throw(SQLException, RuntimeException)
{
	return (Reference< XConnection >) m_xConnection.get();
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getTableTypes(  ) throw(SQLException, RuntimeException)
{
	::connectivity::ODatabaseMetaDataResultSet* pResult = new ::connectivity::ODatabaseMetaDataResultSet(ODatabaseMetaDataResultSet::eTableTypes);
	Reference< XResultSet > xRef = pResult;

	static ODatabaseMetaDataResultSet::ORows aRows;
	static const ::rtl::OUString aTable(::rtl::OUString::createFromAscii("TABLE"));

	if (aRows.empty())
	{
		ODatabaseMetaDataResultSet::ORow aRow(2);
		aRow[0] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[1] = new ORowSetValueDecorator(aTable);
		aRows.push_back(aRow);
	}
	pResult->setRows(aRows);
	return xRef;
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getTypeInfo(  ) throw(SQLException, RuntimeException)
{
	ODatabaseMetaDataResultSet* pResult = new ODatabaseMetaDataResultSet(ODatabaseMetaDataResultSet::eTypeInfo);
	Reference< XResultSet > xRef = pResult;

	static ODatabaseMetaDataResultSet::ORows aRows;
	if (aRows.empty())
	{
		ODatabaseMetaDataResultSet::ORow aRow(19);

		// We support four types: char, timestamp, integer, float
		aRow[0] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[1] = new ORowSetValueDecorator(::rtl::OUString::createFromAscii("CHAR"));
		aRow[2] = new ORowSetValueDecorator(DataType::CHAR);
		aRow[3] = new ORowSetValueDecorator((sal_Int32) 254);
		aRow[4] = ODatabaseMetaDataResultSet::getQuoteValue();
		aRow[5] = ODatabaseMetaDataResultSet::getQuoteValue();
		aRow[6] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[7] = new ORowSetValueDecorator((sal_Int32) ColumnValue::NULLABLE);
		aRow[8] = ODatabaseMetaDataResultSet::get1Value();
		aRow[9] = new ORowSetValueDecorator((sal_Int32) ColumnSearch::CHAR);
		aRow[10] = ODatabaseMetaDataResultSet::get1Value();
		aRow[11] = ODatabaseMetaDataResultSet::get0Value();
		aRow[12] = ODatabaseMetaDataResultSet::get0Value();
		aRow[13] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[14] = ODatabaseMetaDataResultSet::get0Value();
		aRow[15] = ODatabaseMetaDataResultSet::get0Value();
		aRow[16] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[17] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[18] = new ORowSetValueDecorator((sal_Int32) 10);

		aRows.push_back(aRow);

		aRow[1] = new ORowSetValueDecorator(::rtl::OUString::createFromAscii("TIMESTAMP"));
		aRow[2] = new ORowSetValueDecorator(DataType::TIMESTAMP);
		aRow[3] = new ORowSetValueDecorator((sal_Int32)19);
		aRow[4] = ODatabaseMetaDataResultSet::getQuoteValue();
		aRow[5] = ODatabaseMetaDataResultSet::getQuoteValue();
		aRows.push_back(aRow);

		aRow[1] = new ORowSetValueDecorator(::rtl::OUString::createFromAscii("INTEGER"));
		aRow[2] = new ORowSetValueDecorator(DataType::INTEGER);
		aRow[3] = new ORowSetValueDecorator((sal_Int32)20);
		aRow[15] = new ORowSetValueDecorator((sal_Int32)20);
		aRows.push_back(aRow);

		aRow[1] = new ORowSetValueDecorator(::rtl::OUString::createFromAscii("FLOAT"));
		aRow[2] = new ORowSetValueDecorator(DataType::FLOAT);
		aRow[3] = new ORowSetValueDecorator((sal_Int32)20);
		aRow[15] = new ORowSetValueDecorator((sal_Int32)15);
		aRows.push_back(aRow);
	}
	pResult->setRows(aRows);
	return xRef;
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getCatalogs(  ) throw(SQLException, RuntimeException)
{
    return new ODatabaseMetaDataResultSet( ODatabaseMetaDataResultSet::eCatalogs );
}
// -----------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getSchemas(  ) throw(SQLException, RuntimeException)
{
    return new ODatabaseMetaDataResultSet( ODatabaseMetaDataResultSet::eSchemas );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getColumnPrivileges( 
	const Any&, const ::rtl::OUString&, const ::rtl::OUString&, 
	const ::rtl::OUString& ) throw(SQLException, RuntimeException)
{
    return new ODatabaseMetaDataResultSet( ODatabaseMetaDataResultSet::eColumnPrivileges );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getColumns( 
	const Any&,
	const ::rtl::OUString&,
	const ::rtl::OUString& tableNamePattern, 
	const ::rtl::OUString& columnNamePattern) throw(SQLException, RuntimeException)
{
	::connectivity::ODatabaseMetaDataResultSet* pResult = new ::connectivity::ODatabaseMetaDataResultSet(::connectivity::ODatabaseMetaDataResultSet::eColumns);
	Reference< XResultSet > xRef = pResult;
	MacabRecords *aRecords;
	::rtl::OUString sTableName;

	aRecords = m_xConnection->getAddressBook()->getMacabRecordsMatch(tableNamePattern);

	ODatabaseMetaDataResultSet::ORows aRows;
	if(aRecords != NULL)
	{
		MacabHeader *aHeader = aRecords->getHeader();
		sTableName = aRecords->getName();

		ODatabaseMetaDataResultSet::ORow aRow(19);

		aRow[0] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[1] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[2] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[3] = new ORowSetValueDecorator(sTableName);
		aRow[8] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[9] = ODatabaseMetaDataResultSet::get0Value();
		aRow[10] = new ORowSetValueDecorator((sal_Int32) 10);
		aRow[11] = ODatabaseMetaDataResultSet::get1Value();
		aRow[12] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[13] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[14] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[15] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[16] = new ORowSetValueDecorator((sal_Int32) 254);
		aRow[18] = new ORowSetValueDecorator(::rtl::OUString::createFromAscii("YES"));

		sal_Int32 nPosition = 1;
		::rtl::OUString sName;

		MacabHeader::iterator aField;

		for (	aField = aHeader->begin();
				aField != aHeader->end();
				++aField, ++nPosition)
		{

			sName = CFStringToOUString((CFStringRef) (*aField)->value);
			if (match(columnNamePattern, sName, '\0'))
			{
				aRow[4] = new ORowSetValueDecorator(sName);
				aRow[17] = new ORowSetValueDecorator(nPosition);
				switch((*aField)->type)
				{
					case kABStringProperty:
						aRow[5] = new ORowSetValueDecorator(DataType::CHAR);
						aRow[6] = new ORowSetValueDecorator(::rtl::OUString::createFromAscii("CHAR"));
						aRow[7] = new ORowSetValueDecorator((sal_Int32) 256);
						aRows.push_back(aRow);
						break;
					case kABDateProperty:
						aRow[5] = new ORowSetValueDecorator(DataType::TIMESTAMP);
						aRow[6] = new ORowSetValueDecorator(::rtl::OUString::createFromAscii("TIMESTAMP"));
						aRows.push_back(aRow);
						break;
					case kABIntegerProperty:
						aRow[5] = new ORowSetValueDecorator(DataType::INTEGER);
						aRow[6] = new ORowSetValueDecorator(::rtl::OUString::createFromAscii("INTEGER"));
						aRow[7] = new ORowSetValueDecorator((sal_Int32) 20);
						aRows.push_back(aRow);
						break;
					case kABRealProperty:
						aRow[5] = new ORowSetValueDecorator(DataType::FLOAT);
						aRow[6] = new ORowSetValueDecorator(::rtl::OUString::createFromAscii("FLOAT"));
						aRow[7] = new ORowSetValueDecorator((sal_Int32) 15);
						aRows.push_back(aRow);
						break;
					default:
						;
						// shouldn't happen -- throw an error...?
				}
			}
		}
	}
	pResult->setRows(aRows);
	return xRef;
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getTables( 
	const Any&,
	const ::rtl::OUString&,
	const ::rtl::OUString&,
	const Sequence< ::rtl::OUString >& types) throw(SQLException, RuntimeException)
{
	ODatabaseMetaDataResultSet* pResult = new ODatabaseMetaDataResultSet(::connectivity::ODatabaseMetaDataResultSet::eTables);
	Reference< XResultSet > xRef = pResult;

	// check whether we have tables in the requested types
	// for the moment, we answer only the "TABLE" table type
	// when no types are given at all, we return all the tables
	static const ::rtl::OUString aTable(::rtl::OUString::createFromAscii("TABLE"));
	sal_Bool bTableFound = sal_False;
	const ::rtl::OUString* p = types.getConstArray(),
	                     * pEnd = p + types.getLength();

	if (p == pEnd)
	{
		bTableFound = sal_True;
	}
	else while (p < pEnd)
	{
		if (match(*p, aTable, '\0'))
		{
			bTableFound = sal_True;
			break;
		}
		p++;
	}
	if (!bTableFound)
		return xRef;

	static ODatabaseMetaDataResultSet::ORows aRows;

	if (aRows.empty())
	{
		ODatabaseMetaDataResultSet::ORow aRow(6);

		MacabRecords *xRecords = m_xConnection->getAddressBook()->getMacabRecords();
		::std::vector<MacabGroup *> xGroups = m_xConnection->getAddressBook()->getMacabGroups();
		sal_Int32 i, nGroups;
		nGroups = xGroups.size();
		
		aRow[0] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[1] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[2] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[3] = new ORowSetValueDecorator(xRecords->getName());
		aRow[4] = new ORowSetValueDecorator(aTable);
		aRow[5] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRows.push_back(aRow);

		for(i = 0; i < nGroups; i++)
		{
			aRow[3] = new ORowSetValueDecorator(xGroups[i]->getName());
			aRows.push_back(aRow);
		}
	}
	pResult->setRows(aRows);
	return xRef;
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getProcedureColumns( 
	const Any&, const ::rtl::OUString&, 
	const ::rtl::OUString&, const ::rtl::OUString& ) throw(SQLException, RuntimeException)
{
    return new ODatabaseMetaDataResultSet( ODatabaseMetaDataResultSet::eProcedureColumns );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getProcedures( 
	const Any&, const ::rtl::OUString&, 
	const ::rtl::OUString& ) throw(SQLException, RuntimeException)
{
    return new ODatabaseMetaDataResultSet( ODatabaseMetaDataResultSet::eProcedures );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getVersionColumns( 
	const Any&, const ::rtl::OUString&, const ::rtl::OUString& table ) throw(SQLException, RuntimeException)
{
    return new ODatabaseMetaDataResultSet( ODatabaseMetaDataResultSet::eVersionColumns );

	::connectivity::ODatabaseMetaDataResultSet* pResult = new ::connectivity::ODatabaseMetaDataResultSet(::connectivity::ODatabaseMetaDataResultSet::eVersionColumns);
	Reference< XResultSet > xRef = pResult;

	ODatabaseMetaDataResultSet::ORows aRows;

	if (m_xConnection->getAddressBook()->getMacabRecords(table) != NULL)
	{
		ODatabaseMetaDataResultSet::ORow aRow( 9 );

		::rtl::OUString sName = CFStringToOUString(kABModificationDateProperty);

		aRow[0] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[1] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[2] = new ORowSetValueDecorator(sName);
		aRow[3] = new ORowSetValueDecorator(DataType::TIMESTAMP);
		aRow[4] = new ORowSetValueDecorator(::rtl::OUString::createFromAscii("TIMESTAMP"));

		aRow[5] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[6] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[7] = ODatabaseMetaDataResultSet::getEmptyValue();
		aRow[8] = ODatabaseMetaDataResultSet::getEmptyValue();

		aRows.push_back(aRow);
	}
	pResult->setRows(aRows);
	return xRef;
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getExportedKeys( 
	const Any&, const ::rtl::OUString&, const ::rtl::OUString& ) throw(SQLException, RuntimeException)
{
    return new ODatabaseMetaDataResultSet( ODatabaseMetaDataResultSet::eExportedKeys );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getImportedKeys( 
	const Any&, const ::rtl::OUString&, const ::rtl::OUString& ) throw(SQLException, RuntimeException)
{
    return new ODatabaseMetaDataResultSet( ODatabaseMetaDataResultSet::eImportedKeys );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getPrimaryKeys( 
	const Any&, const ::rtl::OUString&, const ::rtl::OUString& ) throw(SQLException, RuntimeException)
{
    return new ODatabaseMetaDataResultSet( ODatabaseMetaDataResultSet::ePrimaryKeys );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getIndexInfo( 
	const Any&, const ::rtl::OUString&, const ::rtl::OUString&, 
	sal_Bool, sal_Bool ) throw(SQLException, RuntimeException)
{
    return new ODatabaseMetaDataResultSet( ODatabaseMetaDataResultSet::eIndexInfo );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getBestRowIdentifier( 
	const Any&, const ::rtl::OUString&, const ::rtl::OUString&, sal_Int32, 
	sal_Bool ) throw(SQLException, RuntimeException)
{
    return new ODatabaseMetaDataResultSet( ODatabaseMetaDataResultSet::eBestRowIdentifier );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getTablePrivileges( 
	const Any&, const ::rtl::OUString&, const ::rtl::OUString& ) throw(SQLException, RuntimeException)
{
    return new ODatabaseMetaDataResultSet( ODatabaseMetaDataResultSet::eTablePrivileges );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getCrossReference( 
	const Any&, const ::rtl::OUString&, 
	const ::rtl::OUString&, const Any&, 
	const ::rtl::OUString&, const ::rtl::OUString& ) throw(SQLException, RuntimeException)
{
    return new ODatabaseMetaDataResultSet( ODatabaseMetaDataResultSet::eCrossReference );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL MacabDatabaseMetaData::getUDTs( const Any&, const ::rtl::OUString&, const ::rtl::OUString&, const Sequence< sal_Int32 >& ) throw(SQLException, RuntimeException)
{
	OSL_ENSURE(0,"Not implemented yet!");
	throw SQLException();
}
// -----------------------------------------------------------------------------
