
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: environment.h 1390 2006-10-17 13:01:21Z mschwerin $
 *
 */

#ifndef HAVE_ENVIRONMENT_H
#define HAVE_ENVIRONMENT_H
#ifdef __cplusplus
extern "C" {
#endif

#include "oxine.h"
#include "disc.h"

device_entry_t *devicelist_first (void);
device_entry_t *devicelist_next (device_entry_t * device_entry);

const char *get_dir_home (void);
const char *get_dir_oxine (void);
const char *get_dir_oxine_cache (void);
const char *get_dir_oxine_tmp (void);
const char *get_dir_oxine_playlists (void);

const char *get_file_config (void);

const char *get_file_mediamarks_music (void);
const char *get_file_mediamarks_video (void);
const char *get_file_mediamarks_media (void);

const char *get_file_playlist_rw (void);

const char *get_file_lirc_config (void);
const char *get_file_jsw_config (void);
const char *get_file_dvb_channels (void);
const char *get_file_favorites (void);

char *get_dirname (const char *mrl);
char *get_basename (const char *mrl);
char *get_thumbnail (const char *mrl);

int mkdir_recursive (const char *mrl, mode_t mode);
int file_is_newer (const char *mrl1, const char *mrl2);

char *filename_escape_to_uri (const char *filename);
char *filename_escape_for_shell (const char *filename);

void environment_free (void);
void environment_config_register_all (void);

char *read_entire_file (const char *mrl, int *size);
char *resolve_softlink (const char *mrl);

#ifdef __cplusplus
}
#endif
#endif /* HAVE_ENVIRONMENT_H */
