
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: heap.h 1182 2006-09-22 07:53:33Z mschwerin $
 */

#ifndef HAVE_HEAP_H
#define HAVE_HEAP_H
#ifdef __cplusplus
extern "C" {
#endif

#include <string.h>
#include <stdlib.h>
#include <sys/types.h>

#ifdef USE_OXINE_HEAP_MANAGEMENT

/* semipublic functions*/
void *_gen_malloc (char *file, int line, size_t size);
void *_gen_free (void *);
void *_gen_realloc (char *file, int line, void *ptr, size_t size);
char *_gen_strdup (char *file, int line, const char *ptr);

void heapstat (void);

#define ho_malloc(size)             (_gen_malloc(__FILE__, __LINE__, (size_t)size))
#define ho_realloc(ptr, size)       (_gen_realloc(__FILE__, __LINE__, ptr, (size_t)size))
#define ho_free(ptr)                (_gen_free(ptr))

#define ho_new(type)                (_gen_malloc(__FILE__, __LINE__, sizeof(type)))
#define ho_strdup(ptr)              (_gen_strdup(__FILE__, __LINE__, ptr))

#else /* USE_OXINE_HEAP_MANAGEMENT */

/* semipublic functions*/
inline void *_gen_malloc (size_t);
inline void *_gen_free (void *);
inline void heapstat (void);

#define ho_malloc(size)             (_gen_malloc ((size_t)size))
#define ho_realloc(ptr, size)       (realloc (ptr, (size_t)size))
#define ho_free(ptr)                (_gen_free (ptr))

#define ho_new(type)                (_gen_malloc ((size_t)sizeof(type)))
#define ho_strdup(ptr)              (strdup (ptr))

#endif /* USE_OXINE_HEAP_MANAGEMENT */

char *_gen_strdup_printf (char *, int, const char *, ...);
#define ho_strdup_printf(...)       (_gen_strdup_printf(__FILE__, __LINE__, __VA_ARGS__))

#ifdef __cplusplus
}
#endif
#endif /* HAVE_HEAP_H */
