/* places-glib: A GObject wrapper for the Mozilla Places API
 *
 * Copyright (C) 2009  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <dbus/dbus-glib.h>
#include <glib.h>
#include <string.h>

#include "places-error.h"
#include "places-error-private.h"
#include "places-enum-types.h"

#define PLACES_ERROR_PREFIX "org.moblin.places.History."

GQuark
places_error_quark (void)
{
  return g_quark_from_static_string (PLACES_ERROR_QUARK_STRING);
}

void
_places_error_translate_from_dbus (GError **error)
{
  if (error && *error
      && (*error)->domain == DBUS_GERROR
      && (*error)->code == DBUS_GERROR_REMOTE_EXCEPTION)
    {
      const gchar *name = dbus_g_error_get_name (*error);

      if (g_str_has_prefix (name, PLACES_ERROR_PREFIX))
        {
          GEnumClass *enum_class = g_type_class_ref (PLACES_TYPE_ERROR);
          GEnumValue *enum_value;

          enum_value
            = g_enum_get_value_by_nick (enum_class,
                                        name + strlen (PLACES_ERROR_PREFIX));
          if (enum_value)
            {
              GError *new_error = g_error_new_literal (PLACES_ERROR,
                                                       enum_value->value,
                                                       (*error)->message);
              g_error_free (*error);

              *error = new_error;
            }

          g_type_class_unref (enum_class);
        }
    }
}
