/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          BatteryInfoDialog.cpp

Description:

    This file implements class BatteryInfoDialog.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#include "include/BatteryInfoDialog.h"
#include "include/PMTrayIcon.h"

//(*InternalHeaders(BatteryInfoDialog)
#include <wx/bitmap.h>
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
//*)

//(*IdInit(BatteryInfoDialog)
const long BatteryInfoDialog::ID_STATICBITMAP_BATTERYINFOTOP = wxNewId();
const long BatteryInfoDialog::ID_STATICBOX_UI_POWERSTATUS = wxNewId();
const long BatteryInfoDialog::ID_STATICBOX_UI_BATTERYINFORMATION = wxNewId();
const long BatteryInfoDialog::ID_BUTTON_OK = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_UI_POWERSOURCE = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_UI_BATTERYREMAIN = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_POWERSOURCE = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_BatteryRemain = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_UI_BATTERYNAME = wxNewId();
const long BatteryInfoDialog::ID_COMBOBOX_BATTERYNAME = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_UI_BATTERYSTATUS = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_BATTERYSTATUS = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_UI_REMAINCAPACITY = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_REMAINCAPACITY = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_UI_REMAINPERCENTAGE = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_REMAINPERCENTAGE = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_UI_FULLCHARGE = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_FULLCHARGE = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_UI_REMAINTIME = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_REMAINTIME = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_UI_DESIGNCAPACITY = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_DESIGNCAPACITY = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_UI_VOLTAGE = wxNewId();
const long BatteryInfoDialog::ID_STATICTEXT_VOLTAGE = wxNewId();
//*)

BEGIN_EVENT_TABLE(BatteryInfoDialog,wxDialog)
	//(*EventTable(BatteryInfoDialog)
	//*)
END_EVENT_TABLE()

/**Constructor*/
BatteryInfoDialog::BatteryInfoDialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(BatteryInfoDialog)
	Create(parent, id, _("Battery Information"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxSize(435,386));
	Move(wxDefaultPosition);
	StaticBitmap_BatteryInfoTop = new wxStaticBitmap(this, ID_STATICBITMAP_BATTERYINFOTOP, wxBitmap(wxImage(_T("/etc/ipower-management/pictures/BatteryInfo_Banner.png"))), wxPoint(0,5), wxDefaultSize, 0, _T("ID_STATICBITMAP_BATTERYINFOTOP"));
	StaticBox_UI_PowerStatus = new wxStaticBox(this, ID_STATICBOX_UI_POWERSTATUS, _("Power Status"), wxPoint(12,57), wxSize(410,68), 0, _T("ID_STATICBOX_UI_POWERSTATUS"));
	StaticBox_UI_BatteryInformation = new wxStaticBox(this, ID_STATICBOX_UI_BATTERYINFORMATION, _("Battery Information"), wxPoint(12,135), wxSize(410,214), 0, _T("ID_STATICBOX_UI_BATTERYINFORMATION"));
	Button_OK = new wxButton(this, ID_BUTTON_OK, _("Close"), wxPoint(341,354), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BUTTON_OK"));
	Button_OK->SetDefault();
	StaticText_UI_PowerSource = new wxStaticText(this, ID_STATICTEXT_UI_POWERSOURCE, _("Current power source:"), wxPoint(25,78), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_POWERSOURCE"));
	StaticText_UI_BatteryRemain = new wxStaticText(this, ID_STATICTEXT_UI_BATTERYREMAIN, _("Total battery power remaining:"), wxPoint(25,100), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_BATTERYREMAIN"));
	StaticText_PowerSource = new wxStaticText(this, ID_STATICTEXT_POWERSOURCE, _("Battery"), wxPoint(255,78), wxDefaultSize, 0, _T("ID_STATICTEXT_POWERSOURCE"));
	StaticText_BatteryRemain = new wxStaticText(this, ID_STATICTEXT_BatteryRemain, _("--"), wxPoint(255,100), wxDefaultSize, 0, _T("ID_STATICTEXT_BatteryRemain"));
	StaticText_UI_BatteryName = new wxStaticText(this, ID_STATICTEXT_UI_BATTERYNAME, _("Battery Name:"), wxPoint(25,158), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_BATTERYNAME"));
	ComboBox_BatteryName = new wxComboBox(this, ID_COMBOBOX_BATTERYNAME, wxEmptyString, wxPoint(230,153), wxSize(150,25), 0, 0, wxCB_READONLY|wxCB_DROPDOWN|wxHSCROLL, wxDefaultValidator, _T("ID_COMBOBOX_BATTERYNAME"));
	wxFont ComboBox_BatteryNameFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	ComboBox_BatteryName->SetFont(ComboBox_BatteryNameFont);
	StaticText_UI_BatteryStatus = new wxStaticText(this, ID_STATICTEXT_UI_BATTERYSTATUS, _("Battery Status:"), wxPoint(25,186), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_BATTERYSTATUS"));
	StaticText_BatteryStatus = new wxStaticText(this, ID_STATICTEXT_BATTERYSTATUS, _("--"), wxPoint(230,186), wxDefaultSize, 0, _T("ID_STATICTEXT_BATTERYSTATUS"));
    StaticText_UI_RemainPercentage = new wxStaticText(this, ID_STATICTEXT_UI_REMAINPERCENTAGE, _("Remaining Percentage:"), wxPoint(25,212), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_REMAINPERCENTAGE"));
	StaticText_RemainPercentage = new wxStaticText(this, ID_STATICTEXT_REMAINPERCENTAGE, _("--"), wxPoint(230,212), wxDefaultSize, 0, _T("ID_STATICTEXT_REMAINPERCENTAGE"));
	StaticText_UI_RemainTime = new wxStaticText(this, ID_STATICTEXT_UI_REMAINTIME, _("Remaining Time:"), wxPoint(25,238), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_REMAINTIME"));
	StaticText_RemainTime = new wxStaticText(this, ID_STATICTEXT_REMAINTIME, _("--"), wxPoint(230,238), wxSize(11,17), 0, _T("ID_STATICTEXT_REMAINTIME"));
	StaticText_UI_FullCharge = new wxStaticText(this, ID_STATICTEXT_UI_FULLCHARGE, _("Full Charge Capacity:"), wxPoint(25,264), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_FULLCHARGE"));
	StaticText_FullCharge = new wxStaticText(this, ID_STATICTEXT_FULLCHARGE, _("--"), wxPoint(230,264), wxDefaultSize, 0, _T("ID_STATICTEXT_FULLCHARGE"));
	StaticText_UI_DesignCapacity = new wxStaticText(this, ID_STATICTEXT_UI_DESIGNCAPACITY, _("Design Capacity:"), wxPoint(25,290), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_DESIGNCAPACITY"));
	StaticText_DesignCapacity = new wxStaticText(this, ID_STATICTEXT_DESIGNCAPACITY, _("--"), wxPoint(230,290), wxDefaultSize, 0, _T("ID_STATICTEXT_DESIGNCAPACITY"));
	StaticText_UI_Voltage = new wxStaticText(this, ID_STATICTEXT_UI_VOLTAGE, _("Voltage:"), wxPoint(25,316), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_VOLTAGE"));
	StaticText_Voltage = new wxStaticText(this, ID_STATICTEXT_VOLTAGE, _("--"), wxPoint(230,316), wxDefaultSize, 0, _T("ID_STATICTEXT_VOLTAGE"));

	Connect(ID_BUTTON_OK,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&BatteryInfoDialog::OnButton_OKClick);
	Connect(ID_COMBOBOX_BATTERYNAME,wxEVT_COMMAND_COMBOBOX_SELECTED,(wxObjectEventFunction)&BatteryInfoDialog::OnComboBox_BatteryNameSelect);
	//*)

	Connect(wxID_ANY,wxEVT_CLOSE_WINDOW,(wxObjectEventFunction)&BatteryInfoDialog::OnClose);

	//Set UI String

	SetIcon(wxIcon(TITLE_ICON));

    wxFont StaticTextFont(9,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);

    StaticText_UI_PowerSource->SetFont(StaticTextFont);
    StaticText_PowerSource->SetFont(StaticTextFont);
    StaticText_UI_BatteryRemain->SetFont(StaticTextFont);
    StaticText_BatteryRemain->SetFont(StaticTextFont);

    StaticText_UI_BatteryName->SetFont(StaticTextFont);
    ComboBox_BatteryName->SetFont(StaticTextFont);
    StaticText_UI_BatteryStatus->SetFont(StaticTextFont);
    StaticText_BatteryStatus->SetFont(StaticTextFont);
//    StaticText_UI_RemainCapacity->SetFont(StaticTextFont);
//    StaticText_RemainCapacity->SetFont(StaticTextFont);
    StaticText_UI_RemainPercentage->SetFont(StaticTextFont);
    StaticText_RemainPercentage->SetFont(StaticTextFont);
    StaticText_UI_FullCharge->SetFont(StaticTextFont);
    StaticText_FullCharge->SetFont(StaticTextFont);
    StaticText_UI_RemainTime->SetFont(StaticTextFont);
    StaticText_RemainTime->SetFont(StaticTextFont);
    StaticText_UI_DesignCapacity->SetFont(StaticTextFont);
    StaticText_DesignCapacity->SetFont(StaticTextFont);
    StaticText_UI_Voltage->SetFont(StaticTextFont);
    StaticText_Voltage->SetFont(StaticTextFont);

    StatusBmpAC = new wxStaticBitmap(this, wxID_ANY, wxBitmap(wxImage(PIC_PATH + _T("AC.png"))), wxPoint(230, 78), wxDefaultSize);
    StatusBmpDC = new wxStaticBitmap(this, wxID_ANY, wxBitmap(wxImage(PIC_PATH + _T("Battery.png"))), wxPoint(230, 78), wxDefaultSize);
    StatusBmpAC->Hide();
    StatusBmpAC->Hide();


    StaticBox_UI_PowerStatus->SetForegroundColour(wxColour(20,80,190));
    StaticBox_UI_BatteryInformation->SetForegroundColour(wxColour(20,80,190));
}

/**Destructor*/
BatteryInfoDialog::~BatteryInfoDialog()
{
	//(*Destroy(BatteryInfoDialog)
	//*)
}

/**The OK button click event handler*/
void BatteryInfoDialog::OnButton_OKClick(wxCommandEvent& event)
{
    //
    Show(false);
}

/**************************************************************************************************
* Function Name : InitDlg                                                                         *
* Description  : Initial the BatteryInfoDialg                                                     *
* Date   : 08/07/20                                                                               *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void BatteryInfoDialog::InitDlg()
{
    unsigned long batteryCount = 0;
    BatteryInfoMgmtProxy::PM_GetBatteriesCount(batteryCount);

    ComboBox_BatteryName->Clear();
    if (batteryCount > 0)
    {
        for(unsigned long i = 0; i < batteryCount; i++)
        {
            ComboBox_BatteryName->Append(_("Battery") + wxString::Format(wxT("%d"), i + 1));
        }
    }
    else
    {
        StaticText_PowerSource->SetLabel(_("AC Plugged in"));
        StatusBmpAC->Show();
        StatusBmpDC->Hide();
        StaticText_BatteryRemain->SetLabel(_("--"));
        ComboBox_BatteryName->Enable(false);

        return ;
    }

    ComboBox_BatteryName->SetSelection(0);

    DCS_Battery_Info batteryInfo;

    BatteryInfoMgmtProxy::PM_GetBatteryInfo(&batteryInfo, 0);

    UpdateInfo(&batteryInfo, 0);
}

/**************************************************************************************************
* Function Name : UpdateInfo                                                                      *
* Description  : Update battery info in dialog                                                    *
* Date   : 08/07/20                                                                               *
* Parameter     :  batteryInfo  batteryIndex                                                      *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void BatteryInfoDialog::UpdateInfo(PDCS_Battery_Info batteryInfo, int batteryIndex)
{
    int index = ComboBox_BatteryName->GetCurrentSelection();

    if (index != batteryIndex)
    {
        return ;
    }

    int ac = BatteryInfoMgmtProxy::PM_GetACAdapterStatus();

    if (1 == ac)
    {
        StaticText_PowerSource->SetLabel(_("AC Plugged in"));
        StatusBmpAC->Show();
        StatusBmpDC->Hide();
    }
    else
    {
        StaticText_PowerSource->SetLabel(_("Battery"));
        StatusBmpAC->Hide();
        StatusBmpDC->Show();
    }

    if (INVALID_VALUE == batteryInfo->RemainPercent || batteryInfo->RemainPercent > BAT_FULL_CAP)
    {
        StaticText_BatteryRemain->SetLabel(_("--"));
    }
    else
    {

        StaticText_BatteryRemain->SetLabel(wxString::Format(wxT("%d%%"), batteryInfo->RemainPercent));
    }

    wxString state;

    int state_code = batteryInfo->BatteryStatus;

    if (batteryInfo->RemainPercent > 0 && batteryInfo->RemainPercent < 10)
    {
        state = _("Critical");
    }
    else if (1 == state_code)
    {
        if (100 == batteryInfo->RemainPercent)
        {
            state = _("Power On Line");
        }
        else
        {
            state = _("Charging");
        }
    }
    else if (2 == state_code)
    {
        state = _("Discharging");
    }
    else if (3 == state_code)
    {
        state = _("Charging/Discharging");
    }
    else
    {
        if (100 == batteryInfo->RemainPercent)
        {
            state = _("Power On Line");
        }
        else
        {
            state = _("--");
        }
    }

    StaticText_BatteryStatus->SetLabel(state);

    if (batteryInfo->RemainPercent == INVALID_VALUE || batteryInfo->RemainPercent > BAT_FULL_CAP)
    {
        StaticText_RemainPercentage->SetLabel(wxT("--"));
    }
    else
    {
        StaticText_RemainPercentage->SetLabel(wxString::Format(wxT("%d%%"), batteryInfo->RemainPercent));
    }

    if (batteryInfo->FullChargedCapacity == INVALID_VALUE)
    {
        StaticText_FullCharge->SetLabel(wxT("--"));
    }
    else
    {
        StaticText_FullCharge->SetLabel(wxString::Format(wxT("%d mAH"), batteryInfo->FullChargedCapacity));
    }

    if (INVALID_VALUE == batteryInfo->RemainTime || BAT_NULL_CAP == batteryInfo->RemainTime)
    {
        StaticText_RemainTime->SetLabel(_("--"));
    }
    else if (batteryInfo->RemainTime > BAT_OVER_TIME)
    {
        wxString ws = _("hours");
        StaticText_RemainTime->SetLabel(wxT("04:28 ") + ws);
    }
    else
    {
        StaticText_RemainTime->SetLabel(wxString::Format(wxT("%02d:%02d "), batteryInfo->RemainTime / 60, batteryInfo->RemainTime % 60) + wxT(" ") + _("hours"));
    }

    if (INVALID_VALUE == batteryInfo->DesignedCapacity)
    {
        StaticText_DesignCapacity->SetLabel(_("--"));
    }
    else
    {
        StaticText_DesignCapacity->SetLabel(wxString::Format(wxT("%d mAH"), batteryInfo->DesignedCapacity));
    }

    if (INVALID_VALUE == batteryInfo->Voltage)
    {
        StaticText_Voltage->SetLabel(wxT("--"));
    }
    else
    {
        StaticText_Voltage->SetLabel(wxString::Format(wxT("%d mV"), batteryInfo->Voltage));
    }

}

/**The ComboBox select event handler*/
void BatteryInfoDialog::OnComboBox_BatteryNameSelect(wxCommandEvent& event)
{
    DCS_Battery_Info batteryInfo;
    int index = ComboBox_BatteryName->GetCurrentSelection();
    BatteryInfoMgmtProxy::PM_GetBatteryInfo(&batteryInfo, index);
    UpdateInfo(&batteryInfo, index);
}
/**The windows close event handler*/
void BatteryInfoDialog::OnClose(wxCloseEvent& event)
{
    Show(false);
}
