/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMApp.cpp

Description:

    This file implements class PMApp.

Environment (opt):

    OS: Ubuntu,
    SE: Code::Blocks8.02

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Zhang Hui   2008-7-20

  =====================================================================

****************************************************************************/



#include <wx/file.h>
#include "include/PMApp.h"
#include "include/BatteryInfoMgmtProxy.h"
#include "include/PowerSchemeMgmtProxy.h"
#include "include/PMGlobalConstant.h"
#include "include/PMUtility.h"
#include "include/PMTrayIcon.h"

#include <fstream>
using namespace std;

#include "DCSApi.h"

IMPLEMENT_APP(PMApp);

static const int NOTI_TIMER_ID = 10001;

BEGIN_EVENT_TABLE(PMApp, wxApp)
   // EVT_PAINT(PMBalloonWnd::OnPaint)
   // EVT_LEFT_DOWN(PMBalloonWnd::OnClick)
   EVT_TIMER(NOTI_TIMER_ID, PMApp::CloseNotification)
END_EVENT_TABLE()

/**the initial handler*/
bool PMApp::OnInit()
{
    exit = false;

    wxMilliSleep(10000);

    //check DCS
    if (0 != DCS_Initialize())
    {
        return false;
    }

    m_taskBarIcon = NULL;
    m_notificationtimer = NULL;
    m_notificationDlg = NULL;

    m_iSystemLanguageCode = wxLocale::GetSystemLanguage();

    wxString resource;
    PMUtility::GetLocaleFileName(m_iSystemLanguageCode, resource);

    // Load localizated string resource
    m_locale.AddCatalogLookupPathPrefix(RESOURCE_DIR);

    wxString filePath = RESOURCE_DIR + resource + wxT(".mo");

    if (wxFileExists(filePath))
    {
        m_locale.AddCatalog(resource);
    }
    else
    {
        m_locale.AddCatalog(LANG_DEFAULT_EN);
    }

  //check dependencies
    if (!CheckPicPath())
    {
        wxLogError(_("The pictures for power management have been removed!"));
        return false;
    }

    if (!CheckConfigFiles(resource))
    {
        wxLogError(_("The configure files for power management have been removed!"));
        return false;
    }

    //check autostart
    int isAutoStart = 0;
    ConfigurationFileEditor fileEditor;
    fileEditor.GetAutoStart(isAutoStart);


    if (2 == argc && 0 == isAutoStart)
    {
        return false;
    }


    //initial DCS
    m_pngHandler = new wxPNGHandler();
    wxImage::AddHandler(m_pngHandler);


    //check singleton instance
    if (!PMUtility::GetLock())
    {
        if(PMTrayIcon::IsProtocolSupported())
        {
            PopupNotification();
            exit = true;
            return true;
        }
        else
        {
            system("/etc/ipower-management/startup.sh");
            return false;
        }
    }
    else
    {

        m_taskBarIcon = new PMTrayIcon(2 == argc);


        if (NULL != m_taskBarIcon)
        {
            m_taskBarIcon->Init();
        }
        else
        {
            return false;
        }
        PopupNotification();

        // Modified by Deng Jing on 04/10/2009
        PowerSchemeMgmtProxy::GetInstance()->InitCommonResourceFilePath(resource);
        PowerSchemeMgmtProxy::GetInstance()->InitDefaultResourceFilePath(resource);
        PowerSchemeMgmtProxy::GetInstance()->InitHelpResourceFilePath(resource);

        PowerSchemeMgmtProxy::GetInstance()->InitScheme();

        m_taskBarIcon->StartIdleTimer();

        return true;
    }
}

/**the exit handler*/
int PMApp::OnExit()
{
    if (m_taskBarIcon != NULL)
    {
        delete m_taskBarIcon;
        m_taskBarIcon = NULL;
    }
    if (m_pngHandler != NULL)
    {
        wxImage::RemoveHandler(m_pngHandler->GetName());
       // delete m_pngHandler;
        m_pngHandler = NULL;
    }

    DCS_Uninitialize();

    return EXIT_SUCCESS;
}

/**check the picture resource*/
bool PMApp::CheckPicPath()
{
    return wxDirExists(PIC_PATH.c_str());
}

/**check the configure files*/
bool PMApp::CheckConfigFiles(wxString language)
{
    wxString ipmPath = wxGetHomeDir() + PRIVATE_DIR;

    if (!wxDirExists(ipmPath.c_str()))
    {

        if(!wxMkdir(ipmPath))
        {
            return false;
        }
    }

    bool diff = false;
    wxString languageFile = ipmPath + LANG_FILENAME;

    if (!wxFileExists(languageFile))
    {
        //Create language file and write the language code to the file
        wxFile file;
        if (!file.Create(languageFile, true))
        {
            return false;
        }

        file.Write(language);
        file.Close();
    }
    else
    {
        //Get last language
        ifstream in(PMUtility::WxStringToString(languageFile).c_str());

        string line;
        if(getline(in, line))
        {

            if ( 0 != language.compare(PMUtility::StringToWxString(line)) )
            {
                diff = true;

                wxFile file(languageFile);
                // Write current language to the file
                if ( !file.Open(languageFile, wxFile::write) )
                {
                    return false;
                }

                file.Write(language);
                file.Close();
            }
        }

    }

    wxString optionFile = ipmPath + OPTION_FILENAME;
    wxString schemeFile = ipmPath + SCHEME_FILENAME;
    wxString pathPrex = GLOBAL_CONFIG_DIR + language;

    if (!wxFileExists(optionFile) || diff)
    {
        wxString optionFileBak = pathPrex + OPTION_FILENAME;
        if (wxFileExists(optionFileBak))
        {
            if(!wxCopyFile(optionFileBak, optionFile, true))
            {
                return false;
            }
        }
        else
        {
            return false;
        }
    }

    if (!wxFileExists(schemeFile) || diff)
    {
        wxString schemeFileBak = pathPrex + SCHEME_FILENAME;
        if (wxFileExists(schemeFileBak))
        {
            if(!wxCopyFile(schemeFileBak, schemeFile, true))
            {
                return false;
            }
        }
        else
        {
            return false;
        }
    }

    return true;
}

/**pop up the notification balloon*/
void PMApp::PopupNotification()
{

    if (NULL == m_notificationDlg)
    {
        m_notificationDlg = new PMBalloonWnd(NULL, wxT("balloon"));
        m_notificationDlg->PopupNotification();
    //    m_notificationDlg->Show(false);
        m_notificationDlg->Show(true);

    }
    if (NULL == m_notificationtimer)
    {
        m_notificationtimer = new wxTimer(this, NOTI_TIMER_ID);
    }

    m_notificationtimer->Start(3000, wxTIMER_ONE_SHOT);
}

/**close the notification balloon*/
void PMApp::CloseNotificationHandler()
{
   if (NULL != m_notificationDlg)
    {
        m_notificationDlg->Show(false);
        delete m_notificationDlg;
        m_notificationDlg = NULL;
    }

    if (NULL != m_notificationtimer)
    {

        m_notificationtimer->Stop();
        delete m_notificationtimer;
        m_notificationtimer = NULL;
    }
    if ( exit )
    {
        ::wxExit();
    }
}

/**timer event for close notification balloon*/
void PMApp::CloseNotification(wxTimerEvent & event)
{
    CloseNotificationHandler();
}

