#!/bin/sh

# Created by Fabien Tassin <fta@sofaraway.org> in Sept 2007

# This script creates or updates the 3 files necessary to install a WebApp
# It also *prints to stdout* the control part that could be added to
# debian/control (or could be used to update it).
# It is not part of the build system but it is supposed to be used
# by maintainers.
#
# The list of WebApps, including descriptions and URLs, is taken
# from debian/rules. See ${WEBAPPS}.

APPS=`perl -ne 'BEGIN { $/ = "\n\n" } if (m/^WEBAPPS/) { s/\\\\\n/ /g; s/=//; s/\s+/ /g; s/^(\S+) //; s/ (\S+) $//; print } ' rules`

for app in $APPS ; do
  APP=`echo $app | cut -d@ -f2`
  NAME=`echo $app | cut -d@ -f1 | sed -e 's/^"//'`
  DESCR=`echo $app | cut -d@ -f3 | sed -e 's/~/ /g; s/\\\\//g'`
  URL=`echo $app | cut -d@ -f4`
  CAT=`echo $app | cut -d@ -f5 | sed -e 's/"$//'`

  cat - > prism-$NAME.desktop.new <<EOF
[Desktop Entry]
Version=1.0
Name=$DESCR
GenericName=Prism for $DESCR
Exec=prism-$NAME
Terminal=false
Type=Application
Icon=prism-$NAME
Categories=$CAT
StartupWMClass=Prism
StartupNotify=true
EOF

  cat - > prism-$NAME.install.new <<EOF
debian/tmp/usr/share/prism/apps/$APP.webapp
debian/tmp/usr/share/applications/prism-$NAME.desktop
debian/tmp/usr/share/pixmaps/prism-$NAME.png
EOF

  rm -f prism-$NAME.links.new
  if [ "$APP" != "$NAME" ] ; then
    echo "usr/share/prism/apps/$APP.webapp usr/share/prism/apps/$NAME.webapp" >> prism-$NAME.links.new
  fi
  cat - >> prism-$NAME.links.new <<EOF
usr/bin/prism usr/bin/prism-$NAME
usr/share/man/man1/prism.1.gz usr/share/man/man1/prism-$NAME.1.gz
EOF

  cat - <<EOF

Package: prism-$NAME
Section: net
Architecture: all
Depends: prism
Homepage: $URL
Description: $DESCR WebApp for Prism
 $DESCR WebApp is a Web Application using Prism, a simple
 XULRunner browser for web applications.
EOF

  for type in desktop install links ; do
    if [ -e prism-$NAME.$type ] ; then
      cmp -s prism-$NAME.$type prism-$NAME.$type.new
      if [ $? -eq 1 ] ; then
	echo "Update prism-$NAME.$type (backup in prism-$NAME.$type.old)" >&2
        mv prism-$NAME.$type prism-$NAME.$type.old
        mv prism-$NAME.$type.new prism-$NAME.$type
      else
        rm prism-$NAME.$type.new
      fi
    else
      echo "Install new prism-$NAME.$type" >&2
      mv prism-$NAME.$type.new prism-$NAME.$type
    fi
  done
done
