#
# This file is part of Python Terra
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

import sys
from optparse import OptionParser


def die(msg):
    sys.stderr.write("Error: %s\n" % msg)
    sys.exit(1)


def process_cmdline(option_list=None):
    if option_list is None:
        option_list = []
    parser = OptionParser(option_list=option_list)
    parser.add_option("-c", "--config", action="store", type="string",
                      dest="config_file", help="Terra configuration file")

    opts, args = parser.parse_args()

    if not opts.config_file:
        parser.error("you must provide a Terra configuration file")

    return parser, opts, args
