#!/usr/bin/env python
#
# This file is part of Python Terra
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

import sys
import threading
import ecore

from terra.core.threaded_func import ThreadedFunction


def print_thread(msg):
    print "[%s]:" % threading.currentThread().getName(), msg
    sys.stdout.flush()


def my_func(a, b, c='test'):
    for i in xrange(a):
        print_thread("b = %r, c = %r" % (b, c))
    return "it worked"


def my_func_finished(exception, retval):
    if exception is not None:
        print_thread("my_func raised exception %r" % exception)
        return

    print_thread("my_func returned %r" % retval)
    f = ThreadedFunction(my_func_finished, my_func, "3", "C")
    f.start()


def run_my_func():
    f = ThreadedFunction(my_func_finished, my_func, 3, "B", c="testing...")
    f.start()
    return False


if __name__ == "__main__":
    ecore.idler_add(run_my_func)
    ecore.main_loop_begin()
