#!/usr/bin/python
#
# This file is part of Python Terra
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

import evas
import ecore
import ecore.evas
import terra.ui.layout

ee = ecore.evas.SoftwareX11(w=300, h=300)

canvas = ee.evas

bg = canvas.Rectangle(color=(0, 0, 0, 255))
bg.size = canvas.size
bg.show()
ee.data["bg"] = bg

colors = (
    (255, 0, 0, 255),
    (0, 255, 0, 255),
    (0, 0, 255, 255),
    (255, 255, 0, 255),
    (0, 255, 255, 255),
    (255, 0, 255, 255),
    )

children = []
for c in colors:
    o = canvas.Rectangle(size=(30, 30), color=c)
    o.show()
    children.append(o)

hbox = terra.ui.layout.HBox(canvas, children=children, halign=0.5, valign=0.5)
hbox.size = canvas.size
hbox.show()
ee.data["hbox"] = hbox

def on_resize(ee):
    ee.data["bg"].size = ee.evas.size
    ee.data["hbox"].size = ee.evas.size
ee.callback_resize = on_resize

def on_key_down(obj, event):
    hbox = ee.data["hbox"]
    if event.keyname == "c":
        hbox.clear()
    elif event.keyname == "i":
        c = hbox.color_get()[0]
        c += 10
        if c > 255:
            c = 255
        hbox.color_set(c, c, c, c)
    elif event.keyname == "o":
        c = hbox.color_get()[0]
        c -= 10
        if c < 0:
            c = 0
        hbox.color_set(c, c, c, c)
    elif event.keyname == "Escape":
        ecore.main_loop_quit()
bg.focus = True
bg.on_key_down_add(on_key_down)

ee.show()
ecore.main_loop_begin()
