/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCanvasRenderingContext2D.h"

#include <wtf/GetPtr.h>

#include "CanvasGradient.h"
#include "CanvasPattern.h"
#include "CanvasRenderingContext2D.h"
#include "CanvasStyle.h"
#include "HTMLCanvasElement.h"
#include "ImageData.h"
#include "JSCanvasGradient.h"
#include "JSHTMLCanvasElement.h"
#include "JSImageData.h"
#include "JSTextMetrics.h"
#include "KURL.h"
#include "PlatformString.h"
#include "TextMetrics.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCanvasRenderingContext2D)

/* Hash table */

static const HashTableValue JSCanvasRenderingContext2DTableValues[18] =
{
    { "canvas", DontDelete|ReadOnly, (intptr_t)jsCanvasRenderingContext2DCanvas, (intptr_t)0 },
    { "globalAlpha", DontDelete, (intptr_t)jsCanvasRenderingContext2DGlobalAlpha, (intptr_t)setJSCanvasRenderingContext2DGlobalAlpha },
    { "globalCompositeOperation", DontDelete, (intptr_t)jsCanvasRenderingContext2DGlobalCompositeOperation, (intptr_t)setJSCanvasRenderingContext2DGlobalCompositeOperation },
    { "lineWidth", DontDelete, (intptr_t)jsCanvasRenderingContext2DLineWidth, (intptr_t)setJSCanvasRenderingContext2DLineWidth },
    { "lineCap", DontDelete, (intptr_t)jsCanvasRenderingContext2DLineCap, (intptr_t)setJSCanvasRenderingContext2DLineCap },
    { "lineJoin", DontDelete, (intptr_t)jsCanvasRenderingContext2DLineJoin, (intptr_t)setJSCanvasRenderingContext2DLineJoin },
    { "miterLimit", DontDelete, (intptr_t)jsCanvasRenderingContext2DMiterLimit, (intptr_t)setJSCanvasRenderingContext2DMiterLimit },
    { "shadowOffsetX", DontDelete, (intptr_t)jsCanvasRenderingContext2DShadowOffsetX, (intptr_t)setJSCanvasRenderingContext2DShadowOffsetX },
    { "shadowOffsetY", DontDelete, (intptr_t)jsCanvasRenderingContext2DShadowOffsetY, (intptr_t)setJSCanvasRenderingContext2DShadowOffsetY },
    { "shadowBlur", DontDelete, (intptr_t)jsCanvasRenderingContext2DShadowBlur, (intptr_t)setJSCanvasRenderingContext2DShadowBlur },
    { "shadowColor", DontDelete, (intptr_t)jsCanvasRenderingContext2DShadowColor, (intptr_t)setJSCanvasRenderingContext2DShadowColor },
    { "font", DontDelete, (intptr_t)jsCanvasRenderingContext2DFont, (intptr_t)setJSCanvasRenderingContext2DFont },
    { "textAlign", DontDelete, (intptr_t)jsCanvasRenderingContext2DTextAlign, (intptr_t)setJSCanvasRenderingContext2DTextAlign },
    { "textBaseline", DontDelete, (intptr_t)jsCanvasRenderingContext2DTextBaseline, (intptr_t)setJSCanvasRenderingContext2DTextBaseline },
    { "strokeStyle", DontDelete, (intptr_t)jsCanvasRenderingContext2DStrokeStyle, (intptr_t)setJSCanvasRenderingContext2DStrokeStyle },
    { "fillStyle", DontDelete, (intptr_t)jsCanvasRenderingContext2DFillStyle, (intptr_t)setJSCanvasRenderingContext2DFillStyle },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsCanvasRenderingContext2DConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCanvasRenderingContext2DTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 8191, JSCanvasRenderingContext2DTableValues, 0 };
#else
    { 67, 63, JSCanvasRenderingContext2DTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSCanvasRenderingContext2DConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCanvasRenderingContext2DConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCanvasRenderingContext2DConstructorTableValues, 0 };
#else
    { 1, 0, JSCanvasRenderingContext2DConstructorTableValues, 0 };
#endif

class JSCanvasRenderingContext2DConstructor : public DOMObject {
public:
    JSCanvasRenderingContext2DConstructor(ExecState* exec)
        : DOMObject(JSCanvasRenderingContext2DConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSCanvasRenderingContext2DPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSCanvasRenderingContext2DConstructor::s_info = { "CanvasRenderingContext2DConstructor", 0, &JSCanvasRenderingContext2DConstructorTable, 0 };

bool JSCanvasRenderingContext2DConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCanvasRenderingContext2DConstructor, DOMObject>(exec, &JSCanvasRenderingContext2DConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSCanvasRenderingContext2DPrototypeTableValues[45] =
{
    { "save", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSave, (intptr_t)0 },
    { "restore", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionRestore, (intptr_t)0 },
    { "scale", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionScale, (intptr_t)2 },
    { "rotate", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionRotate, (intptr_t)1 },
    { "translate", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionTranslate, (intptr_t)2 },
    { "transform", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionTransform, (intptr_t)6 },
    { "setTransform", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetTransform, (intptr_t)6 },
    { "createLinearGradient", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient, (intptr_t)4 },
    { "createRadialGradient", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient, (intptr_t)6 },
    { "clearRect", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionClearRect, (intptr_t)4 },
    { "fillRect", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionFillRect, (intptr_t)4 },
    { "beginPath", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionBeginPath, (intptr_t)0 },
    { "closePath", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionClosePath, (intptr_t)0 },
    { "moveTo", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionMoveTo, (intptr_t)2 },
    { "lineTo", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionLineTo, (intptr_t)2 },
    { "quadraticCurveTo", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo, (intptr_t)4 },
    { "bezierCurveTo", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionBezierCurveTo, (intptr_t)6 },
    { "arcTo", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionArcTo, (intptr_t)5 },
    { "rect", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionRect, (intptr_t)4 },
    { "arc", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionArc, (intptr_t)6 },
    { "fill", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionFill, (intptr_t)0 },
    { "stroke", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionStroke, (intptr_t)0 },
    { "clip", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionClip, (intptr_t)0 },
    { "isPointInPath", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath, (intptr_t)2 },
    { "fillText", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionFillText, (intptr_t)0 },
    { "strokeText", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionStrokeText, (intptr_t)0 },
    { "measureText", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionMeasureText, (intptr_t)1 },
    { "setAlpha", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetAlpha, (intptr_t)1 },
    { "setCompositeOperation", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperation, (intptr_t)1 },
    { "setLineWidth", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetLineWidth, (intptr_t)1 },
    { "setLineCap", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetLineCap, (intptr_t)1 },
    { "setLineJoin", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetLineJoin, (intptr_t)1 },
    { "setMiterLimit", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimit, (intptr_t)1 },
    { "clearShadow", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionClearShadow, (intptr_t)0 },
    { "setStrokeColor", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor, (intptr_t)0 },
    { "setFillColor", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetFillColor, (intptr_t)0 },
    { "strokeRect", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionStrokeRect, (intptr_t)0 },
    { "drawImage", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionDrawImage, (intptr_t)0 },
    { "drawImageFromRect", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRect, (intptr_t)0 },
    { "setShadow", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionSetShadow, (intptr_t)0 },
    { "createPattern", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionCreatePattern, (intptr_t)0 },
    { "createImageData", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionCreateImageData, (intptr_t)2 },
    { "getImageData", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionGetImageData, (intptr_t)4 },
    { "putImageData", DontDelete|Function, (intptr_t)jsCanvasRenderingContext2DPrototypeFunctionPutImageData, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCanvasRenderingContext2DPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 4095, JSCanvasRenderingContext2DPrototypeTableValues, 0 };
#else
    { 134, 127, JSCanvasRenderingContext2DPrototypeTableValues, 0 };
#endif

const ClassInfo JSCanvasRenderingContext2DPrototype::s_info = { "CanvasRenderingContext2DPrototype", 0, &JSCanvasRenderingContext2DPrototypeTable, 0 };

JSObject* JSCanvasRenderingContext2DPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSCanvasRenderingContext2D>(exec);
}

bool JSCanvasRenderingContext2DPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCanvasRenderingContext2DPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSCanvasRenderingContext2D::s_info = { "CanvasRenderingContext2D", 0, &JSCanvasRenderingContext2DTable, 0 };

JSCanvasRenderingContext2D::JSCanvasRenderingContext2D(PassRefPtr<Structure> structure, PassRefPtr<CanvasRenderingContext2D> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSCanvasRenderingContext2D::~JSCanvasRenderingContext2D()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSCanvasRenderingContext2D::createPrototype(ExecState* exec)
{
    return new (exec) JSCanvasRenderingContext2DPrototype(JSCanvasRenderingContext2DPrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSCanvasRenderingContext2D::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCanvasRenderingContext2D, Base>(exec, &JSCanvasRenderingContext2DTable, this, propertyName, slot);
}

JSValuePtr jsCanvasRenderingContext2DCanvas(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->canvas()));
}

JSValuePtr jsCanvasRenderingContext2DGlobalAlpha(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->globalAlpha());
}

JSValuePtr jsCanvasRenderingContext2DGlobalCompositeOperation(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->globalCompositeOperation());
}

JSValuePtr jsCanvasRenderingContext2DLineWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->lineWidth());
}

JSValuePtr jsCanvasRenderingContext2DLineCap(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->lineCap());
}

JSValuePtr jsCanvasRenderingContext2DLineJoin(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->lineJoin());
}

JSValuePtr jsCanvasRenderingContext2DMiterLimit(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->miterLimit());
}

JSValuePtr jsCanvasRenderingContext2DShadowOffsetX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->shadowOffsetX());
}

JSValuePtr jsCanvasRenderingContext2DShadowOffsetY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->shadowOffsetY());
}

JSValuePtr jsCanvasRenderingContext2DShadowBlur(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->shadowBlur());
}

JSValuePtr jsCanvasRenderingContext2DShadowColor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->shadowColor());
}

JSValuePtr jsCanvasRenderingContext2DFont(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->font());
}

JSValuePtr jsCanvasRenderingContext2DTextAlign(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->textAlign());
}

JSValuePtr jsCanvasRenderingContext2DTextBaseline(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->textBaseline());
}

JSValuePtr jsCanvasRenderingContext2DStrokeStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSCanvasRenderingContext2D*>(asObject(slot.slotBase()))->strokeStyle(exec);
}

JSValuePtr jsCanvasRenderingContext2DFillStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSCanvasRenderingContext2D*>(asObject(slot.slotBase()))->fillStyle(exec);
}

JSValuePtr jsCanvasRenderingContext2DConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSCanvasRenderingContext2D*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSCanvasRenderingContext2D::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSCanvasRenderingContext2D, Base>(exec, propertyName, value, &JSCanvasRenderingContext2DTable, this, slot);
}

void setJSCanvasRenderingContext2DGlobalAlpha(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(thisObject)->impl());
    imp->setGlobalAlpha(value->toFloat(exec));
}

void setJSCanvasRenderingContext2DGlobalCompositeOperation(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(thisObject)->impl());
    imp->setGlobalCompositeOperation(valueToStringWithNullCheck(exec, value));
}

void setJSCanvasRenderingContext2DLineWidth(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(thisObject)->impl());
    imp->setLineWidth(value->toFloat(exec));
}

void setJSCanvasRenderingContext2DLineCap(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(thisObject)->impl());
    imp->setLineCap(valueToStringWithNullCheck(exec, value));
}

void setJSCanvasRenderingContext2DLineJoin(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(thisObject)->impl());
    imp->setLineJoin(valueToStringWithNullCheck(exec, value));
}

void setJSCanvasRenderingContext2DMiterLimit(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(thisObject)->impl());
    imp->setMiterLimit(value->toFloat(exec));
}

void setJSCanvasRenderingContext2DShadowOffsetX(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(thisObject)->impl());
    imp->setShadowOffsetX(value->toFloat(exec));
}

void setJSCanvasRenderingContext2DShadowOffsetY(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(thisObject)->impl());
    imp->setShadowOffsetY(value->toFloat(exec));
}

void setJSCanvasRenderingContext2DShadowBlur(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(thisObject)->impl());
    imp->setShadowBlur(value->toFloat(exec));
}

void setJSCanvasRenderingContext2DShadowColor(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(thisObject)->impl());
    imp->setShadowColor(valueToStringWithNullCheck(exec, value));
}

void setJSCanvasRenderingContext2DFont(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(thisObject)->impl());
    imp->setFont(value->toString(exec));
}

void setJSCanvasRenderingContext2DTextAlign(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(thisObject)->impl());
    imp->setTextAlign(value->toString(exec));
}

void setJSCanvasRenderingContext2DTextBaseline(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(static_cast<JSCanvasRenderingContext2D*>(thisObject)->impl());
    imp->setTextBaseline(value->toString(exec));
}

void setJSCanvasRenderingContext2DStrokeStyle(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    static_cast<JSCanvasRenderingContext2D*>(thisObject)->setStrokeStyle(exec, value);
}

void setJSCanvasRenderingContext2DFillStyle(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    static_cast<JSCanvasRenderingContext2D*>(thisObject)->setFillStyle(exec, value);
}

JSValuePtr JSCanvasRenderingContext2D::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSCanvasRenderingContext2DConstructor>(exec);
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionSave(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->save();
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionRestore(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->restore();
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionScale(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float sx = args.at(exec, 0)->toFloat(exec);
    float sy = args.at(exec, 1)->toFloat(exec);

    imp->scale(sx, sy);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionRotate(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float angle = args.at(exec, 0)->toFloat(exec);

    imp->rotate(angle);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionTranslate(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float tx = args.at(exec, 0)->toFloat(exec);
    float ty = args.at(exec, 1)->toFloat(exec);

    imp->translate(tx, ty);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionTransform(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float m11 = args.at(exec, 0)->toFloat(exec);
    float m12 = args.at(exec, 1)->toFloat(exec);
    float m21 = args.at(exec, 2)->toFloat(exec);
    float m22 = args.at(exec, 3)->toFloat(exec);
    float dx = args.at(exec, 4)->toFloat(exec);
    float dy = args.at(exec, 5)->toFloat(exec);

    imp->transform(m11, m12, m21, m22, dx, dy);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionSetTransform(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float m11 = args.at(exec, 0)->toFloat(exec);
    float m12 = args.at(exec, 1)->toFloat(exec);
    float m21 = args.at(exec, 2)->toFloat(exec);
    float m22 = args.at(exec, 3)->toFloat(exec);
    float dx = args.at(exec, 4)->toFloat(exec);
    float dy = args.at(exec, 5)->toFloat(exec);

    imp->setTransform(m11, m12, m21, m22, dx, dy);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    float x0 = args.at(exec, 0)->toFloat(exec);
    float y0 = args.at(exec, 1)->toFloat(exec);
    float x1 = args.at(exec, 2)->toFloat(exec);
    float y1 = args.at(exec, 3)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createLinearGradient(x0, y0, x1, y1, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    float x0 = args.at(exec, 0)->toFloat(exec);
    float y0 = args.at(exec, 1)->toFloat(exec);
    float r0 = args.at(exec, 2)->toFloat(exec);
    float x1 = args.at(exec, 3)->toFloat(exec);
    float y1 = args.at(exec, 4)->toFloat(exec);
    float r1 = args.at(exec, 5)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createRadialGradient(x0, y0, r0, x1, y1, r1, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionClearRect(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);
    float width = args.at(exec, 2)->toFloat(exec);
    float height = args.at(exec, 3)->toFloat(exec);

    imp->clearRect(x, y, width, height);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionFillRect(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);
    float width = args.at(exec, 2)->toFloat(exec);
    float height = args.at(exec, 3)->toFloat(exec);

    imp->fillRect(x, y, width, height);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionBeginPath(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->beginPath();
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionClosePath(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->closePath();
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionMoveTo(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);

    imp->moveTo(x, y);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionLineTo(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);

    imp->lineTo(x, y);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float cpx = args.at(exec, 0)->toFloat(exec);
    float cpy = args.at(exec, 1)->toFloat(exec);
    float x = args.at(exec, 2)->toFloat(exec);
    float y = args.at(exec, 3)->toFloat(exec);

    imp->quadraticCurveTo(cpx, cpy, x, y);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionBezierCurveTo(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float cp1x = args.at(exec, 0)->toFloat(exec);
    float cp1y = args.at(exec, 1)->toFloat(exec);
    float cp2x = args.at(exec, 2)->toFloat(exec);
    float cp2y = args.at(exec, 3)->toFloat(exec);
    float x = args.at(exec, 4)->toFloat(exec);
    float y = args.at(exec, 5)->toFloat(exec);

    imp->bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionArcTo(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    float x1 = args.at(exec, 0)->toFloat(exec);
    float y1 = args.at(exec, 1)->toFloat(exec);
    float x2 = args.at(exec, 2)->toFloat(exec);
    float y2 = args.at(exec, 3)->toFloat(exec);
    float radius = args.at(exec, 4)->toFloat(exec);

    imp->arcTo(x1, y1, x2, y2, radius, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionRect(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);
    float width = args.at(exec, 2)->toFloat(exec);
    float height = args.at(exec, 3)->toFloat(exec);

    imp->rect(x, y, width, height);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionArc(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);
    float radius = args.at(exec, 2)->toFloat(exec);
    float startAngle = args.at(exec, 3)->toFloat(exec);
    float endAngle = args.at(exec, 4)->toFloat(exec);
    bool anticlockwise = args.at(exec, 5)->toBoolean(exec);

    imp->arc(x, y, radius, startAngle, endAngle, anticlockwise, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionFill(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->fill();
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionStroke(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->stroke();
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionClip(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->clip();
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);


    JSC::JSValuePtr result = jsBoolean(imp->isPointInPath(x, y));
    return result;
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionFillText(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->fillText(exec, args);
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionStrokeText(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->strokeText(exec, args);
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionMeasureText(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    const UString& text = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->measureText(text)));
    return result;
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionSetAlpha(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float alpha = args.at(exec, 0)->toFloat(exec);

    imp->setAlpha(alpha);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperation(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    const UString& compositeOperation = args.at(exec, 0)->toString(exec);

    imp->setCompositeOperation(compositeOperation);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionSetLineWidth(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float width = args.at(exec, 0)->toFloat(exec);

    imp->setLineWidth(width);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionSetLineCap(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    const UString& cap = args.at(exec, 0)->toString(exec);

    imp->setLineCap(cap);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionSetLineJoin(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    const UString& join = args.at(exec, 0)->toString(exec);

    imp->setLineJoin(join);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimit(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float limit = args.at(exec, 0)->toFloat(exec);

    imp->setMiterLimit(limit);
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionClearShadow(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->clearShadow();
    return jsUndefined();
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->setStrokeColor(exec, args);
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionSetFillColor(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->setFillColor(exec, args);
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionStrokeRect(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->strokeRect(exec, args);
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionDrawImage(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->drawImage(exec, args);
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRect(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->drawImageFromRect(exec, args);
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionSetShadow(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->setShadow(exec, args);
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionCreatePattern(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->createPattern(exec, args);
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionCreateImageData(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float sw = args.at(exec, 0)->toFloat(exec);
    float sh = args.at(exec, 1)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createImageData(sw, sh)));
    return result;
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionGetImageData(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    float sx = args.at(exec, 0)->toFloat(exec);
    float sy = args.at(exec, 1)->toFloat(exec);
    float sw = args.at(exec, 2)->toFloat(exec);
    float sh = args.at(exec, 3)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getImageData(sx, sy, sw, sh, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsCanvasRenderingContext2DPrototypeFunctionPutImageData(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->putImageData(exec, args);
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, CanvasRenderingContext2D* object)
{
    return getDOMObjectWrapper<JSCanvasRenderingContext2D>(exec, object);
}
CanvasRenderingContext2D* toCanvasRenderingContext2D(JSC::JSValuePtr value)
{
    return value->isObject(&JSCanvasRenderingContext2D::s_info) ? static_cast<JSCanvasRenderingContext2D*>(asObject(value))->impl() : 0;
}

}
