/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLBlockquoteElement.h"

#include "HTMLBlockquoteElement.h"
#include "HTMLNames.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLBlockquoteElement);

/* Hash table */

static const HashTableValue JSHTMLBlockquoteElementTableValues[3] =
{
    { "cite", DontDelete, (intptr_t)jsHTMLBlockquoteElementCite, (intptr_t)setJSHTMLBlockquoteElementCite },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLBlockquoteElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLBlockquoteElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSHTMLBlockquoteElementTableValues, 0 };
#else
    { 5, 3, JSHTMLBlockquoteElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLBlockquoteElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLBlockquoteElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLBlockquoteElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLBlockquoteElementConstructorTableValues, 0 };
#endif

class JSHTMLBlockquoteElementConstructor : public DOMConstructorObject {
public:
    JSHTMLBlockquoteElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLBlockquoteElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLBlockquoteElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLBlockquoteElementConstructor::s_info = { "HTMLBlockquoteElementConstructor", 0, &JSHTMLBlockquoteElementConstructorTable, 0 };

bool JSHTMLBlockquoteElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBlockquoteElementConstructor, DOMObject>(exec, &JSHTMLBlockquoteElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLBlockquoteElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLBlockquoteElementConstructor, DOMObject>(exec, &JSHTMLBlockquoteElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLBlockquoteElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLBlockquoteElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLBlockquoteElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLBlockquoteElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLBlockquoteElementPrototype::s_info = { "HTMLBlockquoteElementPrototype", 0, &JSHTMLBlockquoteElementPrototypeTable, 0 };

JSObject* JSHTMLBlockquoteElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLBlockquoteElement>(exec, globalObject);
}

const ClassInfo JSHTMLBlockquoteElement::s_info = { "HTMLBlockquoteElement", &JSHTMLElement::s_info, &JSHTMLBlockquoteElementTable, 0 };

JSHTMLBlockquoteElement::JSHTMLBlockquoteElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLBlockquoteElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLBlockquoteElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLBlockquoteElementPrototype(JSHTMLBlockquoteElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLBlockquoteElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBlockquoteElement, Base>(exec, &JSHTMLBlockquoteElementTable, this, propertyName, slot);
}

bool JSHTMLBlockquoteElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLBlockquoteElement, Base>(exec, &JSHTMLBlockquoteElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLBlockquoteElementCite(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLBlockquoteElement* castedThis = static_cast<JSHTMLBlockquoteElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLBlockquoteElement* imp = static_cast<HTMLBlockquoteElement*>(castedThis->impl());
    return jsString(exec, imp->getAttribute(HTMLNames::citeAttr));
}

JSValue jsHTMLBlockquoteElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLBlockquoteElement* domObject = static_cast<JSHTMLBlockquoteElement*>(asObject(slot.slotBase()));
    return JSHTMLBlockquoteElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLBlockquoteElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLBlockquoteElement, Base>(exec, propertyName, value, &JSHTMLBlockquoteElementTable, this, slot);
}

void setJSHTMLBlockquoteElementCite(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLBlockquoteElement* imp = static_cast<HTMLBlockquoteElement*>(static_cast<JSHTMLBlockquoteElement*>(thisObject)->impl());
    imp->setAttribute(HTMLNames::citeAttr, valueToStringWithNullCheck(exec, value));
}

JSValue JSHTMLBlockquoteElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLBlockquoteElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
