/*
 *
 *  Quick Controller
 *
 *  Copyright (C) 2008-2009  Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "CMPC_QCPAboutDialog.h"
#include "CMPC_QCPSearchFilePath.h"

#include <wx/bitmap.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
#if defined (__UNIX__)
#include <fstream>
#endif

//IdInit for About Dialog
const long AboutDialog::ID_STATICTEXTMODULENAME = wxNewId();
const long AboutDialog::ID_STATICTEXTVERSION = wxNewId();
const long AboutDialog::ID_STATICTEXTCOPYRIGHT = wxNewId();
const long AboutDialog::ID_STATICTEXTALLRIGHT = wxNewId();
const long AboutDialog::ID_BUTTON_OK = wxNewId();
const long AboutDialog::ID_BACKGROUND_IMAGE = wxNewId();
//*)

BEGIN_EVENT_TABLE(AboutDialog, wxDialog)

END_EVENT_TABLE()

/**************************************************************************************************
* Function Name : AboutDialog                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
AboutDialog::AboutDialog(wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size)
{
    wxString ResourcefilePath;
    CSearchFilePath GetFilePath;
    #if defined(__WXMSW__)
    ResourcefilePath = GetFilePath.WindowsGetFilePath();
    ResourcefilePath += wxT("\\");
    #elif defined(__UNIX__)
    ResourcefilePath = GetFilePath.LinuxGetFilePath();
    #endif
    wxLocale LocaleLanguage;  //Language localization
    LocaleLanguage.AddCatalogLookupPathPrefix(ResourcefilePath + wxT("resource"));

    #if defined(__WXMSW__)
    if (true == wxFileExists(ResourcefilePath + wxT("resource/resource.mo")))
    {
        LocaleLanguage.AddCatalog(wxT("resource"));
    }
    #elif defined (__UNIX__)
    int langCode = wxLocale::GetSystemLanguage();
    wxString resource;
    int iRet = GetLocaleFileName(langCode, resource);
    wxString filePath = ResourcefilePath + wxT("resource/")+ resource + wxT(".mo");

    //add iRet > 0 for warning
    if (wxFileExists(filePath) && (iRet > 0))
    {
        LocaleLanguage.AddCatalog(resource);
    }
    else
    {
        LocaleLanguage.AddCatalog(wxT("EN"));
    }
    #endif


	//Initialize About Dialog of QCP
	Create(parent, id, _("About Quick Controller"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE,
        _T("id"));
	SetClientSize(wxSize(350, 230));

    //Set the background of About Dialog
    m_BackGroundImage = new wxStaticBitmap(this, ID_BACKGROUND_IMAGE, wxBitmap(ResourcefilePath +
        wxT("image/about_background.png"), wxBITMAP_TYPE_PNG), wxPoint(0, 0), wxSize(350, 230), 0, _T("ID_BACKGROUND_IMAGE"));

    #if defined(__WXMSW__)
    wxString sVersion = wxT(" 2.0.0.100");
	m_strModuleName = new wxCustomStatic(this, ID_STATICTEXTMODULENAME, _("Quick Controller"),
        wxPoint(92, 70), wxDefaultSize, wxTRANSPARENT_WINDOW, _T("ID_STATICTEXTMODULENAME"));
	m_strVersion = new wxCustomStatic(this, ID_STATICTEXTVERSION, _("Version")+ sVersion,
        wxPoint(92, 90), wxDefaultSize, wxTRANSPARENT_WINDOW, _T("ID_STATICTEXTVERSION"));
	m_strCopyright = new wxCustomStatic(this, ID_STATICTEXTCOPYRIGHT,
        _("Copyright(C) 2008 Intel Corporation."), wxPoint(92, 130),
        wxDefaultSize, wxTRANSPARENT_WINDOW, _T("ID_STATICTEXTCOPYRIGHT"));
	m_strAllRight = new wxCustomStatic(this, ID_STATICTEXTALLRIGHT,
        _("All rights reserved."), wxPoint(92, 150), wxDefaultSize, wxTRANSPARENT_WINDOW,
        _T("ID_STATICTEXTALLRIGHT"));
	m_BtnOK = new wxButton(m_BackGroundImage, ID_BUTTON_OK, _("OK"), wxPoint(252, 196),
        wxSize(75, 23), wxTAB_TRAVERSAL, wxDefaultValidator, _T("ID_BUTTON_OK"));

    #elif defined (__UNIX__)
    wxString sVersion = wxT(" 2.0.0.111");
    wxIcon Icon(ResourcefilePath + wxT("image/qcp.ico"));//Setting the icon on About Dialog
	this->SetIcon(Icon);
    m_strModuleName = new wxStaticText(this, ID_STATICTEXTMODULENAME, _("Quick Controller"),
        wxPoint(92, 70), wxDefaultSize, 0, _T("ID_STATICTEXTMODULENAME"));
	m_strVersion = new wxStaticText(this, ID_STATICTEXTVERSION, _("Version") + sVersion,
        wxPoint(92, 90), wxDefaultSize, 0, _T("ID_STATICTEXTVERSION"));
	m_strCopyright = new wxStaticText(this, ID_STATICTEXTCOPYRIGHT, _("Copyright(C) 2008 Intel Corporation."),
        wxPoint(92, 130), wxDefaultSize, 0, _T("ID_STATICTEXTCOPYRIGHT"));
	m_strAllRight = new wxStaticText(this, ID_STATICTEXTALLRIGHT, _("All rights reserved."),
        wxPoint(92, 150), wxDefaultSize, 0, _T("ID_STATICTEXTALLRIGHT"));
	m_BtnOK = new wxButton(this, ID_BUTTON_OK, _("OK"), wxPoint(252, 190), wxSize(75, 28), wxTAB_TRAVERSAL,
        wxDefaultValidator, _T("ID_BUTTON_OK"));

    #endif

    // Setting the font of module name
    wxFont StaticBoldTextFont(10, wxSWISS, wxFONTWEIGHT_NORMAL, wxBOLD, false, wxEmptyString,
        wxFONTENCODING_DEFAULT);
    m_strModuleName->SetFont(StaticBoldTextFont);

	m_BtnOK->SetDefault();          //Set the default button

	Connect(ID_BUTTON_OK, wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&AboutDialog::OnButton_OKClick);
	Connect(wxID_ANY, wxEVT_CLOSE_WINDOW, (wxObjectEventFunction)&AboutDialog::OnClose);
}

/**************************************************************************************************
* Function Name : ~AboutDialog                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
AboutDialog::~AboutDialog()
{
    //Release resource
	delete m_strModuleName;
	m_strModuleName = NULL;
	delete m_strVersion;
    m_strVersion = NULL;
	delete m_strCopyright;
	m_strCopyright = NULL;
	delete m_strAllRight;
    m_strAllRight = NULL;
	delete m_BtnOK;
	m_BtnOK = NULL;
	delete m_BackGroundImage;
	m_BackGroundImage = NULL;
}

/**************************************************************************************************
* Function Name : OnButton_OKClick                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void AboutDialog::OnButton_OKClick(wxCommandEvent& event)
{
    Destroy(); //Close About Dialog
}

/**************************************************************************************************
* Function Name : OnClose                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void AboutDialog::OnClose(wxCloseEvent& event)
{
    Destroy(); //Close About Dialog
}

#if defined (__UNIX__)
/**************************************************************************************************
* Function Name : GetLocaleFileName                                                     *
* Description  	: Get Local File Name                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
int AboutDialog::GetLocaleFileName(int langCode, wxString& fileName)
{
    wxString ResourcefilePath;
    CSearchFilePath GetFilePath;
    #if defined(__WXMSW__)
    ResourcefilePath = GetFilePath.WindowsGetFilePath();
    ResourcefilePath += wxT("\\");
    #elif defined(__UNIX__)
    ResourcefilePath = GetFilePath.LinuxGetFilePath();
    #endif

    wxString wxMapFile = ResourcefilePath + wxT("resource/langToFile");

    string mapfile = "/usr/share/QuickController/resource/langToFile";

    mapfile = WxStringToString(wxMapFile);

    fileName = wxT("EN");
    ifstream in(mapfile.c_str());

    if (!in)
    {
        return -1;
    }

    char langCodeStr[10] = {'\0'};
    snprintf(langCodeStr, 10, "%d", langCode);
    string line;

    while(getline(in, line))
    {
        string::size_type index = line.find(":");
        if (index == string::npos || index == 0)
        {
            continue;
        }

        if (0 == line.compare(0, index, langCodeStr))
        {
            fileName = StringToWxString(line.substr(index + 1));
            in.close();
            return 1;
        }
    }

    in.close();
    return -1;
}

/**************************************************************************************************
* Function Name : StringToWxString                                                               *
* Description  	: Get Local File Name                                                             *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
wxString AboutDialog::StringToWxString(string stringValue)
{
    wxString temp(stringValue.c_str(), wxConvUTF8);
    return temp;
}

/**************************************************************************************************
* Function Name : WxStringToString                                                               *
* Description  	: Get Local File Name                                                             *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
string AboutDialog::WxStringToString(wxString wxStringValue)
{
    string temp(wxStringValue.mb_str(wxConvUTF8));
    return temp;
}
#endif

