/*
 *
 *  Quick Controller
 *
 *  Copyright (C) 2008-2009  Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/****************************************************************************
File Name:          CMPC_QCPTypeTransfer.cpp

Description:
    This file implements CMPC_QCPTypeTransfer.h
        This class has following functions.

         1.StringToWxString        String transfer to wxString type
         2.WxStringToString        wxString transfer to string type
         3.GetHomeDir              Getting path for check multi instance
         4.GetLock                 Add lock for QCP application under only Linux

Environment (opt):
    OS: Ubuntu
    SE: CodeBlocks
Notes (opt):
  =====================================================================
  Revision   Revision History               Author     Date
  =====================================================================

  0.1        Create                         Deng Jing   2008-7-20

  =====================================================================

****************************************************************************/
#include "CMPC_QCPTypeTransfer.h"
#if defined(__UNIX__)
#include <fcntl.h>
#include <pwd.h>
#endif

/**************************************************************************************************
* Function Name : fStringToWxString                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
wxString CTypeTransfer::fStringToWxString(string stringValue)
{
    wxString temp(stringValue.c_str(), wxConvUTF8);
    return temp;
}

/**************************************************************************************************
* Function Name : fWxStringToString                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
string CTypeTransfer::fWxStringToString(wxString wxStringValue)
{
    string temp(wxStringValue.mb_str(wxConvUTF8));
    return temp;
}

#if defined(__UNIX__)
/**************************************************************************************************
* Function Name : GetHomeDir                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
string CTypeTransfer::GetHomeDir()
{
    char temp[32] = {'\0'};
    char *name = cuserid(temp);
    struct passwd * pw = NULL;

    if (name != NULL)
    {
    	pw = getpwnam(name);
    }
    return pw->pw_dir;
}

/**************************************************************************************************
* Function Name : GetLock                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
int CTypeTransfer::GetLock()
{
    struct flock fl;
    int fdlock = 0;

    fl.l_type = F_WRLCK;
    fl.l_whence = SEEK_SET;
    fl.l_start = 0;
    fl.l_len = 1;

    string file = GetHomeDir() + "/.QCP_lock";
    if((fdlock = open(file.c_str(), O_WRONLY|O_CREAT, 0666)) == -1)
        return 0;

    if(fcntl(fdlock, F_SETLK, &fl) == -1)
        return 0;

    return 1;
}
#endif
